/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen.optimization.common;

import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.codegen.inline.InlineCodegenUtilsKt;
import org.jetbrains.kotlin.codegen.optimization.common.UtilKt;
import org.jetbrains.kotlin.utils.SmartList;
import org.jetbrains.org.objectweb.asm.Type;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.JumpInsnNode;
import org.jetbrains.org.objectweb.asm.tree.LabelNode;
import org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode;
import org.jetbrains.org.objectweb.asm.tree.TryCatchBlockNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0018\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B#\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0002\u0010\nJ\u0019\u0010!\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\f\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0016\u0010'\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r2\u0006\u0010(\u001a\u00020\u0014J\u001b\u0010)\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0000\u00a2\u0006\u0002\b+J\b\u0010,\u001a\u00020$H\u0002J\u001e\u0010-\u001a\u00020$2\u0006\u0010.\u001a\u00020\u001c2\f\u0010/\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u001e\u00100\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u00020\u001cH\u0014J.\u00103\u001a\u00020$2\u0006\u00104\u001a\u0002052\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010(\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\u001cH\u0002J\u001e\u00107\u001a\u00020$2\u0006\u00104\u001a\u0002082\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u001e\u00109\u001a\u00020$2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\r2\u0006\u0010(\u001a\u00020\u001cH\u0002J\u001e\u0010:\u001a\u00020$2\u0006\u00104\u001a\u00020;2\f\u0010*\u001a\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\u0012\u0010<\u001a\u00020\u0005*\b\u0012\u0004\u0012\u00028\u00000\rH\u0002J\f\u0010=\u001a\u00020\u001c*\u00020\u0014H\u0002R\u001e\u0010\u000b\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\r0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001e\u0010\u000f\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00100\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0012R6\u0010\u0013\u001a(\u0012\f\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014 \u0015*\u0014\u0012\u000e\b\u0001\u0012\n \u0015*\u0004\u0018\u00010\u00140\u0014\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lorg/jetbrains/kotlin/codegen/optimization/common/FastMethodAnalyzer;", "V", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Value;", "", "owner", "", "method", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "interpreter", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;", "(Ljava/lang/String;Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;Lorg/jetbrains/org/objectweb/asm/tree/analysis/Interpreter;)V", "frames", "", "Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "handlers", "", "Lorg/jetbrains/org/objectweb/asm/tree/TryCatchBlockNode;", "[Ljava/util/List;", "insnsArray", "Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "kotlin.jvm.PlatformType", "[Lorg/jetbrains/org/objectweb/asm/tree/AbstractInsnNode;", "isMergeNode", "", "getMethod", "()Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "nInsns", "", "queue", "", "queued", "top", "analyze", "()[Lorg/jetbrains/org/objectweb/asm/tree/analysis/Frame;", "checkAssertions", "", "computeExceptionHandlersForEachInsn", "m", "getFrame", "insn", "initLocals", "current", "initLocals$backend", "initMergeNodes", "mergeControlFlowEdge", "dest", "frame", "newFrame", "nLocals", "nStack", "visitJumpInsnNode", "insnNode", "Lorg/jetbrains/org/objectweb/asm/tree/JumpInsnNode;", "insnOpcode", "visitLookupSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/LookupSwitchInsnNode;", "visitOpInsn", "visitTableSwitchInsnNode", "Lorg/jetbrains/org/objectweb/asm/tree/TableSwitchInsnNode;", "dump", "indexOf", "backend"})
public class FastMethodAnalyzer<V extends Value> {
    @NotNull
    private final String owner;
    @NotNull
    private final MethodNode method;
    @NotNull
    private final Interpreter<V> interpreter;
    private final AbstractInsnNode[] insnsArray;
    private final int nInsns;
    @NotNull
    private final boolean[] isMergeNode;
    @NotNull
    private final Frame<V>[] frames;
    @NotNull
    private final List<TryCatchBlockNode>[] handlers;
    @NotNull
    private final boolean[] queued;
    @NotNull
    private final int[] queue;
    private int top;

    public FastMethodAnalyzer(@NotNull String owner, @NotNull MethodNode method, @NotNull Interpreter<V> interpreter2) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(interpreter2, (String)"interpreter");
        this.owner = owner;
        this.method = method;
        this.interpreter = interpreter2;
        this.insnsArray = this.method.instructions.toArray();
        this.nInsns = this.method.instructions.size();
        this.isMergeNode = new boolean[this.nInsns];
        this.frames = new Frame[this.nInsns];
        this.handlers = new List[this.nInsns];
        this.queued = new boolean[this.nInsns];
        this.queue = new int[this.nInsns];
    }

    @NotNull
    public final MethodNode getMethod() {
        return this.method;
    }

    @NotNull
    protected Frame<V> newFrame(int nLocals, int nStack) {
        return new Frame(nLocals, nStack);
    }

    @NotNull
    public final Frame<V>[] analyze() {
        if (this.nInsns == 0) {
            return this.frames;
        }
        this.checkAssertions();
        this.computeExceptionHandlersForEachInsn(this.method);
        this.initMergeNodes();
        Frame<V> current = this.newFrame(this.method.maxLocals, this.method.maxStack);
        Frame<V> handler2 = this.newFrame(this.method.maxLocals, this.method.maxStack);
        this.initLocals$backend(current);
        this.mergeControlFlowEdge(0, current);
        while (this.top > 0) {
            this.top += -1;
            int insn = this.queue[this.top];
            Intrinsics.checkNotNull(this.frames[insn]);
            this.queued[insn] = false;
            AbstractInsnNode insnNode = this.method.instructions.get(insn);
            try {
                Frame<V> f;
                int insnOpcode = insnNode.getOpcode();
                int insnType = insnNode.getType();
                switch (insnType) {
                    case 8: 
                    case 14: 
                    case 15: {
                        this.mergeControlFlowEdge(insn + 1, f);
                        break;
                    }
                    default: {
                        current.init(f).execute(insnNode, this.interpreter);
                        if (insnType == 7) {
                            AbstractInsnNode abstractInsnNode = insnNode;
                            if (abstractInsnNode == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                            }
                            this.visitJumpInsnNode((JumpInsnNode)abstractInsnNode, current, insn, insnOpcode);
                            break;
                        }
                        if (insnType == 12) {
                            AbstractInsnNode abstractInsnNode = insnNode;
                            if (abstractInsnNode == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                            }
                            this.visitLookupSwitchInsnNode((LookupSwitchInsnNode)abstractInsnNode, current);
                            break;
                        }
                        if (insnType == 11) {
                            AbstractInsnNode abstractInsnNode = insnNode;
                            if (abstractInsnNode == null) {
                                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                            }
                            this.visitTableSwitchInsnNode((TableSwitchInsnNode)abstractInsnNode, current);
                            break;
                        }
                        if (insnOpcode == 191 || insnOpcode >= 172 && insnOpcode <= 177) break;
                        this.visitOpInsn(current, insn);
                    }
                }
                List<TryCatchBlockNode> list2 = this.handlers[insn];
                if (list2 == null) continue;
                Iterable $this$forEach$iv = list2;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String string2;
                    String string3;
                    TryCatchBlockNode tcb = (TryCatchBlockNode)element$iv;
                    boolean bl = false;
                    String string4 = string3 = tcb.type;
                    if (string4 == null) {
                        string2 = "java/lang/Throwable";
                    } else {
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"tcb.type ?: \"java/lang/Throwable\"");
                        string2 = string3;
                    }
                    Type exnType = Type.getObjectType((String)string2);
                    LabelNode labelNode = tcb.handler;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.handler");
                    int jump = this.indexOf((AbstractInsnNode)labelNode);
                    handler2.init(f);
                    handler2.clearStack();
                    handler2.push(this.interpreter.newValue(exnType));
                    this.mergeControlFlowEdge(jump, handler2);
                }
            }
            catch (AnalyzerException e) {
                AbstractInsnNode abstractInsnNode = e.node;
                StringBuilder stringBuilder2 = new StringBuilder().append("Error at instruction #").append(insn).append(' ');
                InsnList insnList = this.method.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"method.instructions");
                throw new AnalyzerException(abstractInsnNode, stringBuilder2.append(InlineCodegenUtilsKt.insnText(insnNode, insnList)).append(": ").append(e.getMessage()).append("\ncurrent: ").append(this.dump(current)).toString(), (Throwable)e);
            }
            catch (Exception e) {
                StringBuilder stringBuilder3 = new StringBuilder().append("Error at instruction #").append(insn).append(' ');
                InsnList insnList = this.method.instructions;
                Intrinsics.checkNotNullExpressionValue((Object)insnList, (String)"method.instructions");
                throw new AnalyzerException(insnNode, stringBuilder3.append(InlineCodegenUtilsKt.insnText(insnNode, insnList)).append(": ").append(e.getMessage()).append("\ncurrent: ").append(this.dump(current)).toString(), (Throwable)e);
            }
        }
        return this.frames;
    }

    public final void initLocals$backend(@NotNull Frame<V> current) {
        Intrinsics.checkNotNullParameter(current, (String)"current");
        current.setReturn(this.interpreter.newValue(Type.getReturnType((String)this.method.desc)));
        Type[] args = Type.getArgumentTypes((String)this.method.desc);
        int local = 0;
        if ((this.method.access & 8) == 0) {
            Type ctype = Type.getObjectType((String)this.owner);
            current.setLocal(local++, this.interpreter.newValue(ctype));
        }
        Intrinsics.checkNotNullExpressionValue((Object)args, (String)"args");
        for (Type arg : args) {
            current.setLocal(local++, this.interpreter.newValue(arg));
            if (arg.getSize() != 2) continue;
            current.setLocal(local++, this.interpreter.newValue(null));
        }
        while (local < this.method.maxLocals) {
            current.setLocal(local++, this.interpreter.newValue(null));
        }
    }

    private final int indexOf(AbstractInsnNode $this$indexOf) {
        return this.method.instructions.indexOf($this$indexOf);
    }

    private final void initMergeNodes() {
        Intrinsics.checkNotNullExpressionValue((Object)this.insnsArray, (String)"insnsArray");
        block5: for (AbstractInsnNode insn : this.insnsArray) {
            switch (insn.getType()) {
                case 7: {
                    AbstractInsnNode abstractInsnNode = insn;
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.JumpInsnNode");
                    }
                    JumpInsnNode jumpInsn = (JumpInsnNode)abstractInsnNode;
                    LabelNode labelNode = jumpInsn.label;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"jumpInsn.label");
                    this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
                    continue block5;
                }
                case 12: {
                    AbstractInsnNode abstractInsnNode = insn;
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.LookupSwitchInsnNode");
                    }
                    LookupSwitchInsnNode switchInsn = (LookupSwitchInsnNode)abstractInsnNode;
                    LabelNode labelNode = switchInsn.dflt;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"switchInsn.dflt");
                    this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
                    for (LabelNode label : switchInsn.labels) {
                        Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
                        this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)label))] = true;
                    }
                    continue block5;
                }
                case 11: {
                    AbstractInsnNode abstractInsnNode = insn;
                    if (abstractInsnNode == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.org.objectweb.asm.tree.TableSwitchInsnNode");
                    }
                    LookupSwitchInsnNode switchInsn = (TableSwitchInsnNode)abstractInsnNode;
                    LabelNode labelNode = switchInsn.dflt;
                    Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"switchInsn.dflt");
                    this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
                    for (LabelNode label : switchInsn.labels) {
                        Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
                        this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)label))] = true;
                    }
                    continue block5;
                }
            }
        }
        for (TryCatchBlockNode tcb : this.method.tryCatchBlocks) {
            LabelNode labelNode = tcb.handler;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.handler");
            this.isMergeNode[this.indexOf((AbstractInsnNode)((AbstractInsnNode)labelNode))] = true;
        }
    }

    @Nullable
    public final Frame<V> getFrame(@NotNull AbstractInsnNode insn) {
        Intrinsics.checkNotNullParameter((Object)insn, (String)"insn");
        return this.frames[this.indexOf(insn)];
    }

    private final void checkAssertions() {
        boolean bl;
        block2: {
            Intrinsics.checkNotNullExpressionValue((Object)this.insnsArray, (String)"insnsArray");
            Object[] $this$any$iv = this.insnsArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                AbstractInsnNode it = (AbstractInsnNode)element$iv;
                boolean bl2 = false;
                if (!(it.getOpcode() == 168 || it.getOpcode() == 169)) continue;
                bl = true;
                break block2;
            }
            bl = false;
        }
        if (bl) {
            throw new AssertionError((Object)"Subroutines are deprecated since Java 6");
        }
    }

    private final void visitOpInsn(Frame<V> current, int insn) {
        this.mergeControlFlowEdge(insn + 1, current);
    }

    private final void visitTableSwitchInsnNode(TableSwitchInsnNode insnNode, Frame<V> current) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.dflt");
        this.mergeControlFlowEdge(this.indexOf((AbstractInsnNode)labelNode), current);
        List list2 = insnNode.labels;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"insnNode.labels");
        for (LabelNode label : CollectionsKt.asReversedMutable((List)list2)) {
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
            this.mergeControlFlowEdge(this.indexOf((AbstractInsnNode)label), current);
        }
    }

    private final void visitLookupSwitchInsnNode(LookupSwitchInsnNode insnNode, Frame<V> current) {
        LabelNode labelNode = insnNode.dflt;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.dflt");
        this.mergeControlFlowEdge(this.indexOf((AbstractInsnNode)labelNode), current);
        for (LabelNode label : insnNode.labels) {
            Intrinsics.checkNotNullExpressionValue((Object)label, (String)"label");
            this.mergeControlFlowEdge(this.indexOf((AbstractInsnNode)label), current);
        }
    }

    private final void visitJumpInsnNode(JumpInsnNode insnNode, Frame<V> current, int insn, int insnOpcode) {
        if (insnOpcode != 167) {
            this.mergeControlFlowEdge(insn + 1, current);
        }
        LabelNode labelNode = insnNode.label;
        Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"insnNode.label");
        this.mergeControlFlowEdge(this.indexOf((AbstractInsnNode)labelNode), current);
    }

    private final void computeExceptionHandlersForEachInsn(MethodNode m) {
        for (TryCatchBlockNode tcb : m.tryCatchBlocks) {
            LabelNode labelNode = tcb.start;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode, (String)"tcb.start");
            int begin = this.indexOf((AbstractInsnNode)labelNode);
            LabelNode labelNode2 = tcb.end;
            Intrinsics.checkNotNullExpressionValue((Object)labelNode2, (String)"tcb.end");
            int end = this.indexOf((AbstractInsnNode)labelNode2);
            for (int j = begin; j < end; ++j) {
                AbstractInsnNode abstractInsnNode = this.insnsArray[j];
                Intrinsics.checkNotNullExpressionValue((Object)abstractInsnNode, (String)"insnsArray[j]");
                if (!UtilKt.isMeaningful(abstractInsnNode)) continue;
                List insnHandlers = this.handlers[j];
                if (insnHandlers == null) {
                    this.handlers[j] = insnHandlers = (List)new SmartList();
                }
                Intrinsics.checkNotNullExpressionValue((Object)tcb, (String)"tcb");
                insnHandlers.add(tcb);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void mergeControlFlowEdge(int dest, Frame<V> frame) {
        boolean changes;
        boolean bl;
        Frame<V> oldFrame = this.frames[dest];
        if (oldFrame == null) {
            void $this$mergeControlFlowEdge_u24lambda_u2d2;
            Frame<V> frame2;
            Frame<V> frame3 = frame2 = this.newFrame(frame.getLocals(), frame.getMaxStackSize());
            int n = dest;
            Frame<V>[] frameArray = this.frames;
            boolean bl2 = false;
            $this$mergeControlFlowEdge_u24lambda_u2d2.init(frame);
            Unit unit2 = Unit.INSTANCE;
            frameArray[n] = frame2;
            bl = true;
        } else if (!this.isMergeNode[dest]) {
            oldFrame.init(frame);
            bl = true;
        } else {
            boolean bl3;
            try {
                bl3 = oldFrame.merge(frame, this.interpreter);
            }
            catch (AnalyzerException e) {
                throw new AnalyzerException(null, e.getMessage() + "\nframe: " + this.dump(frame) + "\noldFrame: " + this.dump(oldFrame));
            }
            bl = changes = bl3;
        }
        if (changes && !this.queued[dest]) {
            this.queued[dest] = true;
            int n = this.top;
            this.top = n + 1;
            this.queue[n] = dest;
        }
    }

    private final String dump(Frame<V> $this$dump) {
        StringBuilder stringBuilder2;
        StringBuilder $this$dump_u24lambda_u2d3 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$dump_u24lambda_u2d3.append("{\n");
        $this$dump_u24lambda_u2d3.append("  locals: [\n");
        int n = this.method.maxLocals;
        for (int i = 0; i < n; ++i) {
            $this$dump_u24lambda_u2d3.append("    #" + i + ": " + $this$dump.getLocal(i) + '\n');
        }
        $this$dump_u24lambda_u2d3.append("  ]\n");
        int stackSize = $this$dump.getStackSize();
        $this$dump_u24lambda_u2d3.append("  stack: size=");
        $this$dump_u24lambda_u2d3.append(stackSize);
        if (stackSize == 0) {
            $this$dump_u24lambda_u2d3.append(" []\n");
        } else {
            $this$dump_u24lambda_u2d3.append(" [\n");
            for (int i = 0; i < stackSize; ++i) {
                $this$dump_u24lambda_u2d3.append("    #" + i + ": " + $this$dump.getStack(i) + '\n');
            }
            $this$dump_u24lambda_u2d3.append("  ]\n");
        }
        $this$dump_u24lambda_u2d3.append("}\n");
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
        return string2;
    }
}

