/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers;

import com.intellij.lang.LighterASTNode;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.KotlinTarget;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.LightTreePositioningStrategiesKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.FirSourceUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousInitializer;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.expressions.impl.FirEmptyExpressionBlock;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SessionHolder;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirDelegatedMemberScopeKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirEnumEntrySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirIntersectionCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.CompilerConeAttributesKt;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeConflictingProjection;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.resolve.AnnotationTargetList;
import org.jetbrains.kotlin.resolve.AnnotationTargetLists;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.TypeCheckerProviderContext;
import org.jetbrains.kotlin.util.ImplementationStatus;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u00a2\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0000\u001a@\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u0001012\u0006\u00102\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u00103\u001a\u0002042\u0006\u0010+\u001a\u00020,2\u0006\u00105\u001a\u00020\b\u001a\u001a\u00106\u001a\u0004\u0018\u0001072\b\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020;\u001a\u000e\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?\u001a\u001e\u0010@\u001a\u00020\b2\u0006\u0010)\u001a\u00020A2\u0006\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020/\u001a \u0010D\u001a\u00020\b2\u0006\u0010)\u001a\u00020A2\u0006\u0010B\u001a\u00020/2\u0006\u0010C\u001a\u00020/H\u0002\u001a \u0010E\u001a\u00020\b2\u0006\u0010)\u001a\u00020A2\u0006\u0010F\u001a\u00020/2\u0006\u0010G\u001a\u00020!H\u0002\u001a\u0012\u0010H\u001a\u00020\b*\u00020/2\u0006\u0010I\u001a\u00020J\u001a\u0010\u0010K\u001a\b\u0012\u0004\u0012\u00020M0L*\u00020N\u001a\f\u0010O\u001a\u0004\u0018\u00010P*\u00020*\u001a\u0014\u0010Q\u001a\u0004\u0018\u000109*\u00020P2\u0006\u0010)\u001a\u00020*\u001a\u001b\u0010R\u001a\u0004\u0018\u00010N*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010S\u001a\u00020JH\u0086\u0010\u001a\u0018\u0010T\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u00020?2\u0006\u0010I\u001a\u00020J\u001a\u001c\u0010T\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\"2\u0006\u0010I\u001a\u00020J\u001a\u001c\u0010U\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030V2\u0006\u0010I\u001a\u00020J\u001a\"\u0010W\u001a\u00020X*\u0006\u0012\u0002\b\u00030Y2\u0006\u0010Z\u001a\u00020[2\n\u0010\\\u001a\u0006\u0012\u0002\b\u00030V\u001a\f\u0010]\u001a\u00020\b*\u00020?H\u0002\u001a\u0012\u0010^\u001a\u00020_*\u00020`2\u0006\u0010)\u001a\u00020*\u001a\u000e\u0010a\u001a\u00020\b*\u0006\u0012\u0002\b\u00030b\u001a\u0012\u0010c\u001a\u00020\b*\u00020/2\u0006\u0010I\u001a\u00020J\u001a\n\u0010d\u001a\u00020\b*\u00020`\u001a\u001c\u0010e\u001a\u00020\b*\u00020f2\u0006\u0010)\u001a\u00020g2\b\u0010h\u001a\u0004\u0018\u00010f\u001a\u0012\u0010i\u001a\u00020\b*\u00020/2\u0006\u0010I\u001a\u00020J\u001a\"\u0010j\u001a\u00020\b*\u0006\u0012\u0002\b\u00030V2\n\u0010k\u001a\u0006\u0012\u0002\b\u00030V2\u0006\u0010I\u001a\u00020J\u001a\u001c\u0010j\u001a\u00020\b*\u00020f2\u0006\u0010)\u001a\u00020g2\b\u0010h\u001a\u0004\u0018\u00010f\u001a\u0012\u0010l\u001a\u00020\b*\u00020m2\u0006\u0010n\u001a\u00020P\u001a\u001a\u0010l\u001a\u00020\b*\u0006\u0012\u0002\b\u00030Y2\n\u0010\\\u001a\u0006\u0012\u0002\b\u00030V\u001a\f\u0010o\u001a\u0004\u0018\u00010_*\u00020P\u001a\u001c\u0010p\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010)\u001a\u00020*\u001a(\u0010q\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030b0 *\u00020r2\n\u0010s\u001a\u0006\u0012\u0002\b\u00030V2\u0006\u0010)\u001a\u00020*\u001a(\u0010q\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030b0 *\u00020\u00162\n\u0010s\u001a\u0006\u0012\u0002\b\u00030V2\u0006\u0010)\u001a\u00020*\u001a\u0014\u0010t\u001a\u00020\b*\u00020u2\u0006\u0010Z\u001a\u00020[H\u0002\u001a\u0018\u0010v\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0004*\u0002092\u0006\u0010I\u001a\u00020J\u001a\u0014\u0010w\u001a\u0004\u0018\u00010N*\u00020x2\u0006\u0010I\u001a\u00020J\u001a\u0014\u0010w\u001a\u0004\u0018\u00010N*\u00020/2\u0006\u0010I\u001a\u00020J\u001a\u0014\u0010w\u001a\u0004\u0018\u00010N*\u0002092\u0006\u0010I\u001a\u00020J\u001a\u0012\u0010y\u001a\u00020z*\u00020P2\u0006\u0010)\u001a\u00020*\u001a\u0016\u0010y\u001a\u00020z*\u0006\u0012\u0002\b\u00030V2\u0006\u0010)\u001a\u00020*\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0002\u001a\u0004\u0018\u00010\u0003*\u0006\u0012\u0002\b\u00030\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0007\u001a\u00020\b*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\b*\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000e\"\u0015\u0010\u000f\u001a\u00020\b*\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\b*\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014\"\u0018\u0010\u0015\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\"\u0018\u0010\u0019\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u0018\"\u0018\u0010\u001b\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0018\"\u0018\u0010\u001d\u001a\u00020\b*\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0018\"!\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020!\u0018\u00010 *\u0006\u0012\u0002\b\u00030\"8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010$*\f\b\u0002\u0010{\"\u00020|2\u00020|\u00a8\u0006}"}, d2={"INLINE_ONLY_ANNOTATION_CLASS_ID", "Lorg/jetbrains/kotlin/name/ClassId;", "classKind", "Lorg/jetbrains/kotlin/descriptors/ClassKind;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getClassKind", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Lorg/jetbrains/kotlin/descriptors/ClassKind;", "hasValOrVar", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getHasValOrVar", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;)Z", "isConflictingOrNotInvariant", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;)Z", "isDelegated", "Lorg/jetbrains/kotlin/name/Name;", "(Lorg/jetbrains/kotlin/name/Name;)Z", "isIterator", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)Z", "matchesDataClassSyntheticMemberSignatures", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "getMatchesDataClassSyntheticMemberSignatures", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;)Z", "matchesEqualsSignature", "getMatchesEqualsSignature", "matchesHashCodeSignature", "getMatchesHashCodeSignature", "matchesToStringSignature", "getMatchesToStringSignature", "typeParameterSymbols", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getTypeParameterSymbols", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;)Ljava/util/List;", "checkCondition", "", "condition", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkTypeMismatch", "lValueOriginalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "assignment", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "rValue", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "isInitializer", "extractArgumentTypeRefAndSource", "Lorg/jetbrains/kotlin/fir/analysis/checkers/FirTypeRefSource;", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "index", "", "getActualTargetList", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetList;", "annotated", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "isSubtypeForTypeMismatch", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "subtype", "supertype", "isSubtypeOfForFunctionalTypeReturningUnit", "lowerThanBound", "argument", "typeParameterSymbol", "canHaveSubtypes", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "collectEnumEntries", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirEnumEntrySymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "findClosestClassOrObject", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "findNonInterfaceSupertype", "fullyExpandedClass", "useSiteSession", "getContainingClassSymbol", "getContainingDeclarationSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getImplementationStatus", "Lorg/jetbrains/kotlin/util/ImplementationStatus;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "sessionHolder", "Lorg/jetbrains/kotlin/fir/resolve/SessionHolder;", "parentClassSymbol", "hasBody", "implicitModality", "Lorg/jetbrains/kotlin/descriptors/Modality;", "Lorg/jetbrains/kotlin/fir/declarations/FirMemberDeclaration;", "isFunctionForExpectTypeFromCastFeature", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "isInlineClass", "isInlineOnly", "isSubtypeOf", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "Lorg/jetbrains/kotlin/types/model/TypeCheckerProviderContext;", "type", "isSubtypeOfThrowable", "isSupertypeOf", "other", "isVisibleInClass", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "parentClass", "modality", "outerClassSymbol", "overriddenFunctions", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "containingClass", "subjectToManyNotImplemented", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirIntersectionCallableSymbol;", "toClassLikeSymbol", "toRegularClassSymbol", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "unsubstitutedScope", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "TargetLists", "Lorg/jetbrains/kotlin/resolve/AnnotationTargetLists;", "checkers"})
public final class FirHelpersKt {
    @NotNull
    private static final ClassId INLINE_ONLY_ANNOTATION_CLASS_ID;

    @NotNull
    public static final FirTypeScope unsubstitutedScope(@NotNull FirClass $this$unsubstitutedScope, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$unsubstitutedScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return FirKotlinScopeProviderKt.unsubstitutedScope($this$unsubstitutedScope, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false);
    }

    @NotNull
    public static final FirTypeScope unsubstitutedScope(@NotNull FirClassSymbol<?> $this$unsubstitutedScope, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$unsubstitutedScope, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return FirKotlinScopeProviderKt.unsubstitutedScope($this$unsubstitutedScope, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), false);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> toClassLikeSymbol(@NotNull FirTypeRef $this$toClassLikeSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toClassLikeSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirTypeRef $this$coneTypeSafe$iv = $this$toClassLikeSymbol;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
        return coneClassLikeType != null ? TypeUtilsKt.toSymbol(coneClassLikeType, session2) : null;
    }

    public static final boolean isSupertypeOf(@NotNull FirClassSymbol<?> $this$isSupertypeOf, @NotNull FirClassSymbol<?> other, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$isSupertypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter(other, (String)"other");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf, session2, other, new LinkedHashSet());
    }

    @Nullable
    public static final FirRegularClassSymbol toRegularClassSymbol(@NotNull ConeClassLikeType $this$toRegularClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClassSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassLikeSymbol<?> firClassLikeSymbol = TypeUtilsKt.toSymbol(TypeExpansionUtilsKt.fullyExpandedType$default($this$toRegularClassSymbol, session2, null, 2, null), session2);
        return firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
    }

    @Nullable
    public static final FirRegularClassSymbol toRegularClassSymbol(@NotNull ConeKotlinType $this$toRegularClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClassSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ConeClassLikeType coneClassLikeType = $this$toRegularClassSymbol instanceof ConeClassLikeType ? (ConeClassLikeType)$this$toRegularClassSymbol : null;
        return coneClassLikeType != null ? FirHelpersKt.toRegularClassSymbol(coneClassLikeType, session2) : null;
    }

    public static final boolean isInlineClass(@NotNull ConeKotlinType $this$isInlineClass, @NotNull FirSession session2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isInlineClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$isInlineClass, session2);
        if (firRegularClassSymbol != null) {
            FirClassSymbol $this$isInline$iv = firRegularClassSymbol;
            boolean $i$f$isInline = false;
            bl = $this$isInline$iv.getResolvedStatus().isInline();
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final FirRegularClassSymbol toRegularClassSymbol(@NotNull FirTypeRef $this$toRegularClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$toRegularClassSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirHelpersKt.toRegularClassSymbol(FirTypeUtilsKt.getConeType($this$toRegularClassSymbol), session2);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getContainingClassSymbol(@NotNull FirDeclaration $this$getContainingClassSymbol, @NotNull FirSession session2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getContainingClassSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirDeclaration $this$safeAs$iv = $this$getContainingClassSymbol;
        boolean $i$f$safeAs = false;
        FirDeclaration firDeclaration = $this$safeAs$iv;
        if (!(firDeclaration instanceof FirCallableDeclaration)) {
            firDeclaration = null;
        }
        return (object = (FirCallableDeclaration)firDeclaration) != null && (object = ClassMembersKt.containingClass((FirCallableDeclaration)object)) != null ? LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)object, session2) : null;
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getContainingClassSymbol(@NotNull FirBasedSymbol<?> $this$getContainingClassSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getContainingClassSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirHelpersKt.getContainingClassSymbol($this$getContainingClassSymbol.getFir(), session2);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> outerClassSymbol(@NotNull FirClassLikeSymbol<?> $this$outerClassSymbol, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter($this$outerClassSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!($this$outerClassSymbol instanceof FirClassSymbol)) {
            return null;
        }
        ClassId classId = $this$outerClassSymbol.getClassId().getOuterClassId();
        if (classId == null) {
            return null;
        }
        ClassId outerClassId = classId;
        return FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId(outerClassId);
    }

    @Nullable
    public static final FirClassLikeSymbol<?> getContainingDeclarationSymbol(@NotNull FirClassSymbol<?> $this$getContainingDeclarationSymbol, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter($this$getContainingDeclarationSymbol, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        FirClassLikeSymbol $this$isLocal$iv = $this$getContainingDeclarationSymbol;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getClassId().isLocal()) {
            ConeClassLikeLookupTag coneClassLikeLookupTag = ClassMembersKt.getContainingClassForLocalAttr((FirRegularClass)((FirRegularClassSymbol)$this$getContainingDeclarationSymbol).getFir());
            return coneClassLikeLookupTag != null ? LookupTagUtilsKt.toFirRegularClassSymbol(coneClassLikeLookupTag, session2) : null;
        }
        FqName fqName2 = $this$getContainingDeclarationSymbol.getClassId().getRelativeClassName().parent();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"classId.relativeClassName.parent()");
        FqName parentId = fqName2;
        if (!parentId.isRoot()) {
            ClassId containingDeclarationId = new ClassId($this$getContainingDeclarationSymbol.getClassId().getPackageFqName(), parentId, false);
            return FirSymbolProviderKt.getSymbolProvider(session2).getClassLikeSymbolByClassId(containingDeclarationId);
        }
        return null;
    }

    @Nullable
    public static final FirRegularClassSymbol fullyExpandedClass(@NotNull FirClassLikeSymbol<?> $this$fullyExpandedClass, @NotNull FirSession useSiteSession) {
        FirRegularClassSymbol firRegularClassSymbol;
        block4: {
            block5: {
                Intrinsics.checkNotNullParameter($this$fullyExpandedClass, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)useSiteSession, (String)"useSiteSession");
                FirClassLikeSymbol<?> firClassLikeSymbol = $this$fullyExpandedClass;
                FirSession firSession = useSiteSession;
                while (true) {
                    FirClassLikeSymbol<?> firClassLikeSymbol2;
                    ConeClassLikeType coneClassLikeType;
                    FirClassLikeSymbol<?> firClassLikeSymbol3 = firClassLikeSymbol;
                    FirSession firSession2 = firSession;
                    FirClassLikeSymbol<?> firClassLikeSymbol4 = firClassLikeSymbol3;
                    if (firClassLikeSymbol4 instanceof FirRegularClassSymbol) {
                        firRegularClassSymbol = (FirRegularClassSymbol)firClassLikeSymbol3;
                        break block4;
                    }
                    if (firClassLikeSymbol4 instanceof FirAnonymousObjectSymbol) {
                        firRegularClassSymbol = null;
                        break block4;
                    }
                    if (!(firClassLikeSymbol4 instanceof FirTypeAliasSymbol)) break block5;
                    FirTypeRef $this$coneTypeSafe$iv = ((FirTypeAliasSymbol)firClassLikeSymbol3).getResolvedExpandedTypeRef();
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    if ((coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType))) == null || (firClassLikeSymbol2 = TypeUtilsKt.toSymbol(coneClassLikeType, firSession2)) == null) break;
                    firClassLikeSymbol = firClassLikeSymbol2;
                    firSession = firSession2;
                }
                firRegularClassSymbol = null;
                break block4;
            }
            throw new NoWhenBranchMatchedException();
        }
        return firRegularClassSymbol;
    }

    @Nullable
    public static final FirClass findClosestClassOrObject(@NotNull CheckerContext $this$findClosestClassOrObject) {
        Intrinsics.checkNotNullParameter((Object)$this$findClosestClassOrObject, (String)"<this>");
        for (FirDeclaration it : CollectionsKt.asReversed($this$findClosestClassOrObject.getContainingDeclarations())) {
            if (!(it instanceof FirRegularClass) && !(it instanceof FirAnonymousObject)) continue;
            return (FirClass)it;
        }
        return null;
    }

    @NotNull
    public static final List<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirSimpleFunction $this$overriddenFunctions, @NotNull FirClassSymbol<?> containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$overriddenFunctions, (String)"<this>");
        Intrinsics.checkNotNullParameter(containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return FirHelpersKt.overriddenFunctions($this$overriddenFunctions.getSymbol(), containingClass, context2);
    }

    @NotNull
    public static final List<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirNamedFunctionSymbol $this$overriddenFunctions, @NotNull FirClassSymbol<?> containingClass, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$overriddenFunctions, (String)"<this>");
        Intrinsics.checkNotNullParameter(containingClass, (String)"containingClass");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        FirTypeScope firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(containingClass, context2.getSessionHolder().getSession(), context2.getSessionHolder().getScopeSession(), true);
        List overriddenFunctions2 = new ArrayList();
        firTypeScope.processFunctionsByName($this$overriddenFunctions.getCallableId().getCallableName(), (Function1<? super FirNamedFunctionSymbol, Unit>)((Function1)overriddenFunctions.1.INSTANCE));
        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$overriddenFunctions, (Function1<? super FirNamedFunctionSymbol, ? extends ProcessorAction>)((Function1)new Function1<FirNamedFunctionSymbol, ProcessorAction>(overriddenFunctions2){
            final /* synthetic */ List<FirFunctionSymbol<?>> $overriddenFunctions;
            {
                this.$overriddenFunctions = $overriddenFunctions;
                super(1);
            }

            @NotNull
            public final ProcessorAction invoke(@NotNull FirNamedFunctionSymbol it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$overriddenFunctions.add(it);
                return ProcessorAction.NEXT;
            }
        }));
        return overriddenFunctions2;
    }

    @Nullable
    public static final Modality modality(@NotNull FirClass $this$modality) {
        Modality modality;
        Intrinsics.checkNotNullParameter((Object)$this$modality, (String)"<this>");
        if ($this$modality instanceof FirRegularClass) {
            FirMemberDeclaration $this$modality$iv = $this$modality;
            boolean $i$f$getModality = false;
            modality = $this$modality$iv.getStatus().getModality();
        } else {
            modality = Modality.FINAL;
        }
        return modality;
    }

    @NotNull
    public static final Modality implicitModality(@NotNull FirMemberDeclaration $this$implicitModality, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$implicitModality, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if ($this$implicitModality instanceof FirRegularClass && (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.CLASS || ((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.OBJECT)) {
            if (((FirRegularClass)$this$implicitModality).getClassKind() == ClassKind.INTERFACE) {
                return Modality.ABSTRACT;
            }
            return Modality.FINAL;
        }
        FirClass firClass = FirHelpersKt.findClosestClassOrObject(context2);
        if (firClass == null) {
            return Modality.FINAL;
        }
        FirClass klass = firClass;
        KtSourceElement ktSourceElement = $this$implicitModality.getSource();
        if (ktSourceElement == null) {
            return Modality.FINAL;
        }
        KtSourceElement source = ktSourceElement;
        FlyweightCapableTreeStructure<LighterASTNode> tree = source.getTreeStructure();
        if (LightTreePositioningStrategiesKt.overrideModifier(tree, source.getLighterASTNode()) != null) {
            IElementType klassModalityTokenType;
            Object object;
            KtSourceElement ktSourceElement2 = klass.getSource();
            if (ktSourceElement2 != null) {
                KtSourceElement it = ktSourceElement2;
                boolean bl = false;
                LighterASTNode lighterASTNode2 = LightTreePositioningStrategiesKt.modalityModifier(tree, it.getLighterASTNode());
                object = lighterASTNode2 != null ? lighterASTNode2.getTokenType() : null;
            } else {
                object = klassModalityTokenType = null;
            }
            if (Intrinsics.areEqual(klassModalityTokenType, (Object)((Object)KtTokens.ABSTRACT_KEYWORD)) || Intrinsics.areEqual((Object)klassModalityTokenType, (Object)((Object)KtTokens.OPEN_KEYWORD)) || Intrinsics.areEqual((Object)klassModalityTokenType, (Object)((Object)KtTokens.SEALED_KEYWORD))) {
                return Modality.OPEN;
            }
        }
        if (klass instanceof FirRegularClass && klass.getClassKind() == ClassKind.INTERFACE) {
            LighterASTNode lighterASTNode3 = LightTreePositioningStrategiesKt.visibilityModifier(tree, source.getLighterASTNode());
            if (!Intrinsics.areEqual((Object)(lighterASTNode3 != null ? lighterASTNode3.getTokenType() : null), (Object)((Object)KtTokens.PRIVATE_KEYWORD))) {
                return FirHelpersKt.hasBody($this$implicitModality) ? Modality.OPEN : Modality.ABSTRACT;
            }
        }
        return Modality.FINAL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasBody(FirDeclaration $this$hasBody) {
        FirDeclaration firDeclaration = $this$hasBody;
        if (firDeclaration instanceof FirSimpleFunction) {
            if (((FirSimpleFunction)$this$hasBody).getBody() == null) return false;
            if (((FirSimpleFunction)$this$hasBody).getBody() instanceof FirEmptyExpressionBlock) return false;
            return true;
        }
        if (!(firDeclaration instanceof FirProperty)) return false;
        FirPropertyAccessor firPropertyAccessor = ((FirProperty)$this$hasBody).getSetter();
        FirBlock firBlock = firPropertyAccessor != null ? firPropertyAccessor.getBody() : null;
        if (!(firBlock == null ? true : firBlock instanceof FirEmptyExpressionBlock)) return true;
        FirPropertyAccessor firPropertyAccessor2 = ((FirProperty)$this$hasBody).getGetter();
        if (firPropertyAccessor2 == null) return false;
        FirBlock firBlock2 = firPropertyAccessor2.getBody();
        if (firBlock2 == null) {
            return false;
        }
        boolean bl = firBlock2 instanceof FirEmptyExpressionBlock;
        if (bl) return false;
        return true;
    }

    @Nullable
    public static final FirTypeRef findNonInterfaceSupertype(@NotNull FirClass $this$findNonInterfaceSupertype, @NotNull CheckerContext context2) {
        Intrinsics.checkNotNullParameter((Object)$this$findNonInterfaceSupertype, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        for (FirTypeRef superTypeRef : $this$findNonInterfaceSupertype.getSuperTypeRefs()) {
            FirClassSymbol symbol2;
            Object object;
            ConeKotlinType $this$safeAs$iv = FirTypeUtilsKt.getConeType(superTypeRef);
            boolean $i$f$safeAs = false;
            ConeKotlinType coneKotlinType = $this$safeAs$iv;
            if (!(coneKotlinType instanceof ConeClassLikeType)) {
                coneKotlinType = null;
            }
            if ((object = (ConeClassLikeType)coneKotlinType) == null || (object = ((ConeClassLikeType)object).getLookupTag()) == null) continue;
            Object lookupTag2 = object;
            FirClassLikeSymbol<?> firClassLikeSymbol = LookupTagUtilsKt.toSymbol((ConeClassLikeLookupTag)lookupTag2, context2.getSession());
            FirClassSymbol firClassSymbol = firClassLikeSymbol instanceof FirClassSymbol ? (FirClassSymbol)firClassLikeSymbol : null;
            if (firClassSymbol == null || (symbol2 = firClassSymbol).getClassKind() == ClassKind.INTERFACE) continue;
            return superTypeRef;
        }
        return null;
    }

    public static final boolean isIterator(@NotNull FirFunctionCall $this$isIterator) {
        Intrinsics.checkNotNullParameter((Object)$this$isIterator, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isIterator.getCalleeReference().getName().asString(), (Object)"<iterator>");
    }

    public static final boolean isSubtypeOfThrowable(@NotNull ConeKotlinType $this$isSubtypeOfThrowable, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOfThrowable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        return FirHelpersKt.isSupertypeOf(session2.getBuiltinTypes().getThrowableType().getType(), TypeComponentsKt.getTypeContext(session2), TypeExpansionUtilsKt.fullyExpandedType($this$isSubtypeOfThrowable, session2));
    }

    public static final boolean getHasValOrVar(@NotNull FirValueParameter $this$hasValOrVar) {
        Intrinsics.checkNotNullParameter((Object)$this$hasValOrVar, (String)"<this>");
        KtSourceElement ktSourceElement = $this$hasValOrVar.getSource();
        if (ktSourceElement == null) {
            return false;
        }
        KtSourceElement source = ktSourceElement;
        TokenSet tokenSet = KtParameter.VAL_VAR_TOKEN_SET;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"VAL_VAR_TOKEN_SET");
        return FirSourceUtilsKt.getChild$default(source, tokenSet, 0, 0, false, 14, null) != null;
    }

    public static final boolean isSupertypeOf(@NotNull KotlinTypeMarker $this$isSupertypeOf, @NotNull TypeCheckerProviderContext context2, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSupertypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, type2, $this$isSupertypeOf, false, 8, null);
    }

    public static final boolean isSubtypeOf(@NotNull KotlinTypeMarker $this$isSubtypeOf, @NotNull TypeCheckerProviderContext context2, @Nullable KotlinTypeMarker type2) {
        Intrinsics.checkNotNullParameter((Object)$this$isSubtypeOf, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return type2 != null && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, $this$isSubtypeOf, type2, false, 8, null);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean canHaveSubtypes(@NotNull ConeKotlinType $this$canHaveSubtypes, @NotNull FirSession session2) {
        FirRegularClassSymbol classSymbol;
        block20: {
            block19: {
                Intrinsics.checkNotNullParameter((Object)$this$canHaveSubtypes, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                if (ConeTypeUtilsKt.isMarkedNullable($this$canHaveSubtypes)) {
                    return true;
                }
                FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toRegularClassSymbol($this$canHaveSubtypes, session2);
                if (firRegularClassSymbol == null) {
                    return true;
                }
                classSymbol = firRegularClassSymbol;
                FirClassSymbol $this$isEnumClass$iv = classSymbol;
                boolean $i$f$isEnumClass = false;
                ClassKind $this$isEnumClass$iv$iv = $this$isEnumClass$iv.getClassKind();
                boolean $i$f$isEnumClass2 = false;
                if ($this$isEnumClass$iv$iv == ClassKind.ENUM_CLASS) break block19;
                FirClassSymbol $this$isExpect$iv = classSymbol;
                boolean $i$f$isExpect = false;
                if ($this$isExpect$iv.getResolvedStatus().isExpect()) break block19;
                FirClassSymbol $this$modality$iv = classSymbol;
                boolean $i$f$getModality = false;
                if ($this$modality$iv.getResolvedStatus().getModality() == Modality.FINAL) break block20;
            }
            return true;
        }
        Iterable $this$forEachIndexed$iv = classSymbol.getTypeParameterSymbols();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void typeParameterSymbol;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)item$iv;
            int idx = n;
            boolean bl = false;
            ConeTypeProjection typeProjection = $this$canHaveSubtypes.getTypeArguments()[idx];
            if (ConeTypesKt.isStarProjection(typeProjection)) {
                return true;
            }
            Intrinsics.checkNotNull((Object)ConeTypesKt.getType(typeProjection));
            block0 : switch (WhenMappings.$EnumSwitchMapping$1[typeParameterSymbol.getVariance().ordinal()]) {
                case 1: {
                    ConeKotlinType argument2;
                    switch (WhenMappings.$EnumSwitchMapping$0[typeProjection.getKind().ordinal()]) {
                        case 1: {
                            if (!FirHelpersKt.lowerThanBound(TypeComponentsKt.getTypeContext(session2), argument2, (FirTypeParameterSymbol)typeParameterSymbol) && !FirHelpersKt.canHaveSubtypes(argument2, session2)) break block0;
                            return true;
                        }
                        case 2: {
                            if (!FirHelpersKt.lowerThanBound(TypeComponentsKt.getTypeContext(session2), argument2, (FirTypeParameterSymbol)typeParameterSymbol)) break block0;
                            return true;
                        }
                        case 3: {
                            if (!FirHelpersKt.canHaveSubtypes(argument2, session2)) break block0;
                            return true;
                        }
                        case 4: {
                            return true;
                        }
                    }
                    break;
                }
                case 2: {
                    ConeKotlinType argument2;
                    if (!(typeProjection.getKind() != ProjectionKind.OUT ? FirHelpersKt.lowerThanBound(TypeComponentsKt.getTypeContext(session2), argument2, (FirTypeParameterSymbol)typeParameterSymbol) : FirHelpersKt.canHaveSubtypes(argument2, session2))) break;
                    return true;
                }
                case 3: {
                    ConeKotlinType argument2;
                    if (!(typeProjection.getKind() != ProjectionKind.IN ? FirHelpersKt.canHaveSubtypes(argument2, session2) : FirHelpersKt.lowerThanBound(TypeComponentsKt.getTypeContext(session2), argument2, (FirTypeParameterSymbol)typeParameterSymbol))) break;
                    return true;
                }
            }
        }
        return false;
    }

    private static final boolean lowerThanBound(ConeInferenceContext context2, ConeKotlinType argument2, FirTypeParameterSymbol typeParameterSymbol) {
        Iterable $this$forEach$iv = typeParameterSymbol.getResolvedBounds();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirResolvedTypeRef boundTypeRef = (FirResolvedTypeRef)element$iv;
            boolean bl = false;
            if (Intrinsics.areEqual((Object)argument2, (Object)FirTypeUtilsKt.getConeType(boundTypeRef)) || !FirHelpersKt.isSubtypeOf(argument2, context2, FirTypeUtilsKt.getConeType(boundTypeRef))) continue;
            return true;
        }
        return false;
    }

    public static final boolean isInlineOnly(@NotNull FirMemberDeclaration $this$isInlineOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$isInlineOnly, (String)"<this>");
        FirMemberDeclaration $this$isInline$iv = $this$isInlineOnly;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getStatus().isInline() && FirAnnotationUtilsKt.hasAnnotation($this$isInlineOnly, INLINE_ONLY_ANNOTATION_CLASS_ID);
    }

    public static final boolean isSubtypeForTypeMismatch(@NotNull ConeInferenceContext context2, @NotNull ConeKotlinType subtype, @NotNull ConeKotlinType supertype2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)subtype, (String)"subtype");
        Intrinsics.checkNotNullParameter((Object)supertype2, (String)"supertype");
        ConeKotlinType subtypeFullyExpanded = TypeExpansionUtilsKt.fullyExpandedType(subtype, context2.getSession());
        ConeKotlinType supertypeFullyExpanded = TypeExpansionUtilsKt.fullyExpandedType(supertype2, context2.getSession());
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, context2, (KotlinTypeMarker)subtypeFullyExpanded, (KotlinTypeMarker)supertypeFullyExpanded, false, 8, null) || FirHelpersKt.isSubtypeOfForFunctionalTypeReturningUnit(TypeComponentsKt.getTypeContext(context2.getSession()), subtypeFullyExpanded, supertypeFullyExpanded);
    }

    private static final boolean isSubtypeOfForFunctionalTypeReturningUnit(ConeInferenceContext context2, ConeKotlinType subtype, ConeKotlinType supertype2) {
        if (!InferenceUtilsKt.isBuiltinFunctionalType(supertype2, context2.getSession())) {
            return false;
        }
        ConeTypeProjection functionalTypeReturnType = (ConeTypeProjection)ArraysKt.lastOrNull((Object[])supertype2.getTypeArguments());
        ConeClassLikeType coneClassLikeType = functionalTypeReturnType instanceof ConeClassLikeType ? (ConeClassLikeType)functionalTypeReturnType : null;
        boolean bl = coneClassLikeType != null ? ConeTypeUtilsKt.isUnit(coneClassLikeType) : false;
        if (bl) {
            List superTypeArgs = ArraysKt.dropLast((Object[])supertype2.getTypeArguments(), (int)1);
            List subTypeArgs = ArraysKt.dropLast((Object[])subtype.getTypeArguments(), (int)1);
            if (superTypeArgs.size() != subTypeArgs.size()) {
                return false;
            }
            int n = superTypeArgs.size();
            for (int i = 0; i < n; ++i) {
                ConeKotlinType superTypeArg;
                ConeKotlinType subTypeArg;
                if (ConeTypesKt.getType((ConeTypeProjection)subTypeArgs.get(i)) == null) {
                    return false;
                }
                if (ConeTypesKt.getType((ConeTypeProjection)superTypeArgs.get(i)) == null) {
                    return false;
                }
                if (AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, TypeComponentsKt.getTypeContext(context2.getSession()), (KotlinTypeMarker)subTypeArg, (KotlinTypeMarker)superTypeArg, false, 8, null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean isVisibleInClass(@NotNull FirCallableDeclaration $this$isVisibleInClass, @NotNull FirClass parentClass) {
        Intrinsics.checkNotNullParameter((Object)$this$isVisibleInClass, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)parentClass, (String)"parentClass");
        return FirHelpersKt.isVisibleInClass($this$isVisibleInClass.getSymbol(), parentClass.getSymbol());
    }

    public static final boolean isVisibleInClass(@NotNull FirCallableSymbol<?> $this$isVisibleInClass, @NotNull FirClassSymbol<?> parentClassSymbol) {
        boolean $i$f$getVisibility;
        FirCallableSymbol<?> $this$visibility$iv;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter($this$isVisibleInClass, (String)"<this>");
                Intrinsics.checkNotNullParameter(parentClassSymbol, (String)"parentClassSymbol");
                FqName fqName2 = parentClassSymbol.getClassId().getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parentClassSymbol.classId.packageFqName");
                FqName classPackage = fqName2;
                $this$visibility$iv = $this$isVisibleInClass;
                $i$f$getVisibility = false;
                if (Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) break block2;
                $this$visibility$iv = $this$isVisibleInClass;
                $i$f$getVisibility = false;
                if ($this$visibility$iv.getResolvedStatus().getVisibility().visibleFromPackage(classPackage, $this$isVisibleInClass.getCallableId().getPackageName())) break block3;
            }
            return false;
        }
        $this$visibility$iv = $this$isVisibleInClass;
        $i$f$getVisibility = false;
        return !Intrinsics.areEqual((Object)$this$visibility$iv.getResolvedStatus().getVisibility(), (Object)Visibilities.Internal.INSTANCE) || Intrinsics.areEqual((Object)$this$isVisibleInClass.getModuleData(), (Object)parentClassSymbol.getModuleData()) && !$this$isVisibleInClass.getModuleData().getFriendDependencies().contains(parentClassSymbol.getModuleData());
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public static final ImplementationStatus getImplementationStatus(@NotNull FirCallableSymbol<?> $this$getImplementationStatus, @NotNull SessionHolder sessionHolder, @NotNull FirClassSymbol<?> parentClassSymbol) {
        block23: {
            block24: {
                block22: {
                    block19: {
                        block18: {
                            block21: {
                                block17: {
                                    block20: {
                                        Intrinsics.checkNotNullParameter($this$getImplementationStatus, (String)"<this>");
                                        Intrinsics.checkNotNullParameter((Object)sessionHolder, (String)"sessionHolder");
                                        Intrinsics.checkNotNullParameter(parentClassSymbol, (String)"parentClassSymbol");
                                        containingClassSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)$this$getImplementationStatus, sessionHolder.getSession());
                                        symbol = $this$getImplementationStatus;
                                        if (Intrinsics.areEqual((Object)FirDelegatedMemberScopeKt.getMultipleDelegatesWithTheSameSignature($this$getImplementationStatus), (Object)true) && Intrinsics.areEqual(containingClassSymbol, parentClassSymbol)) {
                                            return ImplementationStatus.AMBIGUOUSLY_INHERITED;
                                        }
                                        if (!(symbol instanceof FirIntersectionCallableSymbol)) break block19;
                                        if (containingClassSymbol == parentClassSymbol && FirHelpersKt.subjectToManyNotImplemented((FirIntersectionCallableSymbol)symbol, sessionHolder)) {
                                            return ImplementationStatus.AMBIGUOUSLY_INHERITED;
                                        }
                                        $this$any$iv = ((FirIntersectionCallableSymbol)symbol).getIntersections();
                                        $i$f$any = false;
                                        if (!($this$any$iv instanceof Collection) || !((Collection)$this$any$iv).isEmpty()) break block20;
                                        v0 = false;
                                        break block17;
                                    }
                                    for (T element$iv : $this$any$iv) {
                                        it = (FirCallableSymbol)element$iv;
                                        $i$a$-any-FirHelpersKt$getImplementationStatus$1 = false;
                                        $this$unwrapFakeOverrides$iv = (FirCallableDeclaration)it.getFir();
                                        $i$f$unwrapFakeOverrides = false;
                                        current$iv = $this$unwrapFakeOverrides$iv;
                                        while (true) {
                                            $this$originalIfFakeOverride$iv$iv = current$iv;
                                            $i$f$originalIfFakeOverride = false;
                                            $this$originalForSubstitutionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                                            $i$f$getOriginalForSubstitutionOverride = false;
                                            v1 = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv) != false ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv) : null;
                                            if (v1 == null) {
                                                $this$baseForIntersectionOverride$iv$iv$iv = $this$originalIfFakeOverride$iv$iv;
                                                $i$f$getBaseForIntersectionOverride = false;
                                                v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv) : null;
                                            }
                                            if (v1 == null) break;
                                            current$iv = next$iv = v1;
                                        }
                                        fir = current$iv;
                                        $this$isAbstract$iv = fir;
                                        $i$f$isAbstract = false;
                                        if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) ** GOTO lbl-1000
                                        $i$f$isAbstract = FirHelpersKt.getContainingClassSymbol(fir, sessionHolder.getSession());
                                        v2 = $i$f$isAbstract instanceof FirRegularClassSymbol != false ? (FirRegularClassSymbol)$i$f$isAbstract : null;
                                        if ((v2 != null ? v2.getClassKind() : null) == ClassKind.CLASS) {
                                            v3 = true;
                                        } else lbl-1000:
                                        // 2 sources

                                        {
                                            v3 = false;
                                        }
                                        if (!v3) continue;
                                        v0 = true;
                                        break block17;
                                    }
                                    v0 = false;
                                }
                                if (!v0) break block19;
                                $this$none$iv = ((FirIntersectionCallableSymbol)symbol).getIntersections();
                                $i$f$none = false;
                                if (!($this$none$iv instanceof Collection) || !((Collection)$this$none$iv).isEmpty()) break block21;
                                v4 = true;
                                break block18;
                            }
                            for (T element$iv : $this$none$iv) {
                                it = (FirCallableSymbol)element$iv;
                                $i$a$-none-FirHelpersKt$getImplementationStatus$2 = false;
                                fir = (FirCallableDeclaration)it.getFir();
                                if (!Intrinsics.areEqual((Object)fir.getOrigin(), (Object)FirDeclarationOrigin.Delegated.INSTANCE)) ** GOTO lbl-1000
                                $this$isAbstract$iv = fir;
                                $i$f$isAbstract = false;
                                if (!($this$isAbstract$iv.getStatus().getModality() == Modality.ABSTRACT)) {
                                    v5 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v5 = false;
                                }
                                if (!v5) continue;
                                v4 = false;
                                break block18;
                            }
                            v4 = true;
                        }
                        if (v4) {
                            return ImplementationStatus.NOT_IMPLEMENTED;
                        }
                    }
                    if ($this$getImplementationStatus instanceof FirNamedFunctionSymbol) {
                        if (parentClassSymbol instanceof FirRegularClassSymbol) {
                            $this$isData$iv = parentClassSymbol;
                            $i$f$isData = false;
                            if ($this$isData$iv.getResolvedStatus().isData() && FirHelpersKt.getMatchesDataClassSyntheticMemberSignatures((FirNamedFunctionSymbol)$this$getImplementationStatus)) {
                                return ImplementationStatus.INHERITED_OR_SYNTHESIZED;
                            }
                        }
                        $this$isSuspend$iv = $this$getImplementationStatus;
                        $i$f$isSuspend = false;
                        if ($this$isSuspend$iv.getResolvedStatus().isSuspend()) {
                            return ImplementationStatus.INHERITED_OR_SYNTHESIZED;
                        }
                    }
                    $this$isFinal$iv = $this$getImplementationStatus;
                    $i$f$isFinal = false;
                    v6 = $this$isFinal$iv.getResolvedStatus().getModality();
                    if (!(v6 == null ? true : (modality$iv = v6) == Modality.FINAL)) break block22;
                    v7 = ImplementationStatus.CANNOT_BE_IMPLEMENTED;
                    break block23;
                }
                if (containingClassSymbol != parentClassSymbol || !Intrinsics.areEqual((Object)$this$getImplementationStatus.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE) && !Intrinsics.areEqual((Object)$this$getImplementationStatus.getOrigin(), (Object)FirDeclarationOrigin.Precompiled.INSTANCE)) break block24;
                v7 = ImplementationStatus.ALREADY_IMPLEMENTED;
                break block23;
            }
            if (!(containingClassSymbol instanceof FirRegularClassSymbol)) ** GOTO lbl-1000
            $this$isExpect$iv = (FirClassSymbol)containingClassSymbol;
            $i$f$isExpect = false;
            if ($this$isExpect$iv.getResolvedStatus().isExpect()) {
                v7 = ImplementationStatus.CANNOT_BE_IMPLEMENTED;
            } else lbl-1000:
            // 2 sources

            {
                $this$isAbstract$iv = $this$getImplementationStatus;
                $i$f$isAbstract = false;
                v7 = $this$isAbstract$iv.getResolvedStatus().getModality() == Modality.ABSTRACT != false ? ImplementationStatus.NOT_IMPLEMENTED : ImplementationStatus.INHERITED_OR_SYNTHESIZED;
            }
        }
        return v7;
    }

    private static final boolean subjectToManyNotImplemented(FirIntersectionCallableSymbol $this$subjectToManyNotImplemented, SessionHolder sessionHolder) {
        int nonAbstractCountInClass = 0;
        int nonAbstractCountInInterface = 0;
        int abstractCountInInterface = 0;
        for (FirCallableSymbol<?> intersectionSymbol : $this$subjectToManyNotImplemented.getIntersections()) {
            FirRegularClassSymbol containingClassSymbol;
            FirClassLikeSymbol<?> firClassLikeSymbol = FirHelpersKt.getContainingClassSymbol((FirBasedSymbol)intersectionSymbol, sessionHolder.getSession());
            FirRegularClassSymbol firRegularClassSymbol = containingClassSymbol = firClassLikeSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firClassLikeSymbol : null;
            boolean hasInterfaceContainer = (firRegularClassSymbol != null ? firRegularClassSymbol.getClassKind() : null) == ClassKind.INTERFACE;
            FirCallableSymbol<?> $this$modality$iv = intersectionSymbol;
            boolean $i$f$getModality = false;
            if ($this$modality$iv.getResolvedStatus().getModality() != Modality.ABSTRACT) {
                if (hasInterfaceContainer) {
                    ++nonAbstractCountInInterface;
                } else {
                    ++nonAbstractCountInClass;
                }
            } else if (hasInterfaceContainer) {
                ++abstractCountInInterface;
            }
            if (nonAbstractCountInClass + nonAbstractCountInInterface > 1) {
                return true;
            }
            if (nonAbstractCountInInterface <= 0 || abstractCountInInterface <= 0) continue;
            return true;
        }
        return false;
    }

    private static final boolean getMatchesDataClassSyntheticMemberSignatures(FirNamedFunctionSymbol $this$matchesDataClassSyntheticMemberSignatures) {
        Name name2 = $this$matchesDataClassSyntheticMemberSignatures.getCallableId().getCallableName();
        return Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.EQUALS) && FirHelpersKt.getMatchesEqualsSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual((Object)name2, (Object)StandardNames.HASHCODE_NAME) && FirHelpersKt.getMatchesHashCodeSignature($this$matchesDataClassSyntheticMemberSignatures) || Intrinsics.areEqual((Object)name2, (Object)OperatorNameConventions.TO_STRING) && FirHelpersKt.getMatchesToStringSignature($this$matchesDataClassSyntheticMemberSignatures);
    }

    private static final boolean getMatchesEqualsSignature(FirNamedFunctionSymbol $this$matchesEqualsSignature) {
        List<FirValueParameterSymbol> valueParameters2 = $this$matchesEqualsSignature.getValueParameterSymbols();
        return valueParameters2.size() == 1 && ConeTypeUtilsKt.isNullableAny(FirTypeUtilsKt.getConeType(valueParameters2.get(0).getResolvedReturnTypeRef()));
    }

    private static final boolean getMatchesHashCodeSignature(FirNamedFunctionSymbol $this$matchesHashCodeSignature) {
        return $this$matchesHashCodeSignature.getValueParameterSymbols().isEmpty();
    }

    private static final boolean getMatchesToStringSignature(FirNamedFunctionSymbol $this$matchesToStringSignature) {
        return $this$matchesToStringSignature.getValueParameterSymbols().isEmpty();
    }

    public static final boolean isDelegated(@NotNull Name $this$isDelegated) {
        Intrinsics.checkNotNullParameter((Object)$this$isDelegated, (String)"<this>");
        String string2 = $this$isDelegated.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString()");
        return StringsKt.startsWith$default((String)string2, (String)"<$$delegate_", (boolean)false, (int)2, null);
    }

    public static final boolean isConflictingOrNotInvariant(@NotNull ConeTypeProjection $this$isConflictingOrNotInvariant) {
        Intrinsics.checkNotNullParameter((Object)$this$isConflictingOrNotInvariant, (String)"<this>");
        return $this$isConflictingOrNotInvariant.getKind() != ProjectionKind.INVARIANT || $this$isConflictingOrNotInvariant instanceof ConeKotlinTypeConflictingProjection;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final void checkTypeMismatch(@NotNull ConeKotlinType lValueOriginalType, @Nullable FirVariableAssignment assignment, @NotNull FirExpression rValue, @NotNull CheckerContext context2, @NotNull KtSourceElement source, @NotNull DiagnosticReporter reporter2, boolean isInitializer) {
        ConeInferenceContext typeContext2;
        Intrinsics.checkNotNullParameter((Object)lValueOriginalType, (String)"lValueOriginalType");
        Intrinsics.checkNotNullParameter((Object)rValue, (String)"rValue");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        ConeKotlinType lValueType = lValueOriginalType;
        ConeKotlinType rValueType = FirTypeUtilsKt.getConeType(rValue.getTypeRef());
        if (source.getKind() instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement && !ConeTypeUtilsKt.isNullable(lValueType) && ConeTypeUtilsKt.isNullable(rValueType)) {
            ConeKotlinType tempType = rValueType;
            rValueType = lValueType;
            lValueType = tempType;
        }
        if (FirHelpersKt.isSubtypeForTypeMismatch(typeContext2 = TypeComponentsKt.getTypeContext(context2.getSession()), rValueType, lValueType)) return;
        if (rValueType instanceof ConeClassLikeType && Intrinsics.areEqual((Object)((ConeClassLikeType)rValueType).getLookupTag().getClassId(), (Object)StandardClassIds.INSTANCE.getInt()) && ConeTypeUtilsKt.isIntegerTypeOrNullableIntegerTypeOfAnySize(TypeExpansionUtilsKt.fullyExpandedType(lValueType, context2.getSession())) && rValueType.getNullability() == ConeNullability.NOT_NULL) {
            return;
        }
        if (CompilerConeAttributesKt.isExtensionFunctionType(lValueType)) return;
        if (CompilerConeAttributesKt.isExtensionFunctionType(rValueType)) {
            return;
        }
        FirPureAbstractElement firPureAbstractElement = assignment;
        FirCallableSymbol<?> firCallableSymbol = firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getCalleeReference()) != null ? FirExpressionUtilKt.toResolvedCallableSymbol((FirReference)firPureAbstractElement) : null;
        FirPropertySymbol resolvedSymbol = firCallableSymbol instanceof FirPropertySymbol ? (FirPropertySymbol)firCallableSymbol : null;
        if (resolvedSymbol != null && lValueType instanceof ConeCapturedType) {
            ProjectionKind it = ((ConeCapturedType)lValueType).getConstructor().getProjection().getKind();
            boolean bl = false;
            boolean bl2 = it == ProjectionKind.STAR || it == ProjectionKind.OUT;
            if (bl2) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)assignment.getSource(), FirErrors.INSTANCE.getSETTER_PROJECTED_OUT(), (Object)resolvedSymbol, (DiagnosticContext)context2, null, 16, null);
                return;
            }
        }
        if (FirTypeUtilsKt.isNullLiteral(rValue) && lValueType.getNullability() == ConeNullability.NOT_NULL) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)rValue.getSource(), FirErrors.INSTANCE.getNULL_FOR_NONNULL_TYPE(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        if (isInitializer) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINITIALIZER_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, (Object)InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context2.getSession()), rValueType, lValueType), (DiagnosticContext)context2, null, 64, null);
            return;
        }
        if (!(source.getKind() instanceof KtFakeSourceElementKind.DesugaredIncrementOrDecrement)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getASSIGNMENT_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, (Object)InferenceUtilsKt.isTypeMismatchDueToNullability(TypeComponentsKt.getTypeContext(context2.getSession()), rValueType, lValueType), (DiagnosticContext)context2, null, 64, null);
            return;
        }
        if (!ConeTypeUtilsKt.isNullable(lValueType) && ConeTypeUtilsKt.isNullable(rValueType)) {
            ConeKotlinType tempType = rValueType;
            rValueType = lValueType;
            lValueType = tempType;
        }
        if (ConeTypeUtilsKt.isUnit(rValueType)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getINC_DEC_SHOULD_NOT_RETURN_UNIT(), (DiagnosticContext)context2, null, 8, null);
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)source, FirErrors.INSTANCE.getRESULT_TYPE_MISMATCH(), (Object)lValueType, (Object)rValueType, (DiagnosticContext)context2, null, 32, null);
    }

    public static final void checkCondition(@NotNull FirExpression condition, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        ConeSimpleKotlinType coneType;
        Intrinsics.checkNotNullParameter((Object)condition, (String)"condition");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirTypeRef $this$coneTypeSafe$iv = condition.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        ConeSimpleKotlinType coneSimpleKotlinType = coneType = coneKotlinType != null ? ConeTypesKt.lowerBoundIfFlexible(coneKotlinType) : null;
        if (coneType != null && !(coneType instanceof ConeClassErrorType) && !FirHelpersKt.isSubtypeOf(coneType, TypeComponentsKt.getTypeContext(context2.getSession()), context2.getSession().getBuiltinTypes().getBooleanType().getType())) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)condition.getSource(), FirErrors.INSTANCE.getCONDITION_TYPE_MISMATCH(), (Object)coneType, (Object)ConeTypeUtilsKt.isNullableBoolean(coneType), (DiagnosticContext)context2, null, 32, null);
        }
    }

    @Nullable
    public static final FirTypeRefSource extractArgumentTypeRefAndSource(@Nullable FirTypeRef typeRef, int index2) {
        if (typeRef instanceof FirResolvedTypeRef) {
            FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
            if (delegatedTypeRef instanceof FirUserTypeRef) {
                int currentIndex = index2;
                List<FirQualifierPart> qualifier = ((FirUserTypeRef)delegatedTypeRef).getQualifier();
                for (int i = qualifier.size() - 1; -1 < i; --i) {
                    List<FirTypeProjection> typeArguments2 = qualifier.get(i).getTypeArgumentList().getTypeArguments();
                    if (currentIndex < typeArguments2.size()) {
                        FirTypeRefSource firTypeRefSource;
                        FirTypeProjection typeArgument = (FirTypeProjection)CollectionsKt.getOrNull(typeArguments2, (int)currentIndex);
                        if (typeArgument != null) {
                            FirTypeProjectionWithVariance firTypeProjectionWithVariance = typeArgument instanceof FirTypeProjectionWithVariance ? (FirTypeProjectionWithVariance)typeArgument : null;
                            firTypeRefSource = new FirTypeRefSource(firTypeProjectionWithVariance != null ? firTypeProjectionWithVariance.getTypeRef() : null, typeArgument.getSource());
                        } else {
                            firTypeRefSource = null;
                        }
                        return firTypeRefSource;
                    }
                    currentIndex -= typeArguments2.size();
                }
            } else if (delegatedTypeRef instanceof FirFunctionTypeRef) {
                List<FirValueParameter> valueParameters2 = ((FirFunctionTypeRef)delegatedTypeRef).getValueParameters();
                if (index2 < valueParameters2.size()) {
                    FirTypeRef valueParamTypeRef = valueParameters2.get(index2).getReturnTypeRef();
                    return new FirTypeRefSource(valueParamTypeRef, valueParamTypeRef.getSource());
                }
                if (index2 == valueParameters2.size()) {
                    FirTypeRef returnTypeRef = ((FirFunctionTypeRef)delegatedTypeRef).getReturnTypeRef();
                    return new FirTypeRefSource(returnTypeRef, returnTypeRef.getSource());
                }
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Collection<FirEnumEntrySymbol> collectEnumEntries(@NotNull FirRegularClassSymbol $this$collectEnumEntries) {
        void $this$filterIsInstanceTo$iv$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$collectEnumEntries, (String)"<this>");
        boolean bl2 = bl = $this$collectEnumEntries.getClassKind() == ClassKind.ENUM_CLASS;
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        Iterable $this$filterIsInstance$iv = $this$collectEnumEntries.getDeclarationSymbols();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof FirEnumEntrySymbol)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final ClassKind getClassKind(@NotNull FirClassLikeSymbol<?> $this$classKind) {
        Intrinsics.checkNotNullParameter($this$classKind, (String)"<this>");
        FirClassSymbol firClassSymbol = $this$classKind instanceof FirClassSymbol ? (FirClassSymbol)$this$classKind : null;
        return firClassSymbol != null ? firClassSymbol.getClassKind() : null;
    }

    @Nullable
    public static final List<FirTypeParameterSymbol> getTypeParameterSymbols(@NotNull FirBasedSymbol<?> $this$typeParameterSymbols) {
        Intrinsics.checkNotNullParameter($this$typeParameterSymbols, (String)"<this>");
        FirBasedSymbol<?> firBasedSymbol = $this$typeParameterSymbols;
        return firBasedSymbol instanceof FirCallableSymbol ? ((FirCallableSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : (firBasedSymbol instanceof FirClassSymbol ? ((FirClassSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : (firBasedSymbol instanceof FirTypeAliasSymbol ? ((FirTypeAliasSymbol)$this$typeParameterSymbols).getTypeParameterSymbols() : null));
    }

    public static final boolean isFunctionForExpectTypeFromCastFeature(@NotNull FirFunctionSymbol<?> $this$isFunctionForExpectTypeFromCastFeature) {
        block11: {
            block10: {
                boolean bl;
                FirTypeParameterSymbol typeParameterSymbol;
                block9: {
                    Intrinsics.checkNotNullParameter($this$isFunctionForExpectTypeFromCastFeature, (String)"<this>");
                    FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)CollectionsKt.singleOrNull($this$isFunctionForExpectTypeFromCastFeature.getTypeParameterSymbols());
                    if (firTypeParameterSymbol == null) {
                        return false;
                    }
                    typeParameterSymbol = firTypeParameterSymbol;
                    ConeKotlinType returnType2 = FirTypeUtilsKt.getConeType($this$isFunctionForExpectTypeFromCastFeature.getResolvedReturnTypeRef());
                    ConeSimpleKotlinType coneSimpleKotlinType = ConeTypesKt.lowerBoundIfFlexible(returnType2);
                    ConeTypeParameterType coneTypeParameterType = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
                    if (!Intrinsics.areEqual((Object)(coneTypeParameterType != null ? coneTypeParameterType.getLookupTag() : null), (Object)typeParameterSymbol.toLookupTag())) {
                        return false;
                    }
                    Iterable $this$any$iv = $this$isFunctionForExpectTypeFromCastFeature.getValueParameterSymbols();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                            boolean bl2 = false;
                            if (!FirHelpersKt.isFunctionForExpectTypeFromCastFeature$isBadType(it.getResolvedReturnTypeRef(), typeParameterSymbol)) continue;
                            bl = true;
                            break block9;
                        }
                        bl = false;
                    }
                }
                if (bl) break block10;
                FirResolvedTypeRef firResolvedTypeRef = $this$isFunctionForExpectTypeFromCastFeature.getResolvedReceiverTypeRef();
                boolean bl3 = firResolvedTypeRef != null ? FirHelpersKt.isFunctionForExpectTypeFromCastFeature$isBadType(firResolvedTypeRef, typeParameterSymbol) : false;
                if (!bl3) break block11;
            }
            return false;
        }
        return true;
    }

    @NotNull
    public static final AnnotationTargetList getActualTargetList(@NotNull FirDeclaration annotated) {
        AnnotationTargetList annotationTargetList;
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        FirDeclaration firDeclaration = annotated;
        if (firDeclaration instanceof FirRegularClass) {
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)annotated;
            boolean $i$f$isInner = false;
            FirRegularClass $this$isCompanion$iv = (FirRegularClass)annotated;
            boolean $i$f$isCompanion = false;
            FirClassLikeDeclaration $this$isLocal$iv = (FirClassLikeDeclaration)annotated;
            boolean $i$f$isLocal = false;
            AnnotationTargetList annotationTargetList2 = new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(((FirRegularClass)annotated).getClassKind(), $this$isInner$iv.getStatus().isInner(), $this$isCompanion$iv.getStatus().isCompanion(), $this$isLocal$iv.getSymbol().getClassId().isLocal()), null, null, 6, null);
            annotationTargetList = annotationTargetList2;
        } else if (firDeclaration instanceof FirEnumEntry) {
            FirMemberDeclaration $this$isInner$iv = (FirMemberDeclaration)annotated;
            boolean $i$f$isInner = false;
            AnnotationTargetList annotationTargetList3 = new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(ClassKind.ENUM_ENTRY, $this$isInner$iv.getStatus().isInner(), false, false), null, null, 6, null);
            annotationTargetList = annotationTargetList3;
        } else if (firDeclaration instanceof FirProperty) {
            if (((FirProperty)annotated).isLocal()) {
                KtSourceElement ktSourceElement = annotated.getSource();
                annotationTargetList = Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DesugaredComponentFunctionCall.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_DESTRUCTURING_DECLARATION() : AnnotationTargetLists.INSTANCE.getT_LOCAL_VARIABLE();
            } else if (FirHelpersKt.getActualTargetList$isMember(((FirProperty)annotated).getSymbol().getCallableId())) {
                KtSourceElement ktSourceElement = annotated.getSource();
                annotationTargetList = Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.PropertyFromParameter.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : AnnotationTargetLists.INSTANCE.T_MEMBER_PROPERTY(DeclarationAttributesKt.getHasBackingField((FirProperty)annotated), ((FirProperty)annotated).getDelegate() != null);
            } else {
                annotationTargetList = AnnotationTargetLists.INSTANCE.T_TOP_LEVEL_PROPERTY(DeclarationAttributesKt.getHasBackingField((FirProperty)annotated), ((FirProperty)annotated).getDelegate() != null);
            }
        } else if (firDeclaration instanceof FirValueParameter) {
            annotationTargetList = FirHelpersKt.getHasValOrVar((FirValueParameter)annotated) ? AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITH_VAL() : AnnotationTargetLists.INSTANCE.getT_VALUE_PARAMETER_WITHOUT_VAL();
        } else if (firDeclaration instanceof FirConstructor) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_CONSTRUCTOR();
        } else if (firDeclaration instanceof FirAnonymousFunction) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_FUNCTION_EXPRESSION();
        } else if (firDeclaration instanceof FirSimpleFunction) {
            FirSimpleFunction $this$isLocal$iv = (FirSimpleFunction)annotated;
            boolean $i$f$isLocal = false;
            annotationTargetList = Intrinsics.areEqual((Object)$this$isLocal$iv.getStatus().getVisibility(), (Object)Visibilities.Local.INSTANCE) ? AnnotationTargetLists.INSTANCE.getT_LOCAL_FUNCTION() : (FirHelpersKt.getActualTargetList$isMember(((FirSimpleFunction)annotated).getSymbol().getCallableId()) ? AnnotationTargetLists.INSTANCE.getT_MEMBER_FUNCTION() : AnnotationTargetLists.INSTANCE.getT_TOP_LEVEL_FUNCTION());
        } else if (firDeclaration instanceof FirTypeAlias) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_TYPEALIAS();
        } else if (firDeclaration instanceof FirPropertyAccessor) {
            annotationTargetList = ((FirPropertyAccessor)annotated).isGetter() ? AnnotationTargetLists.INSTANCE.getT_PROPERTY_GETTER() : AnnotationTargetLists.INSTANCE.getT_PROPERTY_SETTER();
        } else if (firDeclaration instanceof FirBackingField) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_BACKING_FIELD();
        } else if (firDeclaration instanceof FirFile) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_FILE();
        } else if (firDeclaration instanceof FirTypeParameter) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_TYPE_PARAMETER();
        } else if (firDeclaration instanceof FirAnonymousInitializer) {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getT_INITIALIZER();
        } else if (firDeclaration instanceof FirAnonymousObject) {
            KtSourceElement ktSourceElement = annotated.getSource();
            annotationTargetList = Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.EnumInitializer.INSTANCE) ? new AnnotationTargetList(KotlinTarget.Companion.classActualTargets(ClassKind.ENUM_ENTRY, false, false, false), null, null, 6, null) : AnnotationTargetLists.INSTANCE.getT_OBJECT_LITERAL();
        } else {
            annotationTargetList = AnnotationTargetLists.INSTANCE.getEMPTY();
        }
        return annotationTargetList;
    }

    private static final boolean isSupertypeOf$isSupertypeOf(FirClassSymbol<?> $this$isSupertypeOf_u24isSupertypeOf, FirSession $session, FirClassSymbol<?> other, Set<FirClassSymbol<?>> exclude) {
        for (FirResolvedTypeRef it : other.getResolvedSuperTypeRefs()) {
            FirRegularClassSymbol candidate2;
            FirRegularClassSymbol firRegularClassSymbol = FirHelpersKt.toClassLikeSymbol(it, $session);
            if (firRegularClassSymbol == null) continue;
            if ((firRegularClassSymbol = FirHelpersKt.fullyExpandedClass(firRegularClassSymbol, $session)) == null || exclude.contains(candidate2 = firRegularClassSymbol)) continue;
            exclude.add(candidate2);
            if (Intrinsics.areEqual((Object)candidate2, $this$isSupertypeOf_u24isSupertypeOf)) {
                return true;
            }
            if (!FirHelpersKt.isSupertypeOf$isSupertypeOf($this$isSupertypeOf_u24isSupertypeOf, $session, candidate2, exclude)) continue;
            return true;
        }
        return false;
    }

    private static final boolean isFunctionForExpectTypeFromCastFeature$isBadType(FirTypeRef $this$isFunctionForExpectTypeFromCastFeature_u24isBadType, FirTypeParameterSymbol typeParameterSymbol) {
        ConeKotlinType coneKotlinType;
        FirTypeRef $this$coneTypeSafe$iv = $this$isFunctionForExpectTypeFromCastFeature_u24isBadType;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef != null ? firResolvedTypeRef.getType() : null;
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        return !((coneKotlinType = coneKotlinType2) != null ? !ConeTypeUtilsKt.contains(coneKotlinType, (Function1<? super ConeKotlinType, Boolean>)((Function1)new Function1<ConeKotlinType, Boolean>(typeParameterSymbol){
            final /* synthetic */ FirTypeParameterSymbol $typeParameterSymbol;
            {
                this.$typeParameterSymbol = $typeParameterSymbol;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ConeKotlinType it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ConeSimpleKotlinType coneSimpleKotlinType = ConeTypesKt.lowerBoundIfFlexible(it);
                ConeTypeParameterType coneTypeParameterType = coneSimpleKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneSimpleKotlinType : null;
                return Intrinsics.areEqual((Object)(coneTypeParameterType != null ? coneTypeParameterType.getLookupTag() : null), (Object)this.$typeParameterSymbol.toLookupTag());
            }
        })) : false);
    }

    private static final boolean getActualTargetList$isMember(CallableId $this$getActualTargetList_u24isMember) {
        return $this$getActualTargetList_u24isMember.getClassId() != null || $this$getActualTargetList_u24isMember.isLocal();
    }

    static {
        ClassId classId = ClassId.topLevel(new FqName("kotlin.internal.InlineOnly"));
        Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"topLevel(FqName(\"kotlin.internal.InlineOnly\"))");
        INLINE_ONLY_ANNOTATION_CLASS_ID = classId;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[ProjectionKind.values().length];
            nArray[ProjectionKind.INVARIANT.ordinal()] = 1;
            nArray[ProjectionKind.IN.ordinal()] = 2;
            nArray[ProjectionKind.OUT.ordinal()] = 3;
            nArray[ProjectionKind.STAR.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Variance.values().length];
            nArray[Variance.INVARIANT.ordinal()] = 1;
            nArray[Variance.IN_VARIANCE.ordinal()] = 2;
            nArray[Variance.OUT_VARIANCE.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

