/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J<\u0010\f\u001a\u00020\r*\u00020\u000e2\u0016\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\u00110\u0010j\b\u0012\u0004\u0012\u00020\u0011`\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDelegateUsesExtensionPropertyTypeParameterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "containsTypeParameterFrom", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "parameters", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lkotlin/collections/HashSet;", "delegate", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "checkers"})
public final class FirDelegateUsesExtensionPropertyTypeParameterChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirDelegateUsesExtensionPropertyTypeParameterChecker INSTANCE = new FirDelegateUsesExtensionPropertyTypeParameterChecker();

    private FirDelegateUsesExtensionPropertyTypeParameterChecker() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        Object $this$safeAs$iv = declaration.getDelegate();
        boolean $i$f$safeAs22 = false;
        Object object = $this$safeAs$iv;
        if (!(object instanceof FirFunctionCall)) {
            object = null;
        }
        FirFunctionCall firFunctionCall = (FirFunctionCall)object;
        if (firFunctionCall == null) {
            return;
        }
        FirFunctionCall delegate2 = firFunctionCall;
        $this$safeAs$iv = declaration.getTypeParameters();
        Collection $i$f$safeAs22 = new HashSet();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            FirTypeParameter firTypeParameter = (FirTypeParameter)item$iv;
            void var13_14 = destination$iv;
            boolean bl = false;
            var13_14.add(it.getSymbol());
        }
        HashSet parameters2 = (HashSet)destination$iv;
        boolean shouldReportError = this.containsTypeParameterFrom(FirTypeUtilsKt.getConeType(delegate2.getTypeRef()), parameters2, delegate2, context2, reporter2);
        if (shouldReportError) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getDELEGATE_USES_EXTENSION_PROPERTY_TYPE_PARAMETER(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final boolean containsTypeParameterFrom(ConeKotlinType $this$containsTypeParameterFrom, HashSet<FirTypeParameterSymbol> parameters2, FirFunctionCall delegate2, CheckerContext context2, DiagnosticReporter reporter2) {
        for (ConeTypeProjection it : $this$containsTypeParameterFrom.getTypeArguments()) {
            ConeKotlinType theType;
            FirClassifierSymbol<?> symbol2;
            if (ConeTypesKt.getType(it) == null || !CollectionsKt.contains((Iterable)parameters2, symbol2 = TypeUtilsKt.toSymbol(theType, context2.getSession())) && !this.containsTypeParameterFrom(theType, parameters2, delegate2, context2, reporter2)) continue;
            return true;
        }
        return false;
    }
}

