/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirTypeRefSource;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J*\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOuterClassArgumentsRequiredChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkOuterClassArgumentsRequired", "typeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "checkers"})
public final class FirOuterClassArgumentsRequiredChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirOuterClassArgumentsRequiredChecker INSTANCE = new FirOuterClassArgumentsRequiredChecker();

    private FirOuterClassArgumentsRequiredChecker() {
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        for (FirTypeRef superTypeRef : declaration.getSuperTypeRefs()) {
            this.checkOuterClassArgumentsRequired(superTypeRef, declaration, context2, reporter2);
        }
    }

    private final void checkOuterClassArgumentsRequired(FirTypeRef typeRef, FirRegularClass declaration, CheckerContext context2, DiagnosticReporter reporter2) {
        FirClassLikeSymbol<?> symbol2;
        if (!(typeRef instanceof FirResolvedTypeRef) || typeRef instanceof FirErrorTypeRef) {
            return;
        }
        ConeKotlinType type2 = ((FirResolvedTypeRef)typeRef).getType();
        FirTypeRef delegatedTypeRef = ((FirResolvedTypeRef)typeRef).getDelegatedTypeRef();
        if (delegatedTypeRef instanceof FirUserTypeRef && type2 instanceof ConeClassLikeType && (symbol2 = LookupTagUtilsKt.toSymbol(((ConeClassLikeType)type2).getLookupTag(), context2.getSession())) instanceof FirRegularClassSymbol) {
            ConeTypeProjection[] typeArguments2 = DeclarationUtilsKt.toTypeProjections(((FirUserTypeRef)delegatedTypeRef).getQualifier());
            List<FirTypeParameterSymbol> typeParameters2 = ((FirRegularClassSymbol)symbol2).getTypeParameterSymbols();
            int n = typeParameters2.size();
            for (int index2 = typeArguments2.length; index2 < n; ++index2) {
                FirTypeParameterSymbol typeParameter = typeParameters2.get(index2);
                if (DeclarationUtilsKt.isValidTypeParameterFromOuterDeclaration(typeParameter, declaration, context2.getSession())) continue;
                FirBasedSymbol<?> firBasedSymbol = typeParameter.getContainingDeclarationSymbol();
                FirRegularClassSymbol firRegularClassSymbol = firBasedSymbol instanceof FirRegularClassSymbol ? (FirRegularClassSymbol)firBasedSymbol : null;
                if (firRegularClassSymbol == null) break;
                FirRegularClassSymbol outerClass = firRegularClassSymbol;
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)typeRef.getSource(), FirErrors.INSTANCE.getOUTER_CLASS_ARGUMENTS_REQUIRED(), (Object)outerClass, (DiagnosticContext)context2, null, 16, null);
                break;
            }
        }
        int n = type2.getTypeArguments().length;
        for (int index3 = 0; index3 < n; ++index3) {
            FirTypeRef it;
            FirTypeRefSource firTypeRefSource;
            if (FirHelpersKt.extractArgumentTypeRefAndSource(typeRef, index3) == null) continue;
            if (firTypeRefSource.getTypeRef() == null) continue;
            boolean bl = false;
            INSTANCE.checkOuterClassArgumentsRequired(it, declaration, context2, reporter2);
        }
    }
}

