/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.diagnostics.MutableDiagnosticContext;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.collectors.AbstractDiagnosticCollector;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.types.ConeClassErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J(\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0010\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0011\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyAccessorsTypesChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPropertyChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkAccessorForDelegatedProperty", "property", "accessor", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "checkGetter", "checkSetter", "isLegallyAbstract", "", "checkers"})
public final class FirPropertyAccessorsTypesChecker
extends FirDeclarationChecker<FirProperty> {
    @NotNull
    public static final FirPropertyAccessorsTypesChecker INSTANCE = new FirPropertyAccessorsTypesChecker();

    private FirPropertyAccessorsTypesChecker() {
    }

    @Override
    public void check(@NotNull FirProperty declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        this.checkGetter(declaration, context2, reporter2);
        this.checkSetter(declaration, context2, reporter2);
    }

    private final void checkGetter(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter2) {
        FirPropertyAccessor firPropertyAccessor = property2.getGetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor getter2 = firPropertyAccessor;
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        boolean $i$f$withSuppressedDiagnostics = false;
        List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(getter2);
        if (arguments$iv != null) {
            DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            if (diagnosticContext == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
            }
            CheckerContext it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
            boolean bl = false;
            INSTANCE.checkAccessorForDelegatedProperty(property2, getter2, context2, reporter2);
            FirMemberDeclaration $this$visibility$iv = getter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)visibility2, (Object)$this$visibility$iv.getStatus().getVisibility())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)getter2.getSource(), FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), (DiagnosticContext)context2, null, 8, null);
            }
            if (property2.getSymbol().getCallableId().getClassId() != null && getter2.getBody() != null && property2.getDelegate() == null && INSTANCE.isLegallyAbstract(property2, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)getter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_GETTER(), (DiagnosticContext)context2, null, 8, null);
            }
            FirTypeRef getterReturnTypeRef = getter2.getReturnTypeRef();
            KtSourceElement ktSourceElement = getterReturnTypeRef.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return;
            }
            ConeKotlinType getterReturnType = FirTypeUtilsKt.getConeType(getterReturnTypeRef);
            if (propertyType instanceof ConeClassErrorType || getterReturnType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual((Object)getterReturnType, (Object)FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()))) {
                KtSourceElement getterReturnTypeSource = getterReturnTypeRef.getSource();
                boolean $i$f$withSuppressedDiagnostics2 = false;
                List<String> arguments$iv2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(getterReturnTypeRef);
                if (arguments$iv2 != null) {
                    DiagnosticContext diagnosticContext2 = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                    if (diagnosticContext2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext it2 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext2));
                    boolean bl2 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), (Object)propertyType, (Object)getterReturnType, (DiagnosticContext)context2, null, 32, null);
                } else {
                    CheckerContext it3 = (CheckerContext)((MutableDiagnosticContext)context2);
                    boolean bl3 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), (Object)propertyType, (Object)getterReturnType, (DiagnosticContext)context2, null, 32, null);
                }
            }
        } else {
            CheckerContext it = (CheckerContext)((MutableDiagnosticContext)context2);
            boolean bl = false;
            INSTANCE.checkAccessorForDelegatedProperty(property2, getter2, context2, reporter2);
            FirMemberDeclaration $this$visibility$iv = getter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility3 = $this$visibility$iv.getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            if (!Intrinsics.areEqual((Object)visibility3, (Object)$this$visibility$iv.getStatus().getVisibility())) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)getter2.getSource(), FirErrors.INSTANCE.getGETTER_VISIBILITY_DIFFERS_FROM_PROPERTY_VISIBILITY(), (DiagnosticContext)context2, null, 8, null);
            }
            if (property2.getSymbol().getCallableId().getClassId() != null && getter2.getBody() != null && property2.getDelegate() == null && INSTANCE.isLegallyAbstract(property2, context2)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)getter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_GETTER(), (DiagnosticContext)context2, null, 8, null);
            }
            FirTypeRef getterReturnTypeRef = getter2.getReturnTypeRef();
            KtSourceElement ktSourceElement = getterReturnTypeRef.getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) {
                return;
            }
            ConeKotlinType getterReturnType = FirTypeUtilsKt.getConeType(getterReturnTypeRef);
            if (propertyType instanceof ConeClassErrorType || getterReturnType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual((Object)getterReturnType, (Object)FirTypeUtilsKt.getConeType(property2.getReturnTypeRef()))) {
                KtSourceElement getterReturnTypeSource = getterReturnTypeRef.getSource();
                boolean $i$f$withSuppressedDiagnostics3 = false;
                List<String> arguments$iv3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(getterReturnTypeRef);
                if (arguments$iv3 != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv3, arguments$iv3.contains("infos"), arguments$iv3.contains("warnings"), arguments$iv3.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext it4 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    boolean bl4 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), (Object)propertyType, (Object)getterReturnType, (DiagnosticContext)context2, null, 32, null);
                } else {
                    CheckerContext it5 = (CheckerContext)((MutableDiagnosticContext)context2);
                    boolean bl5 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)getterReturnTypeSource, FirErrors.INSTANCE.getWRONG_GETTER_RETURN_TYPE(), (Object)propertyType, (Object)getterReturnType, (DiagnosticContext)context2, null, 32, null);
                }
            }
        }
    }

    private final void checkSetter(FirProperty property2, CheckerContext context2, DiagnosticReporter reporter2) {
        FirPropertyAccessor firPropertyAccessor = property2.getSetter();
        if (firPropertyAccessor == null) {
            return;
        }
        FirPropertyAccessor setter2 = firPropertyAccessor;
        ConeKotlinType propertyType = FirTypeUtilsKt.getConeType(property2.getReturnTypeRef());
        boolean $i$f$withSuppressedDiagnostics = false;
        List<String> arguments$iv = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(setter2);
        if (arguments$iv != null) {
            FirValueParameter valueSetterParameter;
            DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv, arguments$iv.contains("infos"), arguments$iv.contains("warnings"), arguments$iv.contains("errors"));
            if (diagnosticContext == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
            }
            CheckerContext it = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
            boolean bl = false;
            if (property2.isVal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getVAL_WITH_SETTER(), (DiagnosticContext)context2, null, 8, null);
            }
            INSTANCE.checkAccessorForDelegatedProperty(property2, setter2, context2, reporter2);
            FirMemberDeclaration $this$visibility$iv = setter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility2 = $this$visibility$iv.getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            Integer visibilityCompareResult = visibility2.compareTo($this$visibility$iv.getStatus().getVisibility());
            if (visibilityCompareResult == null || visibilityCompareResult > 0) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getSETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY(), (DiagnosticContext)context2, null, 8, null);
            }
            if (property2.getSymbol().getCallableId().getClassId() != null && property2.getDelegate() == null) {
                boolean isLegallyAbstract = INSTANCE.isLegallyAbstract(property2, context2);
                FirMemberDeclaration $this$visibility$iv2 = setter2;
                boolean $i$f$getVisibility2 = false;
                if (Intrinsics.areEqual((Object)$this$visibility$iv2.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                    $this$visibility$iv2 = property2;
                    $i$f$getVisibility2 = false;
                    if (!Intrinsics.areEqual((Object)$this$visibility$iv2.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                        if (isLegallyAbstract) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_ABSTRACT_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                        } else {
                            FirMemberDeclaration $this$isOpen$iv = property2;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_OPEN_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                            }
                        }
                    }
                }
                if (isLegallyAbstract && setter2.getBody() != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_SETTER(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            if ((valueSetterParameter = (FirValueParameter)CollectionsKt.first(setter2.getValueParameters())).isVararg()) {
                return;
            }
            ConeKotlinType valueSetterType = FirTypeUtilsKt.getConeType(valueSetterParameter.getReturnTypeRef());
            KtSourceElement valueSetterTypeSource = valueSetterParameter.getReturnTypeRef().getSource();
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual((Object)valueSetterType, (Object)propertyType)) {
                boolean bl2;
                boolean $i$f$withSuppressedDiagnostics2 = false;
                List<String> arguments$iv2 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(valueSetterParameter);
                if (arguments$iv2 != null) {
                    DiagnosticContext diagnosticContext2 = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv2, arguments$iv2.contains("infos"), arguments$iv2.contains("warnings"), arguments$iv2.contains("errors"));
                    if (diagnosticContext2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext it2 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext2));
                    bl2 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), (Object)propertyType, (Object)valueSetterType, (DiagnosticContext)context2, null, 32, null);
                } else {
                    CheckerContext it3 = (CheckerContext)((MutableDiagnosticContext)context2);
                    bl2 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), (Object)propertyType, (Object)valueSetterType, (DiagnosticContext)context2, null, 32, null);
                }
            }
            ConeKotlinType setterReturnType = FirTypeUtilsKt.getConeType(setter2.getReturnTypeRef());
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!ConeTypeUtilsKt.isUnit(setterReturnType)) {
                FirAnnotationContainer annotationContainer$iv = setter2.getReturnTypeRef();
                boolean $i$f$withSuppressedDiagnostics3 = false;
                List<String> arguments$iv3 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotationContainer$iv);
                if (arguments$iv3 != null) {
                    DiagnosticContext diagnosticContext3 = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv3, arguments$iv3.contains("infos"), arguments$iv3.contains("warnings"), arguments$iv3.contains("errors"));
                    if (diagnosticContext3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext it4 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext3));
                    boolean bl3 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), (DiagnosticContext)context2, null, 8, null);
                } else {
                    CheckerContext it5 = (CheckerContext)((MutableDiagnosticContext)context2);
                    boolean bl4 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        } else {
            FirValueParameter valueSetterParameter;
            CheckerContext it = (CheckerContext)((MutableDiagnosticContext)context2);
            boolean bl = false;
            if (property2.isVal()) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getVAL_WITH_SETTER(), (DiagnosticContext)context2, null, 8, null);
            }
            INSTANCE.checkAccessorForDelegatedProperty(property2, setter2, context2, reporter2);
            FirMemberDeclaration $this$visibility$iv = setter2;
            boolean $i$f$getVisibility = false;
            Visibility visibility3 = $this$visibility$iv.getStatus().getVisibility();
            $this$visibility$iv = property2;
            $i$f$getVisibility = false;
            Integer visibilityCompareResult = visibility3.compareTo($this$visibility$iv.getStatus().getVisibility());
            if (visibilityCompareResult == null || visibilityCompareResult > 0) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getSETTER_VISIBILITY_INCONSISTENT_WITH_PROPERTY_VISIBILITY(), (DiagnosticContext)context2, null, 8, null);
            }
            if (property2.getSymbol().getCallableId().getClassId() != null && property2.getDelegate() == null) {
                boolean isLegallyAbstract = INSTANCE.isLegallyAbstract(property2, context2);
                FirMemberDeclaration $this$visibility$iv3 = setter2;
                boolean $i$f$getVisibility3 = false;
                if (Intrinsics.areEqual((Object)$this$visibility$iv3.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                    $this$visibility$iv3 = property2;
                    $i$f$getVisibility3 = false;
                    if (!Intrinsics.areEqual((Object)$this$visibility$iv3.getStatus().getVisibility(), (Object)Visibilities.Private.INSTANCE)) {
                        if (isLegallyAbstract) {
                            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_ABSTRACT_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                        } else {
                            FirMemberDeclaration $this$isOpen$iv = property2;
                            boolean $i$f$isOpen = false;
                            if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) {
                                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getPRIVATE_SETTER_FOR_OPEN_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
                            }
                        }
                    }
                }
                if (isLegallyAbstract && setter2.getBody() != null) {
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getSource(), FirErrors.INSTANCE.getABSTRACT_PROPERTY_WITH_SETTER(), (DiagnosticContext)context2, null, 8, null);
                }
            }
            if ((valueSetterParameter = (FirValueParameter)CollectionsKt.first(setter2.getValueParameters())).isVararg()) {
                return;
            }
            ConeKotlinType valueSetterType = FirTypeUtilsKt.getConeType(valueSetterParameter.getReturnTypeRef());
            KtSourceElement valueSetterTypeSource = valueSetterParameter.getReturnTypeRef().getSource();
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!Intrinsics.areEqual((Object)valueSetterType, (Object)propertyType)) {
                boolean bl5;
                boolean $i$f$withSuppressedDiagnostics4 = false;
                List<String> arguments$iv4 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(valueSetterParameter);
                if (arguments$iv4 != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv4, arguments$iv4.contains("infos"), arguments$iv4.contains("warnings"), arguments$iv4.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext it6 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    bl5 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), (Object)propertyType, (Object)valueSetterType, (DiagnosticContext)context2, null, 32, null);
                } else {
                    CheckerContext it7 = (CheckerContext)((MutableDiagnosticContext)context2);
                    bl5 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)valueSetterTypeSource, FirErrors.INSTANCE.getWRONG_SETTER_PARAMETER_TYPE(), (Object)propertyType, (Object)valueSetterType, (DiagnosticContext)context2, null, 32, null);
                }
            }
            ConeKotlinType setterReturnType = FirTypeUtilsKt.getConeType(setter2.getReturnTypeRef());
            if (propertyType instanceof ConeClassErrorType || valueSetterType instanceof ConeClassErrorType) {
                return;
            }
            if (!ConeTypeUtilsKt.isUnit(setterReturnType)) {
                FirAnnotationContainer annotationContainer$iv = setter2.getReturnTypeRef();
                boolean $i$f$withSuppressedDiagnostics5 = false;
                List<String> arguments$iv5 = AbstractDiagnosticCollector.Companion.getDiagnosticsSuppressedForContainer(annotationContainer$iv);
                if (arguments$iv5 != null) {
                    DiagnosticContext diagnosticContext = ((MutableDiagnosticContext)context2).addSuppressedDiagnostics((Collection<String>)arguments$iv5, arguments$iv5.contains("infos"), arguments$iv5.contains("warnings"), arguments$iv5.contains("errors"));
                    if (diagnosticContext == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext");
                    }
                    CheckerContext it8 = (CheckerContext)((MutableDiagnosticContext)((CheckerContext)diagnosticContext));
                    boolean bl6 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), (DiagnosticContext)context2, null, 8, null);
                } else {
                    CheckerContext it9 = (CheckerContext)((MutableDiagnosticContext)context2);
                    boolean bl7 = false;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)setter2.getReturnTypeRef().getSource(), FirErrors.INSTANCE.getWRONG_SETTER_RETURN_TYPE(), (DiagnosticContext)context2, null, 8, null);
                }
            }
        }
    }

    private final void checkAccessorForDelegatedProperty(FirProperty property2, FirPropertyAccessor accessor, CheckerContext context2, DiagnosticReporter reporter2) {
        if (property2.getDelegateFieldSymbol() != null && accessor.getBody() != null) {
            KtSourceElement ktSourceElement = accessor.getSource();
            if (!Intrinsics.areEqual((Object)(ktSourceElement != null ? ktSourceElement.getKind() : null), (Object)KtFakeSourceElementKind.DelegatedPropertyAccessor.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)accessor.getSource(), FirErrors.INSTANCE.getACCESSOR_FOR_DELEGATED_PROPERTY(), (DiagnosticContext)context2, null, 8, null);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isLegallyAbstract(FirProperty property2, CheckerContext context2) {
        FirMemberDeclaration $this$isAbstract$iv = property2;
        boolean $i$f$isAbstract = false;
        if ($this$isAbstract$iv.getStatus().getModality() != Modality.ABSTRACT) return false;
        boolean bl = true;
        if (!bl) return false;
        FirClass it = FirHelpersKt.findClosestClassOrObject(context2);
        boolean bl2 = false;
        if (!(it instanceof FirRegularClass)) return false;
        FirRegularClass $this$canHaveAbstractDeclaration$iv = (FirRegularClass)it;
        boolean $i$f$getCanHaveAbstractDeclaration = false;
        FirMemberDeclaration $this$isAbstract$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isAbstract2 = false;
        if ($this$isAbstract$iv$iv.getStatus().getModality() == Modality.ABSTRACT) {
            return true;
        }
        boolean bl3 = false;
        if (bl3) return true;
        FirRegularClass $this$isSealed$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isSealed = false;
        if ($this$isSealed$iv$iv.getStatus().getModality() == Modality.SEALED) {
            return true;
        }
        boolean bl4 = false;
        if (bl4) return true;
        FirClass $this$isEnumClass$iv$iv = $this$canHaveAbstractDeclaration$iv;
        boolean $i$f$isEnumClass = false;
        ClassKind $this$isEnumClass$iv$iv$iv = $this$isEnumClass$iv$iv.getClassKind();
        boolean $i$f$isEnumClass2 = false;
        if ($this$isEnumClass$iv$iv$iv != ClassKind.ENUM_CLASS) return false;
        return true;
    }
}

