/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u0002H\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002J\u0014\u0010\u0013\u001a\u00020\u0011*\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/declaration/FirJvmNameChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "()V", "NAME", "Lorg/jetbrains/kotlin/name/Name;", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "findJvmNameAnnotation", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "isInlineThatRequiresMangling", "", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "isRenamableFunction", "function", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "checkers.jvm"})
public final class FirJvmNameChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJvmNameChecker INSTANCE = new FirJvmNameChecker();
    @NotNull
    private static final Name NAME;

    private FirJvmNameChecker() {
    }

    @Override
    public void check(@NotNull FirDeclaration declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        block10: {
            FirAnnotation jvmName2;
            block11: {
                block9: {
                    Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
                    FirAnnotation firAnnotation = this.findJvmNameAnnotation(declaration);
                    if (firAnnotation == null) {
                        return;
                    }
                    jvmName2 = firAnnotation;
                    FirExpression firExpression2 = FirAnnotationUtilsKt.findArgumentByName(jvmName2, NAME);
                    if (firExpression2 == null) {
                        return;
                    }
                    FirExpression name2 = firExpression2;
                    if (!Intrinsics.areEqual((Object)FirTypeUtilsKt.getConeType(name2.getTypeRef()), (Object)context2.getSession().getBuiltinTypes().getStringType().getType())) {
                        return;
                    }
                    FirExpression $this$safeAs$iv = name2;
                    boolean $i$f$safeAs = false;
                    FirExpression firExpression3 = $this$safeAs$iv;
                    if (!(firExpression3 instanceof FirConstExpression)) {
                        firExpression3 = null;
                    }
                    FirConstExpression firConstExpression = (FirConstExpression)firExpression3;
                    Object t = firConstExpression != null ? firConstExpression.getValue() : null;
                    String string2 = t instanceof String ? (String)t : null;
                    if (string2 == null) {
                        return;
                    }
                    String value2 = string2;
                    if (!Name.isValidIdentifier(value2)) {
                        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getILLEGAL_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
                    }
                    if (!(declaration instanceof FirFunction) || this.isRenamableFunction(context2, (FirFunction)declaration)) break block9;
                    KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
                    break block10;
                }
                if (!(declaration instanceof FirCallableDeclaration)) break block10;
                FirRegularClass containingClass = ResolveUtilsKt.getContainingClass((FirCallableDeclaration)declaration, context2.getSession());
                FirMemberDeclaration $this$isOverride$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isOverride = false;
                if ($this$isOverride$iv.getStatus().isOverride()) break block11;
                FirMemberDeclaration $this$isOpen$iv = (FirMemberDeclaration)declaration;
                boolean $i$f$isOpen = false;
                if ($this$isOpen$iv.getStatus().getModality() == Modality.OPEN) break block11;
                FirRegularClass firRegularClass = containingClass;
                boolean bl = firRegularClass != null ? this.isInlineThatRequiresMangling(firRegularClass) : false;
                if (!bl) break block10;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)jvmName2.getSource(), FirJvmErrors.INSTANCE.getINAPPLICABLE_JVM_NAME(), (DiagnosticContext)context2, null, 8, null);
        }
    }

    private final FirAnnotation findJvmNameAnnotation(FirDeclaration $this$findJvmNameAnnotation) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = $this$findJvmNameAnnotation.getAnnotations();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FirAnnotation it = (FirAnnotation)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)ConeTypeUtilsKt.getClassId(FirTypeUtilsKt.getConeType(it.getAnnotationTypeRef())), (Object)StandardClassIds.Annotations.INSTANCE.getJvmName())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final boolean isRenamableFunction(CheckerContext $this$isRenamableFunction, FirFunction function2) {
        FirClassLikeSymbol<?> containingClass = FirHelpersKt.getContainingClassSymbol(function2, $this$isRenamableFunction.getSession());
        return containingClass != null || !function2.getSymbol().getCallableId().isLocal();
    }

    private final boolean isInlineThatRequiresMangling(FirRegularClass $this$isInlineThatRequiresMangling) {
        FirMemberDeclaration $this$isInline$iv = $this$isInlineThatRequiresMangling;
        boolean $i$f$isInline = false;
        return $this$isInline$iv.getStatus().isInline() && Intrinsics.areEqual((Object)$this$isInlineThatRequiresMangling.getName(), (Object)StandardClassIds.INSTANCE.getResult().getShortClassName());
    }

    static {
        Name name2 = Name.identifier("name");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(\"name\")");
        NAME = name2;
    }
}

