/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory1;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirSuperReference;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirSuperCallWithDefaultsChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers.jvm"})
public final class FirSuperCallWithDefaultsChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirSuperCallWithDefaultsChecker INSTANCE = new FirSuperCallWithDefaultsChecker();

    private FirSuperCallWithDefaultsChecker() {
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        boolean bl;
        FirNamedFunctionSymbol functionSymbol;
        block10: {
            FirQualifiedAccessExpression firQualifiedAccessExpression;
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            FirExpression $this$safeAs$iv = expression2.getExplicitReceiver();
            boolean $i$f$safeAs = false;
            FirExpression firExpression2 = $this$safeAs$iv;
            if (!(firExpression2 instanceof FirQualifiedAccessExpression)) {
                firExpression2 = null;
            }
            FirReference $this$safeAs$iv2 = (firQualifiedAccessExpression = (FirQualifiedAccessExpression)firExpression2) != null ? firQualifiedAccessExpression.getCalleeReference() : null;
            boolean $i$f$safeAs22 = false;
            FirReference firReference = $this$safeAs$iv2;
            if (!(firReference instanceof FirSuperReference)) {
                firReference = null;
            }
            if ((FirSuperReference)firReference == null) {
                return;
            }
            FirBasedSymbol<?> $i$f$safeAs22 = UtilsKt.getResolvedSymbol(expression2.getCalleeReference());
            FirNamedFunctionSymbol firNamedFunctionSymbol = $i$f$safeAs22 instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)$i$f$safeAs22 : null;
            if (firNamedFunctionSymbol == null) {
                return;
            }
            functionSymbol = firNamedFunctionSymbol;
            Iterable $this$any$iv = functionSymbol.getValueParameterSymbols();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirValueParameterSymbol it = (FirValueParameterSymbol)element$iv;
                    boolean bl2 = false;
                    if (!it.getHasDefaultValue()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (!bl) {
            return;
        }
        FirArgumentList firArgumentList = expression2.getArgumentList();
        FirResolvedArgumentList firResolvedArgumentList = firArgumentList instanceof FirResolvedArgumentList ? (FirResolvedArgumentList)firArgumentList : null;
        if (firResolvedArgumentList == null) {
            return;
        }
        FirResolvedArgumentList arguments2 = firResolvedArgumentList;
        if (arguments2.getArguments().size() < functionSymbol.getValueParameterSymbols().size()) {
            AbstractKtSourceElement abstractKtSourceElement = expression2.getCalleeReference().getSource();
            KtDiagnosticFactory1<String> ktDiagnosticFactory1 = FirJvmErrors.INSTANCE.getSUPER_CALL_WITH_DEFAULT_PARAMETERS();
            String string2 = functionSymbol.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"functionSymbol.name.asString()");
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, abstractKtSourceElement, ktDiagnosticFactory1, (Object)string2, (DiagnosticContext)context2, null, 16, null);
        }
    }
}

