/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.storage;

import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022$\u0012 \u0012\u001e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0004j\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002`\u00050\u0003B!\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003\u00a2\u0006\u0002\u0010\bJ,\u0010\t\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016J4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\"\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u0004j\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u0001`\u0005H\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/incremental/storage/LinkedHashMapExternalizer;", "K", "V", "Lcom/intellij/util/io/DataExternalizer;", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "keyExternalizer", "valueExternalizer", "(Lcom/intellij/util/io/DataExternalizer;Lcom/intellij/util/io/DataExternalizer;)V", "read", "input", "Ljava/io/DataInput;", "save", "", "output", "Ljava/io/DataOutput;", "map", "kotlin-build-common"})
public final class LinkedHashMapExternalizer<K, V>
implements DataExternalizer<LinkedHashMap<K, V>> {
    @NotNull
    private final DataExternalizer<K> keyExternalizer;
    @NotNull
    private final DataExternalizer<V> valueExternalizer;

    public LinkedHashMapExternalizer(@NotNull DataExternalizer<K> keyExternalizer, @NotNull DataExternalizer<V> valueExternalizer) {
        Intrinsics.checkNotNullParameter(keyExternalizer, (String)"keyExternalizer");
        Intrinsics.checkNotNullParameter(valueExternalizer, (String)"valueExternalizer");
        this.keyExternalizer = keyExternalizer;
        this.valueExternalizer = valueExternalizer;
    }

    public void save(@NotNull DataOutput output, @NotNull LinkedHashMap<K, V> map) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(map, (String)"map");
        output.writeInt(map.size());
        for (Map.Entry entry : ((Map)map).entrySet()) {
            Object key = entry.getKey();
            Object value2 = entry.getValue();
            this.keyExternalizer.save(output, key);
            this.valueExternalizer.save(output, value2);
        }
    }

    @NotNull
    public LinkedHashMap<K, V> read(@NotNull DataInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        int size = input.readInt();
        LinkedHashMap map = new LinkedHashMap(size);
        int n = 0;
        while (n < size) {
            int it = n++;
            boolean bl = false;
            Object key = this.keyExternalizer.read(input);
            Object value2 = this.valueExternalizer.read(input);
            ((Map)map).put(key, value2);
        }
        return map;
    }
}

