/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirModuleResolveState;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LowLevelFirApiFacadeForResolveOnAir;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FirElementsRecorder;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010J\u0018\u0010\u0011\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0012\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00030\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/KtToFirMapping;", "", "firElement", "Lorg/jetbrains/kotlin/fir/FirElement;", "recorder", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FirElementsRecorder;", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FirElementsRecorder;)V", "mapping", "", "Lorg/jetbrains/kotlin/psi/KtElement;", "userTypeMapping", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/kotlin/psi/KtUserType;", "getElement", "ktElement", "state", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirModuleResolveState;", "getFirOfClosestParent", "element", "low-level-api-fir"})
public final class KtToFirMapping {
    @NotNull
    private final Map<KtElement, FirElement> mapping;
    @NotNull
    private final ConcurrentHashMap<KtUserType, FirElement> userTypeMapping;

    public KtToFirMapping(@NotNull FirElement firElement, @NotNull FirElementsRecorder recorder2) {
        Intrinsics.checkNotNullParameter((Object)firElement, (String)"firElement");
        Intrinsics.checkNotNullParameter((Object)recorder2, (String)"recorder");
        this.mapping = FirElementsRecorder.Companion.recordElementsFrom(firElement, recorder2);
        this.userTypeMapping = new ConcurrentHashMap();
    }

    @Nullable
    public final FirElement getElement(@NotNull KtElement ktElement, @NotNull LLFirModuleResolveState state) {
        PsiElement psiElement2;
        Intrinsics.checkNotNullParameter((Object)ktElement, (String)"ktElement");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        FirElement firElement = this.mapping.get(ktElement);
        if (firElement != null) {
            FirElement it = firElement;
            boolean psiElement2 = false;
            return it;
        }
        KtElement it = ktElement;
        KtUserType ktUserType = it instanceof KtUserType ? (KtUserType)ktElement : (it instanceof KtNameReferenceExpression ? ((psiElement2 = ((KtNameReferenceExpression)ktElement).getParent()) instanceof KtUserType ? (KtUserType)psiElement2 : null) : null);
        if (ktUserType == null) {
            return null;
        }
        KtUserType userType = ktUserType;
        if (userType.getParent() instanceof KtTypeReference) {
            return null;
        }
        ConcurrentMap $this$getOrPut$iv = this.userTypeMapping;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(userType);
        if (object == null) {
            boolean bl = false;
            Project project = ktElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"ktElement.project");
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
            String string2 = userType.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"userType.text");
            KtTypeReference typeReference = ktPsiFactory.createType(string2);
            FirElement default$iv = LowLevelFirApiFacadeForResolveOnAir.INSTANCE.onAirResolveTypeInPlace(ktElement, typeReference, state);
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(userType, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        return (FirElement)object;
    }

    @Nullable
    public final FirElement getFirOfClosestParent(@NotNull KtElement element, @NotNull LLFirModuleResolveState state) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        for (PsiElement current = (PsiElement)element; current != null && !(current instanceof KtFile); current = current.getParent()) {
            FirElement firElement;
            if (!(current instanceof KtElement) || (firElement = this.getElement((KtElement)current, state)) == null) continue;
            FirElement it = firElement;
            boolean bl = false;
            return it;
        }
        return null;
    }
}

