/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory3;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirVariableAssignment;
import org.jetbrains.kotlin.fir.references.FirBackingFieldReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.resolve.calls.ExpressionReceiverValue;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirBackingFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.name.CallableId;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirReassignmentAndInvisibleSetterChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirVariableAssignment;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirVariableAssignmentChecker;", "()V", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkInvisibleSetter", "checkValReassignmentOnValueParameter", "checkValReassignmentViaBackingField", "checkers"})
public final class FirReassignmentAndInvisibleSetterChecker
extends FirExpressionChecker<FirVariableAssignment> {
    @NotNull
    public static final FirReassignmentAndInvisibleSetterChecker INSTANCE = new FirReassignmentAndInvisibleSetterChecker();

    private FirReassignmentAndInvisibleSetterChecker() {
    }

    @Override
    public void check(@NotNull FirVariableAssignment expression2, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        this.checkInvisibleSetter(expression2, context, reporter2);
        this.checkValReassignmentViaBackingField(expression2, context, reporter2);
        this.checkValReassignmentOnValueParameter(expression2, context, reporter2);
    }

    private final void checkInvisibleSetter(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter2) {
        block5: {
            Object object;
            KtDiagnosticFactory3<FirPropertySymbol, Visibility, CallableId> ktDiagnosticFactory3;
            AbstractKtSourceElement abstractKtSourceElement;
            FirCallableSymbol<?> callableSymbol;
            block7: {
                block6: {
                    FirRegularClassSymbol symbol2;
                    callableSymbol = FirExpressionUtilKt.toResolvedCallableSymbol(expression2.getCalleeReference());
                    if (!(callableSymbol instanceof FirPropertySymbol) || !FirReassignmentAndInvisibleSetterChecker.checkInvisibleSetter$shouldInvisibleSetterBeReported(context, expression2, (FirPropertySymbol)callableSymbol)) break block5;
                    FirExpression explicitReceiver = expression2.getExplicitReceiver();
                    if (explicitReceiver instanceof FirExpressionWithSmartcast && (symbol2 = FirHelpersKt.toRegularClassSymbol(((FirExpressionWithSmartcast)explicitReceiver).getOriginalType(), context.getSession())) != null) {
                        for (FirBasedSymbol<?> declarationSymbol : symbol2.getDeclarationSymbols()) {
                            if (!(declarationSymbol instanceof FirPropertySymbol) || !Intrinsics.areEqual((Object)((FirPropertySymbol)declarationSymbol).getName(), (Object)callableSymbol.getName()) || FirReassignmentAndInvisibleSetterChecker.checkInvisibleSetter$shouldInvisibleSetterBeReported(context, expression2, (FirPropertySymbol)declarationSymbol)) continue;
                            return;
                        }
                    }
                    abstractKtSourceElement = expression2.getSource();
                    ktDiagnosticFactory3 = FirErrors.INSTANCE.getINVISIBLE_SETTER();
                    object = ((FirPropertySymbol)callableSymbol).getSetterSymbol();
                    if (object == null) break block6;
                    FirCallableSymbol $this$visibility$iv = (FirCallableSymbol)object;
                    boolean $i$f$getVisibility = false;
                    object = $this$visibility$iv.getResolvedStatus().getVisibility();
                    if (object != null) break block7;
                }
                object = Visibilities.Private.INSTANCE;
            }
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, abstractKtSourceElement, ktDiagnosticFactory3, callableSymbol, object, (Object)callableSymbol.getCallableId(), (DiagnosticContext)context, null, 64, null);
        }
    }

    private final void checkValReassignmentViaBackingField(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter2) {
        Object object;
        FirElement firElement;
        FirBackingFieldSymbol propertySymbol2;
        FirBackingFieldReference backingFieldReference;
        block7: {
            FirReference firReference = expression2.getLValue();
            FirBackingFieldReference firBackingFieldReference = firReference instanceof FirBackingFieldReference ? (FirBackingFieldReference)firReference : null;
            if (firBackingFieldReference == null) {
                return;
            }
            backingFieldReference = firBackingFieldReference;
            propertySymbol2 = backingFieldReference.getResolvedSymbol();
            if (propertySymbol2.isVar()) {
                return;
            }
            CheckerContext $this$findClosest$iv = context;
            boolean $i$f$findClosest = false;
            for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest$iv.getContainingDeclarations())) {
                FirDeclaration firDeclaration = it$iv;
                if (!(firDeclaration instanceof FirPropertyAccessor)) {
                    firDeclaration = null;
                }
                if ((firElement = (FirElement)((FirPropertyAccessor)firDeclaration)) == null) continue;
                FirElement firElement2 = firElement;
                FirPropertyAccessor it = (FirPropertyAccessor)firElement2;
                boolean bl = false;
                firElement = it.isGetter() ? firElement2 : null;
                if (firElement == null) {
                    continue;
                }
                break block7;
            }
            firElement = null;
        }
        if ((object = (FirPropertyAccessor)firElement) == null || (object = ((FirPropertyAccessor)object).getSymbol()) == null) {
            return;
        }
        Object closestGetter = object;
        if (!Intrinsics.areEqual((Object)propertySymbol2.getGetterSymbol(), (Object)closestGetter)) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)backingFieldReference.getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT_VIA_BACKING_FIELD(), (Object)propertySymbol2, (DiagnosticContext)context, null, 16, null);
    }

    private final void checkValReassignmentOnValueParameter(FirVariableAssignment expression2, CheckerContext context, DiagnosticReporter reporter2) {
        FirBasedSymbol<?> firBasedSymbol = UtilsKt.getResolvedSymbol(expression2.getLValue());
        FirValueParameterSymbol firValueParameterSymbol = firBasedSymbol instanceof FirValueParameterSymbol ? (FirValueParameterSymbol)firBasedSymbol : null;
        if (firValueParameterSymbol == null) {
            return;
        }
        FirValueParameterSymbol valueParameter2 = firValueParameterSymbol;
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)expression2.getLValue().getSource(), FirErrors.INSTANCE.getVAL_REASSIGNMENT(), (Object)valueParameter2, (DiagnosticContext)context, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean checkInvisibleSetter$shouldInvisibleSetterBeReported(CheckerContext $context, FirVariableAssignment $expression, FirPropertySymbol symbol2) {
        Object setterFir;
        Object object = symbol2.getSetterSymbol();
        if (object == null || (object = (FirPropertyAccessor)((FirBasedSymbol)object).getFir()) == null) {
            FirCallableSymbol $this$originalForSubstitutionOverride$iv = symbol2;
            boolean $i$f$getOriginalForSubstitutionOverride = false;
            FirCallableDeclaration $this$originalForSubstitutionOverride$iv$iv = (FirCallableDeclaration)$this$originalForSubstitutionOverride$iv.getFir();
            boolean $i$f$getOriginalForSubstitutionOverride2 = false;
            FirCallableDeclaration firCallableDeclaration = ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv) ? ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv) : null;
            FirCallableSymbol firCallableSymbol = (FirPropertySymbol)((FirCallableSymbol)((FirPropertySymbol)(firCallableDeclaration != null ? firCallableDeclaration.getSymbol() : null)));
            object = firCallableSymbol != null && (firCallableSymbol = ((FirPropertySymbol)firCallableSymbol).getSetterSymbol()) != null ? (FirPropertyAccessor)firCallableSymbol.getFir() : null;
        }
        if ((setterFir = object) != null) {
            FirElement firElement;
            FirElement firElement2;
            FirVisibilityChecker firVisibilityChecker;
            FirMemberDeclaration firMemberDeclaration;
            FirSession firSession;
            block5: {
                void $this$findClosest_u24default$iv;
                CheckerContext checkerContext = $context;
                firSession = $context.getSession();
                firMemberDeclaration = (FirMemberDeclaration)setterFir;
                firVisibilityChecker = FirVisibilityCheckerKt.getVisibilityChecker($context.getSession());
                boolean $i$f$findClosest = false;
                for (FirDeclaration it$iv : CollectionsKt.asReversed($this$findClosest_u24default$iv.getContainingDeclarations())) {
                    FirElement firElement3;
                    FirDeclaration firDeclaration = it$iv;
                    if (!(firDeclaration instanceof FirFile)) {
                        firDeclaration = null;
                    }
                    if ((firElement2 = (FirElement)((FirFile)firDeclaration)) == null) continue;
                    FirElement $i$f$getOriginalForSubstitutionOverride2 = firElement3 = firElement2;
                    boolean bl = false;
                    FirElement it = $i$f$getOriginalForSubstitutionOverride2;
                    firElement2 = true ? firElement3 : null;
                    if (firElement2 == null) {
                        continue;
                    }
                    break block5;
                }
                firElement2 = null;
            }
            FirElement firElement4 = firElement = firElement2;
            Intrinsics.checkNotNull(firElement4);
            return !FirVisibilityChecker.isVisible$default(firVisibilityChecker, firMemberDeclaration, firSession, (FirFile)firElement4, $context.getContainingDeclarations(), new ExpressionReceiverValue($expression.getDispatchReceiver()), false, false, null, 224, null);
        }
        return false;
    }
}

