/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.renderer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValue;
import org.jetbrains.kotlin.analysis.api.annotations.KtAnnotationValueKt;
import org.jetbrains.kotlin.analysis.api.annotations.KtUnsupportedAnnotationValue;
import org.jetbrains.kotlin.analysis.api.components.KtConstantEvaluationMode;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirAnnotationValueConverter;
import org.jetbrains.kotlin.analysis.api.fir.evaluate.FirCompileTimeConstantEvaluator;
import org.jetbrains.kotlin.analysis.api.fir.renderer.ConeTypeIdeRenderer;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a \u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0004H\u0002\u001a6\u0010\u0011\u001a\u00020\u0012*\u00060\u0013j\u0002`\u00142\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00040\u00012\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0010H\u0000\u00a8\u0006\u0017"}, d2={"renderAndSortAnnotationArguments", "", "", "descriptor", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "renderAnnotation", "annotation", "coneTypeIdeRenderer", "Lorg/jetbrains/kotlin/analysis/api/fir/renderer/ConeTypeIdeRenderer;", "renderConstant", "value", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "useSiteSession", "isParameterName", "", "renderAnnotations", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "annotations", "isSingleLineAnnotations", "analysis-api-fir"})
public final class FirAnnotationsIdeRendererKt {
    public static final void renderAnnotations(@NotNull Appendable $this$renderAnnotations, @NotNull ConeTypeIdeRenderer coneTypeIdeRenderer, @NotNull List<? extends FirAnnotation> annotations2, @NotNull FirSession session2, boolean isSingleLineAnnotations) {
        Intrinsics.checkNotNullParameter((Object)$this$renderAnnotations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)coneTypeIdeRenderer, (String)"coneTypeIdeRenderer");
        Intrinsics.checkNotNullParameter(annotations2, (String)"annotations");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        String separator = isSingleLineAnnotations ? " " : "\n";
        for (FirAnnotation firAnnotation : annotations2) {
            if (FirAnnotationsIdeRendererKt.isParameterName(firAnnotation)) continue;
            $this$renderAnnotations.append(FirAnnotationsIdeRendererKt.renderAnnotation(firAnnotation, coneTypeIdeRenderer, session2));
            $this$renderAnnotations.append(separator);
        }
    }

    private static final boolean isParameterName(FirAnnotation $this$isParameterName) {
        ClassId classId = FirAnnotationUtilsKt.toAnnotationClassId($this$isParameterName);
        return Intrinsics.areEqual((Object)(classId != null ? classId.asSingleFqName() : null), (Object)StandardNames.FqNames.parameterName);
    }

    private static final String renderAnnotation(FirAnnotation annotation2, ConeTypeIdeRenderer coneTypeIdeRenderer, FirSession session2) {
        StringBuilder stringBuilder2;
        StringBuilder $this$renderAnnotation_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        $this$renderAnnotation_u24lambda_u240.append('@');
        FirTypeRef firTypeRef = annotation2.getTypeRef();
        FirResolvedTypeRef resolvedTypeRef = firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null;
        if (!(resolvedTypeRef != null)) {
            String string2 = "Check failed.";
            throw new IllegalStateException(string2.toString());
        }
        $this$renderAnnotation_u24lambda_u240.append(coneTypeIdeRenderer.renderType(resolvedTypeRef.getType()));
        List<String> arguments2 = FirAnnotationsIdeRendererKt.renderAndSortAnnotationArguments(annotation2, session2);
        if (!((Collection)arguments2).isEmpty()) {
            CollectionsKt.joinTo$default((Iterable)arguments2, (Appendable)$this$renderAnnotation_u24lambda_u240, (CharSequence)", ", (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)112, null);
        }
        String string3 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"StringBuilder().apply(builderAction).toString()");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<String> renderAndSortAnnotationArguments(FirAnnotation descriptor2, FirSession session2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = org.jetbrains.kotlin.analysis.api.fir.annotations.FirAnnotationUtilsKt.mapAnnotationParameters(descriptor2, session2).entrySet();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Map.Entry entry = (Map.Entry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Name name2 = (Name)entry.getKey();
            FirExpression value2 = (FirExpression)entry.getValue();
            collection.add(name2 + " = " + FirAnnotationsIdeRendererKt.renderConstant(value2, session2));
        }
        List argumentList2 = (List)destination$iv$iv;
        return CollectionsKt.sorted((Iterable)argumentList2);
    }

    private static final String renderConstant(FirExpression value2, FirSession useSiteSession) {
        FirConstExpression<?> evaluated;
        FirConstExpression<?> firConstExpression = evaluated = FirCompileTimeConstantEvaluator.INSTANCE.evaluate(value2, KtConstantEvaluationMode.CONSTANT_EXPRESSION_EVALUATION);
        KtAnnotationValue ktAnnotationValue = FirAnnotationValueConverter.INSTANCE.toConstantValue(firConstExpression != null ? (FirExpression)firConstExpression : value2, useSiteSession);
        if (ktAnnotationValue == null) {
            ktAnnotationValue = KtUnsupportedAnnotationValue.INSTANCE;
        }
        KtAnnotationValue constantValue = ktAnnotationValue;
        return KtAnnotationValueKt.renderAsSourceCode(constantValue);
    }
}

