/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.backend.Fir2IrScopeCache;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0006\u001a\u00020\u0007J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u0017J1\u0010\u0018\u001a\u0004\u0018\u0001H\u0019\"\u0004\b\u0000\u0010\u00192\u0019\u0010\u001a\u001a\u0015\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u0001H\u00190\u001b\u00a2\u0006\u0002\b\u001cH\u0082\b\u00a2\u0006\u0002\u0010\u001dJ\u0006\u0010\u001e\u001a\u00020\u0007J\u0016\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\tJ\u0016\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\rJ\u0016\u0010%\u001a\u00020\u00072\u0006\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\u0011J\u0016\u0010(\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u0015R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage;", "", "()V", "cacheStack", "", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrScopeCache;", "enterCallable", "", "getDelegatedProperty", "Lorg/jetbrains/kotlin/ir/declarations/IrLocalDelegatedProperty;", "property", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "getLocalFunction", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "localFunction", "Lorg/jetbrains/kotlin/fir/declarations/FirFunction;", "getParameter", "Lorg/jetbrains/kotlin/ir/declarations/IrValueParameter;", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getVariable", "Lorg/jetbrains/kotlin/ir/declarations/IrVariable;", "variable", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "last", "T", "getter", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "leaveCallable", "putDelegatedProperty", "firProperty", "irProperty", "putLocalFunction", "firFunction", "irFunction", "putParameter", "firParameter", "irParameter", "putVariable", "firVariable", "irVariable", "fir2ir"})
@SourceDebugExtension(value={"SMAP\nFir2IrLocalCallableStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,64:1\n42#1,2:65\n45#1:68\n42#1,2:69\n45#1:72\n42#1,2:73\n45#1:76\n1#2:67\n1#2:71\n1#2:75\n1#2:77\n*S KotlinDebug\n*F\n+ 1 Fir2IrLocalCallableStorage.kt\norg/jetbrains/kotlin/fir/backend/Fir2IrLocalCallableStorage\n*L\n33#1:65,2\n33#1:68\n36#1:69,2\n36#1:72\n39#1:73,2\n39#1:76\n33#1:67\n36#1:71\n39#1:75\n*E\n"})
public final class Fir2IrLocalCallableStorage {
    @NotNull
    private final List<Fir2IrScopeCache> cacheStack = new ArrayList();

    public final void enterCallable() {
        ((Collection)this.cacheStack).add(new Fir2IrScopeCache());
    }

    public final void leaveCallable() {
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).clear();
        this.cacheStack.remove(this.cacheStack.size() - 1);
    }

    @Nullable
    public final IrValueParameter getParameter(@NotNull FirValueParameter parameter2) {
        Intrinsics.checkNotNullParameter((Object)parameter2, (String)"parameter");
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            IrValueParameter local = cache2.getParameter(parameter2);
            if (local == null) continue;
            return local;
        }
        return null;
    }

    @Nullable
    public final IrVariable getVariable(@NotNull FirVariable variable2) {
        IrVariable irVariable2;
        block1: {
            Intrinsics.checkNotNullParameter((Object)variable2, (String)"variable");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getVariable_u24lambda_u240 = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrVariable irVariable3 = $this$getVariable_u24lambda_u240.getVariable(variable2);
                if (irVariable3 == null) continue;
                IrVariable it$iv = irVariable3;
                boolean bl2 = false;
                irVariable2 = it$iv;
                break block1;
            }
            irVariable2 = null;
        }
        return irVariable2;
    }

    @Nullable
    public final IrSimpleFunction getLocalFunction(@NotNull FirFunction localFunction) {
        IrSimpleFunction irSimpleFunction;
        block1: {
            Intrinsics.checkNotNullParameter((Object)localFunction, (String)"localFunction");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getLocalFunction_u24lambda_u241 = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrSimpleFunction irSimpleFunction2 = $this$getLocalFunction_u24lambda_u241.getLocalFunction(localFunction);
                if (irSimpleFunction2 == null) continue;
                IrSimpleFunction it$iv = irSimpleFunction2;
                boolean bl2 = false;
                irSimpleFunction = it$iv;
                break block1;
            }
            irSimpleFunction = null;
        }
        return irSimpleFunction;
    }

    @Nullable
    public final IrLocalDelegatedProperty getDelegatedProperty(@NotNull FirProperty property2) {
        IrLocalDelegatedProperty irLocalDelegatedProperty;
        block1: {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Fir2IrLocalCallableStorage this_$iv = this;
            boolean $i$f$last = false;
            Iterator iterator2 = CollectionsKt.asReversedMutable(this_$iv.cacheStack).iterator();
            while (iterator2.hasNext()) {
                Fir2IrScopeCache cache$iv;
                Fir2IrScopeCache $this$getDelegatedProperty_u24lambda_u242 = cache$iv = (Fir2IrScopeCache)iterator2.next();
                boolean bl = false;
                IrLocalDelegatedProperty irLocalDelegatedProperty2 = $this$getDelegatedProperty_u24lambda_u242.getDelegatedProperty(property2);
                if (irLocalDelegatedProperty2 == null) continue;
                IrLocalDelegatedProperty it$iv = irLocalDelegatedProperty2;
                boolean bl2 = false;
                irLocalDelegatedProperty = it$iv;
                break block1;
            }
            irLocalDelegatedProperty = null;
        }
        return irLocalDelegatedProperty;
    }

    private final <T> T last(Function1<? super Fir2IrScopeCache, ? extends T> getter2) {
        boolean $i$f$last = false;
        for (Fir2IrScopeCache cache2 : CollectionsKt.asReversedMutable(this.cacheStack)) {
            Object object = getter2.invoke((Object)cache2);
            if (object == null) continue;
            Object it = object;
            boolean bl = false;
            return (T)it;
        }
        return null;
    }

    public final void putParameter(@NotNull FirValueParameter firParameter, @NotNull IrValueParameter irParameter2) {
        Intrinsics.checkNotNullParameter((Object)firParameter, (String)"firParameter");
        Intrinsics.checkNotNullParameter((Object)irParameter2, (String)"irParameter");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putParameter(firParameter, irParameter2);
    }

    public final void putVariable(@NotNull FirVariable firVariable, @NotNull IrVariable irVariable2) {
        Intrinsics.checkNotNullParameter((Object)firVariable, (String)"firVariable");
        Intrinsics.checkNotNullParameter((Object)irVariable2, (String)"irVariable");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putVariable(firVariable, irVariable2);
    }

    public final void putLocalFunction(@NotNull FirFunction firFunction, @NotNull IrSimpleFunction irFunction2) {
        Intrinsics.checkNotNullParameter((Object)firFunction, (String)"firFunction");
        Intrinsics.checkNotNullParameter((Object)irFunction2, (String)"irFunction");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putLocalFunction(firFunction, irFunction2);
    }

    public final void putDelegatedProperty(@NotNull FirProperty firProperty, @NotNull IrLocalDelegatedProperty irProperty2) {
        Intrinsics.checkNotNullParameter((Object)firProperty, (String)"firProperty");
        Intrinsics.checkNotNullParameter((Object)irProperty2, (String)"irProperty");
        ((Fir2IrScopeCache)CollectionsKt.last(this.cacheStack)).putDelegatedProperty(firProperty, irProperty2);
    }
}

