/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.PrimitiveType;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.builtins.UnsignedTypes;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImpl;
import org.jetbrains.kotlin.ir.types.impl.IrSimpleTypeImplKt;
import org.jetbrains.kotlin.ir.util.DeepCopyIrTreeWithSymbols;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.DeepCopyTypeRemapper;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.PatchDeclarationParentsKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.util.SymbolRemapper;
import org.jetbrains.kotlin.ir.util.TypeRemapper;
import org.jetbrains.kotlin.ir.visitors.IrVisitorsKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bH\u0002\u001a\u001e\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000bH\u0002\u001a\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\u0006\u0010\b\u001a\u00020\t\u001a\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0010\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\t0\u0011*\u00020\t\u001a\f\u0010\u0015\u001a\u0004\u0018\u00010\u0016*\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0017\u001a\u001c\u0010\u001a\u001a\u00020\u0019*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u001f\u001a\u00020\u0019*\u00020\u001b2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0001H\u0002\u001a\n\u0010!\u001a\u00020\u0019*\u00020\u001b\u001a\n\u0010!\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010\"\u001a\u00020\u0019*\u00020\u001b\u001a\n\u0010\"\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010#\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010$\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010%\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010&\u001a\u00020\u0019*\u00020\u001b\u001a\n\u0010&\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010'\u001a\u00020\u0019*\u00020\u001b\u001a\n\u0010'\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010(\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010)\u001a\u00020\u0019*\u00020\u001b\u001a\n\u0010)\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010*\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010+\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010,\u001a\u00020\u0019*\u00020\u0017\u001a!\u0010-\u001a\u00020\u0019*\u00020\u00172\u0012\u0010.\u001a\u000e\u0012\u0004\u0012\u000200\u0012\u0004\u0012\u00020\u00190/H\u0082\b\u001a\n\u00101\u001a\u00020\u0019*\u00020\u0017\u001a\n\u00102\u001a\u00020\u0019*\u00020\u0017\u001a\n\u00103\u001a\u00020\u0019*\u00020\u0017\u001a&\u00104\u001a\u00020\u0017*\u00020\u00172\f\u00105\u001a\b\u0012\u0004\u0012\u0002060\u00132\f\u00107\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013\u001a\u001e\u00104\u001a\u00020\u0017*\u00020\u00172\u0012\u00108\u001a\u000e\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020\u001709\u001a\u0010\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00170\u0013*\u00020\u0017\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"kotlinCoroutinesPackageFqn", "Lorg/jetbrains/kotlin/name/FqName;", "kotlinPackageFqn", "getKotlinPackageFqn", "()Lorg/jetbrains/kotlin/name/FqName;", "kotlinReflectionPackageFqn", "collectAllSuperclasses", "", "irClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "set", "", "collectAllSupertypes", "irType", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "result", "getAllSubstitutedSupertypes", "", "getImmediateSupertypes", "", "getAllSuperclasses", "getPrimitiveArrayElementType", "Lorg/jetbrains/kotlin/builtins/PrimitiveType;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "isAnnotation", "", "isClassWithName", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "name", "", "packageFqName", "isClassWithNamePrefix", "prefix", "isFunction", "isFunctionMarker", "isFunctionOrKFunction", "isFunctionTypeOrSubtype", "isInterface", "isKFunction", "isKSuspendFunction", "isPrimitiveArray", "isSuspendFunction", "isSuspendFunctionOrKFunction", "isSuspendFunctionTypeOrSubtype", "isThrowable", "isTypeFromKotlinPackage", "namePredicate", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/name/Name;", "isTypeParameter", "isUnsigned", "isUnsignedArray", "substitute", "params", "Lorg/jetbrains/kotlin/ir/declarations/IrTypeParameter;", "arguments", "substitutionMap", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "superTypes", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIrTypeUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/util/IrTypeUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt\n+ 5 DeepCopyIrTreeWithSymbols.kt\norg/jetbrains/kotlin/ir/util/DeepCopyIrTreeWithSymbolsKt$deepCopyWithSymbols$1\n*L\n1#1,170:1\n73#1,6:171\n73#1,6:177\n73#1,6:183\n73#1,6:189\n1#2:195\n1549#3:196\n1620#3,3:197\n1549#3:200\n1620#3,2:201\n1622#3:217\n1549#3:218\n1620#3,3:219\n1549#3:222\n1620#3,3:223\n766#3:226\n857#3,2:227\n1549#3:229\n1620#3,3:230\n24#4,13:203\n26#5:216\n*S KotlinDebug\n*F\n+ 1 IrTypeUtils.kt\norg/jetbrains/kotlin/ir/util/IrTypeUtilsKt\n*L\n66#1:171,6\n68#1:177,6\n70#1:183,6\n81#1:189,6\n88#1:196\n88#1:197,3\n93#1:200\n93#1:201,2\n93#1:217\n102#1:218\n102#1:219,3\n123#1:222\n123#1:223,3\n128#1:226\n128#1:227,2\n129#1:229\n129#1:230,3\n93#1:203,13\n93#1:216\n*E\n"})
public final class IrTypeUtilsKt {
    @NotNull
    private static final FqName kotlinPackageFqn;
    @NotNull
    private static final FqName kotlinReflectionPackageFqn;
    @NotNull
    private static final FqName kotlinCoroutinesPackageFqn;

    @NotNull
    public static final FqName getKotlinPackageFqn() {
        return kotlinPackageFqn;
    }

    public static final boolean isFunctionMarker(@NotNull IrType $this$isFunctionMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionMarker, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isFunctionMarker);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithName(irClassifierSymbol, "Function", kotlinPackageFqn) : false;
    }

    public static final boolean isFunction(@NotNull IrType $this$isFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "Function", kotlinPackageFqn) : false;
    }

    public static final boolean isKFunction(@NotNull IrType $this$isKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KFunction", kotlinReflectionPackageFqn) : false;
    }

    public static final boolean isSuspendFunction(@NotNull IrType $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isSuspendFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "SuspendFunction", kotlinCoroutinesPackageFqn) : false;
    }

    public static final boolean isKSuspendFunction(@NotNull IrType $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKSuspendFunction, (String)"<this>");
        IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull($this$isKSuspendFunction);
        return irClassifierSymbol != null ? IrTypeUtilsKt.isClassWithNamePrefix(irClassifierSymbol, "KSuspendFunction", kotlinReflectionPackageFqn) : false;
    }

    public static final boolean isFunctionMarker(@NotNull IrClassifierSymbol $this$isFunctionMarker) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionMarker, (String)"<this>");
        return IrTypeUtilsKt.isClassWithName($this$isFunctionMarker, "Function", kotlinPackageFqn);
    }

    public static final boolean isFunction(@NotNull IrClassifierSymbol $this$isFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isFunction, "Function", kotlinPackageFqn);
    }

    public static final boolean isKFunction(@NotNull IrClassifierSymbol $this$isKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKFunction, "KFunction", kotlinReflectionPackageFqn);
    }

    public static final boolean isSuspendFunction(@NotNull IrClassifierSymbol $this$isSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isSuspendFunction, "SuspendFunction", kotlinCoroutinesPackageFqn);
    }

    public static final boolean isKSuspendFunction(@NotNull IrClassifierSymbol $this$isKSuspendFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isKSuspendFunction, (String)"<this>");
        return IrTypeUtilsKt.isClassWithNamePrefix($this$isKSuspendFunction, "KSuspendFunction", kotlinReflectionPackageFqn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClassWithName(IrClassifierSymbol $this$isClassWithName, String name2, FqName packageFqName) {
        IrSymbolOwner irSymbolOwner = $this$isClassWithName.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        IrDeclarationWithName declaration = (IrDeclarationWithName)irSymbolOwner;
        if (!Intrinsics.areEqual((Object)name2, (Object)declaration.getName().asString())) return false;
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
        if (!Intrinsics.areEqual((Object)(irPackageFragment != null ? irPackageFragment.getFqName() : null), (Object)packageFqName)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean isClassWithNamePrefix(IrClassifierSymbol $this$isClassWithNamePrefix, String prefix, FqName packageFqName) {
        IrSymbolOwner irSymbolOwner = $this$isClassWithNamePrefix.getOwner();
        Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName");
        IrDeclarationWithName declaration = (IrDeclarationWithName)irSymbolOwner;
        String string2 = declaration.getName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"declaration.name.asString()");
        if (!StringsKt.startsWith$default((String)string2, (String)prefix, (boolean)false, (int)2, null)) return false;
        IrDeclarationParent irDeclarationParent = declaration.getParent();
        IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
        if (!Intrinsics.areEqual((Object)(irPackageFragment != null ? irPackageFragment.getFqName() : null), (Object)packageFqName)) return false;
        return true;
    }

    @NotNull
    public static final List<IrType> superTypes(@NotNull IrType $this$superTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$superTypes, (String)"<this>");
        Object object = IrTypesKt.getClassifierOrNull($this$superTypes);
        if (object == null || (object = org.jetbrains.kotlin.ir.types.IrTypeUtilsKt.superTypes((IrClassifierSymbol)object)) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    public static final boolean isFunctionTypeOrSubtype(@NotNull IrType $this$isFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionTypeOrSubtype, (String)"<this>");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$this$isFunctionTypeOrSubtype), IrTypeUtilsKt::superTypes, isFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(listOf(this), IrTy\u2026ypes, IrType::isFunction)");
        return bl;
    }

    public static final boolean isSuspendFunctionTypeOrSubtype(@NotNull IrType $this$isSuspendFunctionTypeOrSubtype) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionTypeOrSubtype, (String)"<this>");
        Boolean bl = DFS.ifAny(CollectionsKt.listOf((Object)$this$isSuspendFunctionTypeOrSubtype), IrTypeUtilsKt::superTypes, isSuspendFunctionTypeOrSubtype.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"ifAny(listOf(this), IrTy\u2026rType::isSuspendFunction)");
        return bl;
    }

    public static final boolean isTypeParameter(@NotNull IrType $this$isTypeParameter) {
        Intrinsics.checkNotNullParameter((Object)$this$isTypeParameter, (String)"<this>");
        return IrTypesKt.getClassifierOrNull($this$isTypeParameter) instanceof IrTypeParameterSymbol;
    }

    public static final boolean isInterface(@NotNull IrType $this$isInterface) {
        Intrinsics.checkNotNullParameter((Object)$this$isInterface, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isInterface);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).getKind() : null) == ClassKind.INTERFACE;
    }

    public static final boolean isAnnotation(@NotNull IrType $this$isAnnotation) {
        Intrinsics.checkNotNullParameter((Object)$this$isAnnotation, (String)"<this>");
        Object object = IrTypesKt.getClassOrNull($this$isAnnotation);
        return (object != null && (object = (IrClass)object.getOwner()) != null ? ((IrClass)object).getKind() : null) == ClassKind.ANNOTATION_CLASS;
    }

    public static final boolean isFunctionOrKFunction(@NotNull IrType $this$isFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isFunctionOrKFunction, (String)"<this>");
        return IrTypeUtilsKt.isFunction($this$isFunctionOrKFunction) || IrTypeUtilsKt.isKFunction($this$isFunctionOrKFunction);
    }

    public static final boolean isSuspendFunctionOrKFunction(@NotNull IrType $this$isSuspendFunctionOrKFunction) {
        Intrinsics.checkNotNullParameter((Object)$this$isSuspendFunctionOrKFunction, (String)"<this>");
        return IrTypeUtilsKt.isSuspendFunction($this$isSuspendFunctionOrKFunction) || IrTypeUtilsKt.isKSuspendFunction($this$isSuspendFunctionOrKFunction);
    }

    public static final boolean isThrowable(@NotNull IrType $this$isThrowable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isThrowable, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isThrowable;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)name2.asString(), (Object)"Throwable")) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsigned(@NotNull IrType $this$isUnsigned) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isUnsigned, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsigned;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedType(name2)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final boolean isUnsignedArray(@NotNull IrType $this$isUnsignedArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isUnsignedArray, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isUnsignedArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name name2 = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!UnsignedTypes.INSTANCE.isShortNameOfUnsignedArray(name2)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean isTypeFromKotlinPackage(IrType $this$isTypeFromKotlinPackage, Function1<? super Name, Boolean> namePredicate) {
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                return false;
            }
            IrClassSymbol classClassifier = irClassSymbol;
            if (!((Boolean)namePredicate.invoke((Object)((IrClass)classClassifier.getOwner()).getName())).booleanValue()) {
                return false;
            }
            IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier.getOwner()).getParent();
            IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
            if (irPackageFragment == null) {
                return false;
            }
            IrPackageFragment parent2 = irPackageFragment;
            return Intrinsics.areEqual((Object)parent2.getFqName(), (Object)kotlinPackageFqn);
        }
        return false;
    }

    public static final boolean isPrimitiveArray(@NotNull IrType $this$isPrimitiveArray) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isPrimitiveArray, (String)"<this>");
        IrType $this$isTypeFromKotlinPackage$iv = $this$isPrimitiveArray;
        boolean $i$f$isTypeFromKotlinPackage = false;
        if ($this$isTypeFromKotlinPackage$iv instanceof IrSimpleType) {
            IrClassifierSymbol irClassifierSymbol = ((IrSimpleType)$this$isTypeFromKotlinPackage$iv).getClassifier();
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null) {
                bl = false;
            } else {
                IrClassSymbol classClassifier$iv = irClassSymbol;
                Name it = ((IrClass)classClassifier$iv.getOwner()).getName();
                boolean bl2 = false;
                if (!StandardNames.FqNames.primitiveArrayTypeShortNames.contains(it)) {
                    bl = false;
                } else {
                    IrDeclarationParent irDeclarationParent = ((IrClass)classClassifier$iv.getOwner()).getParent();
                    IrPackageFragment irPackageFragment = irDeclarationParent instanceof IrPackageFragment ? (IrPackageFragment)irDeclarationParent : null;
                    if (irPackageFragment == null) {
                        bl = false;
                    } else {
                        IrPackageFragment parent$iv = irPackageFragment;
                        bl = Intrinsics.areEqual((Object)parent$iv.getFqName(), (Object)kotlinPackageFqn);
                    }
                }
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public static final PrimitiveType getPrimitiveArrayElementType(@NotNull IrType $this$getPrimitiveArrayElementType) {
        PrimitiveType primitiveType;
        Intrinsics.checkNotNullParameter((Object)$this$getPrimitiveArrayElementType, (String)"<this>");
        IrSimpleType irSimpleType = $this$getPrimitiveArrayElementType instanceof IrSimpleType ? (IrSimpleType)$this$getPrimitiveArrayElementType : null;
        if (irSimpleType != null) {
            IrSimpleType it = irSimpleType;
            boolean bl = false;
            IrSymbolOwner irSymbolOwner = it.getClassifier().getOwner();
            Object object = irSymbolOwner instanceof IrClass ? (IrClass)irSymbolOwner : null;
            if (object != null && (object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)object)) != null && (object = ((FqName)object).toUnsafe()) != null) {
                Object fqn = object;
                boolean bl2 = false;
                primitiveType = StandardNames.FqNames.arrayClassFqNameToPrimitiveType.get(fqn);
            } else {
                primitiveType = null;
            }
        } else {
            primitiveType = null;
        }
        return primitiveType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull List<? extends IrTypeParameter> params, @NotNull List<? extends IrType> arguments2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)$this$substitute, (String)"<this>");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(arguments2, (String)"arguments");
        Iterable iterable = params;
        IrType irType = $this$substitute;
        boolean $i$f$map = false;
        void var5_6 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter2 = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return IrTypeUtilsKt.substitute(irType, MapsKt.toMap((Iterable)CollectionsKt.zip((Iterable)((List)destination$iv$iv), (Iterable)arguments2)));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IrType substitute(@NotNull IrType $this$substitute, @NotNull Map<IrTypeParameterSymbol, ? extends IrType> substitutionMap) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)$this$substitute, (String)"<this>");
        Intrinsics.checkNotNullParameter(substitutionMap, (String)"substitutionMap");
        if (!($this$substitute instanceof IrSimpleType) || substitutionMap.isEmpty()) {
            return $this$substitute;
        }
        Object $this$map$iv = $this$substitute.getAnnotations();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void p1;
            DeepCopyTypeRemapper typeRemapper$iv$iv;
            void $this$deepCopyWithSymbols$iv$iv;
            void it;
            IrConstructorCall irConstructorCall = (IrConstructorCall)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl3 = false;
            IrElement $this$deepCopyWithSymbols_u24default$iv = (IrElement)it;
            IrDeclarationParent initialParent$iv = null;
            boolean $i$f$deepCopyWithSymbols = false;
            IrElement irElement = $this$deepCopyWithSymbols_u24default$iv;
            DeepCopySymbolRemapper symbolRemapper$iv$iv = new DeepCopySymbolRemapper(null, 1, null);
            boolean $i$f$deepCopyWithSymbols2 = false;
            IrVisitorsKt.acceptVoid((IrElement)$this$deepCopyWithSymbols$iv$iv, symbolRemapper$iv$iv);
            TypeRemapper typeRemapper = typeRemapper$iv$iv = new DeepCopyTypeRemapper(symbolRemapper$iv$iv);
            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper$iv$iv;
            void var21_27 = $this$deepCopyWithSymbols$iv$iv;
            boolean bl2 = false;
            typeRemapper = typeRemapper;
            SymbolRemapper p0 = deepCopySymbolRemapper;
            IrElement irElement2 = PatchDeclarationParentsKt.patchDeclarationParents(var21_27.transform(new DeepCopyIrTreeWithSymbols(p0, (TypeRemapper)p1), null), initialParent$iv);
            if (irElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.ir.expressions.IrConstructorCall");
            }
            collection.add((IrConstructorCall)((IrElement)((IrConstructorCall)irElement2)));
        }
        List newAnnotations = (List)destination$iv$iv;
        $this$map$iv = substitutionMap.get(((IrSimpleType)$this$substitute).getClassifier());
        if ($this$map$iv != null) {
            Object substitutedType = $this$map$iv;
            boolean bl = false;
            return IrTypesKt.addAnnotations(IrTypesKt.mergeNullability((IrType)substitutedType, $this$substitute), newAnnotations);
        }
        Iterable $this$map$iv2 = ((IrSimpleType)$this$substitute).getArguments();
        boolean $i$f$map2 = false;
        Iterable bl = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeArgument bl3 = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl4 = false;
            collection.add(it instanceof IrTypeProjection ? (IrTypeArgument)IrSimpleTypeImplKt.makeTypeProjection(IrTypeUtilsKt.substitute(((IrTypeProjection)it).getType(), substitutionMap), ((IrTypeProjection)it).getVariance()) : it);
        }
        List newArguments2 = (List)destination$iv$iv2;
        return new IrSimpleTypeImpl(((IrSimpleType)$this$substitute).getClassifier(), ((IrSimpleType)$this$substitute).getNullability(), newArguments2, newAnnotations, null, 16, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<IrSimpleType> getImmediateSupertypes(IrSimpleType irType) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        IrType it;
        Collection collection;
        void $this$mapTo$iv$iv;
        IrClass irClass2 = IrTypesKt.getClass(irType);
        if (irClass2 == null) {
            throw new AssertionError((Object)("Not a class type: " + RenderIrElementKt.render(irType)));
        }
        IrClass irClass3 = irClass2;
        List<IrType> originalSupertypes = irClass3.getSuperTypes();
        Iterable $this$map$iv = irType.getArguments();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrTypeArgument irTypeArgument = (IrTypeArgument)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrType irType2 = IrTypesKt.getTypeOrNull((IrTypeArgument)((Object)it));
            if (irType2 == null) {
                throw new AssertionError((Object)("*-projection in supertype arguments: " + RenderIrElementKt.render(irType)));
            }
            collection.add(irType2);
        }
        List arguments2 = (List)destination$iv$iv;
        $this$map$iv = originalSupertypes;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (IrType)element$iv$iv;
            boolean bl = false;
            if (!(IrTypesKt.getClassOrNull(it) != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void superType2;
            it = (IrType)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            IrType irType3 = IrTypeUtilsKt.substitute((IrType)superType2, irClass3.getTypeParameters(), arguments2);
            Intrinsics.checkNotNull((Object)irType3, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.types.IrSimpleType");
            collection.add((IrSimpleType)irType3);
        }
        return (List)destination$iv$iv;
    }

    private static final void collectAllSupertypes(IrSimpleType irType, Set<IrSimpleType> result2) {
        List<IrSimpleType> immediateSupertypes = IrTypeUtilsKt.getImmediateSupertypes(irType);
        result2.addAll((Collection<IrSimpleType>)immediateSupertypes);
        for (IrSimpleType supertype2 : immediateSupertypes) {
            IrTypeUtilsKt.collectAllSupertypes(supertype2, result2);
        }
    }

    @NotNull
    public static final Set<IrSimpleType> getAllSubstitutedSupertypes(@NotNull IrClass irClass2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        HashSet result2 = new HashSet();
        IrTypeUtilsKt.collectAllSupertypes(IrUtilsKt.getDefaultType(irClass2), result2);
        return result2;
    }

    private static final void collectAllSuperclasses(IrClass irClass2, Set<IrClass> set) {
        for (IrType superType2 : irClass2.getSuperTypes()) {
            IrClassSymbol classifier;
            IrClass superClass;
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull(superType2);
            IrClassSymbol irClassSymbol = irClassifierSymbol instanceof IrClassSymbol ? (IrClassSymbol)irClassifierSymbol : null;
            if (irClassSymbol == null || !set.add(superClass = (IrClass)(classifier = irClassSymbol).getOwner())) continue;
            IrTypeUtilsKt.collectAllSuperclasses(superClass, set);
        }
    }

    @NotNull
    public static final Set<IrClass> getAllSuperclasses(@NotNull IrClass $this$getAllSuperclasses) {
        Intrinsics.checkNotNullParameter((Object)$this$getAllSuperclasses, (String)"<this>");
        HashSet result2 = new HashSet();
        IrTypeUtilsKt.collectAllSuperclasses($this$getAllSuperclasses, result2);
        return result2;
    }

    static {
        FqName fqName2 = FqName.fromSegments(CollectionsKt.listOf((Object)"kotlin"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"fromSegments(listOf(\"kotlin\"))");
        kotlinPackageFqn = fqName2;
        FqName fqName3 = kotlinPackageFqn.child(Name.identifier("reflect"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"kotlinPackageFqn.child(Name.identifier(\"reflect\"))");
        kotlinReflectionPackageFqn = fqName3;
        FqName fqName4 = kotlinPackageFqn.child(Name.identifier("coroutines"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName4, (String)"kotlinPackageFqn.child(N\u2026identifier(\"coroutines\"))");
        kotlinCoroutinesPackageFqn = fqName4;
    }
}

