/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.HierarchicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.LexicalScopeKind;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000^\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u001a,\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0010\u001a\u00020\u00112\n\u0010\u0012\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0014\u001a\u00020\u0015\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0017\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u001a\u001a\n\u0010\u0018\u001a\u00020\u0019*\u00020\u0004\u001a\n\u0010\u001b\u001a\u00020\u0019*\u00020\u001c\u001a\u0014\u0010\u001d\u001a\u00020\u0019*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0017H\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006 "}, d2={"ALLOWED_SCOPE_KINDS", "", "Lorg/jetbrains/kotlin/resolve/scopes/LexicalScopeKind;", "COROUTINE_CONTEXT_FQ_NAME", "Lorg/jetbrains/kotlin/name/FqName;", "getCOROUTINE_CONTEXT_FQ_NAME", "()Lorg/jetbrains/kotlin/name/FqName;", "checkCoroutinesFeature", "", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "reportOn", "Lcom/intellij/psi/PsiElement;", "checkRestrictsSuspension", "enclosingSuspendCallableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "findEnclosingSuspendFunction", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "isBuiltInCoroutineContext", "", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "isRestrictsSuspensionReceiver", "Lorg/jetbrains/kotlin/types/KotlinType;", "isScopeForDefaultParameterValuesOf", "Lorg/jetbrains/kotlin/resolve/scopes/HierarchicalScope;", "enclosingSuspendFunction", "frontend"})
@SourceDebugExtension(value={"SMAP\ncoroutineCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineCallCheckerKt\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,202:1\n179#2,2:203\n1747#3,3:205\n*S KotlinDebug\n*F\n+ 1 coroutineCallChecker.kt\norg/jetbrains/kotlin/resolve/calls/checkers/CoroutineCallCheckerKt\n*L\n50#1:203,2\n141#1:205,3\n*E\n"})
public final class CoroutineCallCheckerKt {
    @NotNull
    private static final FqName COROUTINE_CONTEXT_FQ_NAME;
    @NotNull
    private static final Set<LexicalScopeKind> ALLOWED_SCOPE_KINDS;

    @NotNull
    public static final FqName getCOROUTINE_CONTEXT_FQ_NAME() {
        return COROUTINE_CONTEXT_FQ_NAME;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FqName $this$isBuiltInCoroutineContext) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltInCoroutineContext, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isBuiltInCoroutineContext, (Object)StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("coroutineContext")));
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull FunctionDescriptor $this$isBuiltInCoroutineContext) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltInCoroutineContext, (String)"<this>");
        Object object = $this$isBuiltInCoroutineContext instanceof PropertyGetterDescriptor ? (PropertyGetterDescriptor)$this$isBuiltInCoroutineContext : null;
        return object != null && (object = object.getCorrespondingProperty()) != null && (object = DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)object)) != null ? CoroutineCallCheckerKt.isBuiltInCoroutineContext((FqName)object) : false;
    }

    public static final boolean isBuiltInCoroutineContext(@NotNull PropertyDescriptor $this$isBuiltInCoroutineContext) {
        Intrinsics.checkNotNullParameter((Object)$this$isBuiltInCoroutineContext, (String)"<this>");
        return CoroutineCallCheckerKt.isBuiltInCoroutineContext(DescriptorUtilsKt.getFqNameSafe($this$isBuiltInCoroutineContext));
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final FunctionDescriptor findEnclosingSuspendFunction(@NotNull CallCheckerContext context) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            $this$firstOrNull$iv = ScopeUtilsKt.getParentsWithSelf(context.getScope());
            $i$f$firstOrNull = false;
            for (E element$iv : $this$firstOrNull$iv) {
                it = (HierarchicalScope)element$iv;
                $i$a$-firstOrNull-CoroutineCallCheckerKt$findEnclosingSuspendFunction$scope$1 = false;
                if (!(it instanceof LexicalScope) || !CoroutineCallCheckerKt.ALLOWED_SCOPE_KINDS.contains((Object)((LexicalScope)it).getKind())) ** GOTO lbl-1000
                var8_7 = ((LexicalScope)it).getOwnerDescriptor();
                v0 = var8_7 instanceof FunctionDescriptor != false ? (FunctionDescriptor)var8_7 : null;
                v1 = v0 != null ? v0.isSuspend() : false;
                if (v1) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                if (!v2) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        v4 = scope = (LexicalScope)v3;
        return (FunctionDescriptor)(v4 != null ? v4.getOwnerDescriptor() : null);
    }

    private static final boolean isScopeForDefaultParameterValuesOf(HierarchicalScope $this$isScopeForDefaultParameterValuesOf, FunctionDescriptor enclosingSuspendFunction) {
        return $this$isScopeForDefaultParameterValuesOf instanceof LexicalScope && ((LexicalScope)$this$isScopeForDefaultParameterValuesOf).getKind() == LexicalScopeKind.DEFAULT_VALUE && Intrinsics.areEqual((Object)((LexicalScope)$this$isScopeForDefaultParameterValuesOf).getOwnerDescriptor(), (Object)enclosingSuspendFunction);
    }

    public static final void checkCoroutinesFeature(@NotNull LanguageVersionSettings languageVersionSettings2, @NotNull DiagnosticSink diagnosticHolder, @NotNull PsiElement reportOn) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings2, (String)"languageVersionSettings");
        Intrinsics.checkNotNullParameter((Object)diagnosticHolder, (String)"diagnosticHolder");
        Intrinsics.checkNotNullParameter((Object)reportOn, (String)"reportOn");
        if (languageVersionSettings2.supportsFeature(LanguageFeature.ReleaseCoroutines)) {
            if (languageVersionSettings2.getApiVersion().compareTo(ApiVersion.KOTLIN_1_3) < 0) {
                diagnosticHolder.report(Errors.UNSUPPORTED.on(reportOn, "cannot use release coroutines with api version less than 1.3"));
            }
            return;
        }
    }

    public static final boolean isRestrictsSuspensionReceiver(@NotNull KotlinType $this$isRestrictsSuspensionReceiver) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)$this$isRestrictsSuspensionReceiver, (String)"<this>");
            Iterable $this$any$iv = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)$this$isRestrictsSuspensionReceiver), (Iterable)TypeUtilsKt.supertypes($this$isRestrictsSuspensionReceiver));
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    boolean bl2;
                    KotlinType it = (KotlinType)element$iv;
                    boolean bl3 = false;
                    Object object = it.getConstructor().getDeclarationDescriptor();
                    if (object != null && (object = object.getAnnotations()) != null) {
                        FqName fqName2 = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("RestrictsSuspension"));
                        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"COROUTINES_PACKAGE_FQ_NA\u2026r(\"RestrictsSuspension\"))");
                        bl2 = object.hasAnnotation(fqName2);
                    } else {
                        bl2 = false;
                    }
                    if (!bl2) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        ReceiverParameterDescriptor receiverParameterDescriptor = enclosingSuspendCallableDescriptor.getExtensionReceiverParameter();
        ReceiverValue enclosingSuspendExtensionReceiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
        ReceiverParameterDescriptor receiverParameterDescriptor2 = enclosingSuspendCallableDescriptor.getDispatchReceiverParameter();
        ReceiverValue enclosingSuspendDispatchReceiverValue = receiverParameterDescriptor2 != null ? receiverParameterDescriptor2.getValue() : null;
        ReceiverValue[] receiverValueArray = new ReceiverValue[]{resolvedCall2.getDispatchReceiver(), resolvedCall2.getExtensionReceiver()};
        List receivers = CollectionsKt.listOfNotNull((Object[])receiverValueArray);
        for (ReceiverValue receiverValue : receivers) {
            Intrinsics.checkNotNullExpressionValue((Object)receiverValue, (String)"receiverValue");
            if (!CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver(receiverValue)) continue;
            ReceiverValue receiverValue2 = enclosingSuspendExtensionReceiverValue;
            if (receiverValue2 != null ? CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(receiverValue2, context, receiverValue) : false) continue;
            ReceiverValue receiverValue3 = enclosingSuspendDispatchReceiverValue;
            if (receiverValue3 != null ? CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(receiverValue3, context, receiverValue) : false) continue;
            CoroutineCallCheckerKt.checkRestrictsSuspension$reportError(context, reportOn);
            return;
        }
        ReceiverValue receiverValue = enclosingSuspendExtensionReceiverValue;
        if (!(receiverValue != null ? CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver(receiverValue) : false)) {
            return;
        }
        if (CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(enclosingSuspendExtensionReceiverValue, context, resolvedCall2.getDispatchReceiver())) {
            return;
        }
        if (CoroutineCallCheckerKt.checkRestrictsSuspension$sameInstance(enclosingSuspendExtensionReceiverValue, context, resolvedCall2.getExtensionReceiver())) {
            ReceiverParameterDescriptor receiverParameterDescriptor3 = resolvedCall2.getCandidateDescriptor().getExtensionReceiverParameter();
            Intrinsics.checkNotNull((Object)receiverParameterDescriptor3);
            ReceiverValue receiverValue4 = receiverParameterDescriptor3.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)receiverValue4, (String)"resolvedCall.candidateDe\u2026ReceiverParameter!!.value");
            if (CoroutineCallCheckerKt.checkRestrictsSuspension$isRestrictsSuspensionReceiver(receiverValue4)) {
                return;
            }
        }
        CoroutineCallCheckerKt.checkRestrictsSuspension$reportError(context, reportOn);
    }

    private static final boolean checkRestrictsSuspension$isRestrictsSuspensionReceiver(ReceiverValue $this$checkRestrictsSuspension_u24isRestrictsSuspensionReceiver) {
        KotlinType kotlinType = $this$checkRestrictsSuspension_u24isRestrictsSuspensionReceiver.getType();
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"type");
        return CoroutineCallCheckerKt.isRestrictsSuspensionReceiver(kotlinType);
    }

    private static final boolean checkRestrictsSuspension$sameInstance(ReceiverValue $this$checkRestrictsSuspension_u24sameInstance, CallCheckerContext $context, ReceiverValue other) {
        ReceiverValue receiverValue;
        DeclarationDescriptor referenceTarget;
        DeclarationDescriptor declarationDescriptor;
        KtReferenceExpression referenceExpression2;
        if (other == null) {
            return false;
        }
        if ($this$checkRestrictsSuspension_u24sameInstance.getOriginal() == other.getOriginal()) {
            return true;
        }
        ExpressionReceiver expressionReceiver = other instanceof ExpressionReceiver ? (ExpressionReceiver)other : null;
        KtExpression ktExpression = expressionReceiver != null ? expressionReceiver.getExpression() : null;
        KtThisExpression ktThisExpression = ktExpression instanceof KtThisExpression ? (KtThisExpression)ktExpression : null;
        KtReferenceExpression ktReferenceExpression = referenceExpression2 = ktThisExpression != null ? ktThisExpression.getInstanceReference() : null;
        if (ktReferenceExpression != null) {
            KtReferenceExpression it = ktReferenceExpression;
            boolean bl = false;
            declarationDescriptor = (DeclarationDescriptor)$context.getTrace().get(BindingContext.REFERENCE_TARGET, referenceExpression2);
        } else {
            declarationDescriptor = null;
        }
        DeclarationDescriptor declarationDescriptor2 = referenceTarget = declarationDescriptor;
        if (declarationDescriptor2 instanceof CallableDescriptor) {
            ReceiverParameterDescriptor receiverParameterDescriptor = ((CallableDescriptor)referenceTarget).getExtensionReceiverParameter();
            receiverValue = receiverParameterDescriptor != null ? receiverParameterDescriptor.getValue() : null;
        } else {
            receiverValue = declarationDescriptor2 instanceof ClassDescriptor ? ((ClassDescriptor)referenceTarget).getThisAsReceiverParameter().getValue() : null;
        }
        ReceiverValue referenceReceiverValue = receiverValue;
        return $this$checkRestrictsSuspension_u24sameInstance == referenceReceiverValue;
    }

    private static final void checkRestrictsSuspension$reportError(CallCheckerContext $context, PsiElement $reportOn) {
        $context.getTrace().report(Errors.ILLEGAL_RESTRICTED_SUSPENDING_FUNCTION_CALL.on($reportOn));
    }

    public static final /* synthetic */ void access$checkRestrictsSuspension(CallableDescriptor enclosingSuspendCallableDescriptor, ResolvedCall resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        CoroutineCallCheckerKt.checkRestrictsSuspension(enclosingSuspendCallableDescriptor, resolvedCall2, reportOn, context);
    }

    public static final /* synthetic */ boolean access$isScopeForDefaultParameterValuesOf(HierarchicalScope $receiver, FunctionDescriptor enclosingSuspendFunction) {
        return CoroutineCallCheckerKt.isScopeForDefaultParameterValuesOf($receiver, enclosingSuspendFunction);
    }

    static {
        FqName fqName2 = StandardNames.COROUTINES_PACKAGE_FQ_NAME.child(Name.identifier("coroutineContext"));
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"COROUTINES_PACKAGE_FQ_NA\u2026fier(\"coroutineContext\"))");
        COROUTINE_CONTEXT_FQ_NAME = fqName2;
        LexicalScopeKind[] lexicalScopeKindArray = new LexicalScopeKind[]{LexicalScopeKind.FUNCTION_INNER_SCOPE, LexicalScopeKind.FUNCTION_HEADER_FOR_DESTRUCTURING};
        ALLOWED_SCOPE_KINDS = SetsKt.setOf((Object[])lexicalScopeKindArray);
    }
}

