/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.fir.components;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KDeclarationContainer;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.components.ShortenOption;
import org.jetbrains.kotlin.analysis.api.fir.components.AvailableSymbol;
import org.jetbrains.kotlin.analysis.api.fir.components.ElementToShorten;
import org.jetbrains.kotlin.analysis.api.fir.components.ElementsToShortenCollector;
import org.jetbrains.kotlin.analysis.api.fir.components.FirShorteningContext;
import org.jetbrains.kotlin.analysis.api.fir.components.ImportKind;
import org.jetbrains.kotlin.analysis.api.fir.components.KtFirReferenceShortenerKt;
import org.jetbrains.kotlin.analysis.api.fir.components.ShortenQualifier;
import org.jetbrains.kotlin.analysis.api.fir.components.ShortenType;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.LLFirResolveSession;
import org.jetbrains.kotlin.analysis.low.level.api.fir.element.builder.FirTowerContextProvider;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.expressions.FirErrorResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.impl.FirNoReceiverExpression;
import org.jetbrains.kotlin.fir.references.FirErrorNamedReference;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeAmbiguityError;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnmatchedTypeArgumentsError;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirVisitorVoid;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.utils.CollectionsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0016\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000b0\t\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0002J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0002J\u0091\u0001\u00108\u001a\u0004\u0018\u000103\"\u0004\b\u0000\u001092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020<0;2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\"0'2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002H90'2>\u0010?\u001a:\u0012\u0004\u0012\u0002H9\u0012\u0015\u0012\u0013\u0018\u00010\u0013\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(C\u0012\u0013\u0012\u001105\u00a2\u0006\f\bA\u0012\b\bB\u0012\u0004\b\b(D\u0012\u0004\u0012\u0002030@2\u0014\u0010E\u001a\u0010\u0012\u0004\u0012\u0002H9\u0012\u0006\u0012\u0004\u0018\u0001030\tH\u0082\bJ\u0012\u0010F\u001a\u0004\u0018\u00010G2\u0006\u0010H\u001a\u00020\u0019H\u0002J\u0012\u0010F\u001a\u0004\u0018\u00010I2\u0006\u0010J\u001a\u00020\u001cH\u0002J\u001a\u0010K\u001a\u0004\u0018\u0001032\u0006\u0010L\u001a\u00020\"2\u0006\u0010M\u001a\u00020\u0019H\u0002J\u001a\u0010N\u001a\u0004\u0018\u0001032\u0006\u0010O\u001a\u00020\"2\u0006\u0010P\u001a\u00020\u001cH\u0002J\u0016\u0010Q\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010R\u001a\u00020SH\u0002J\u0016\u0010T\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0006\u0010R\u001a\u00020UH\u0002JT\u0010V\u001a\u0002012\n\u0010W\u001a\u0006\u0012\u0002\b\u00030\r2\u0006\u0010X\u001a\u00020\u00192\u0006\u0010Y\u001a\u00020Z2.\u0010[\u001a*\u0012\n\u0012\b\u0012\u0004\u0012\u00020<0;\u0012\u0004\u0012\u00020]\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0^0;0\\H\u0002J\u0010\u0010_\u001a\u0002012\u0006\u00106\u001a\u000207H\u0002J\u0010\u0010`\u001a\u0002012\u0006\u0010a\u001a\u00020bH\u0002J\u0010\u0010c\u001a\u0002012\u0006\u0010d\u001a\u00020eH\u0002J\u0010\u0010f\u001a\u0002012\u0006\u0010g\u001a\u00020hH\u0002J\u0010\u0010i\u001a\u0002012\u0006\u00102\u001a\u00020jH\u0016J\u0010\u0010k\u001a\u0002012\u0006\u0010l\u001a\u00020mH\u0016J\u0010\u0010n\u001a\u0002012\u0006\u0010o\u001a\u00020pH\u0016J\u0010\u0010q\u001a\u0002012\u0006\u00106\u001a\u000207H\u0016J\u0010\u0010r\u001a\u0002012\u0006\u0010s\u001a\u00020 H\u0016J\u0010\u0010t\u001a\u0002012\u0006\u0010a\u001a\u00020bH\u0016J\u0010\u0010u\u001a\u0002012\u0006\u0010d\u001a\u00020eH\u0016J\u0010\u0010v\u001a\u0002012\u0006\u0010g\u001a\u00020hH\u0016J\u0010\u0010w\u001a\u0002012\u0006\u0010x\u001a\u00020yH\u0016R\u001e\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0015R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010!\u001a\u0004\u0018\u00010\"*\u00020#8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\"0'*\u00020\"8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u001e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00190'*\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,R\u001e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0'*\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010/\u00a8\u0006z"}, d2={"Lorg/jetbrains/kotlin/analysis/api/fir/components/ElementsToShortenCollector;", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitorVoid;", "shorteningContext", "Lorg/jetbrains/kotlin/analysis/api/fir/components/FirShorteningContext;", "towerContextProvider", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/element/builder/FirTowerContextProvider;", "selection", "Lcom/intellij/openapi/util/TextRange;", "classShortenOption", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lorg/jetbrains/kotlin/analysis/api/components/ShortenOption;", "callableShortenOption", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "firResolveSession", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;", "(Lorg/jetbrains/kotlin/analysis/api/fir/components/FirShorteningContext;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/element/builder/FirTowerContextProvider;Lcom/intellij/openapi/util/TextRange;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lorg/jetbrains/kotlin/analysis/low/level/api/fir/api/LLFirResolveSession;)V", "namesToImport", "", "Lorg/jetbrains/kotlin/name/FqName;", "getNamesToImport", "()Ljava/util/List;", "namesToImportWithStar", "getNamesToImportWithStar", "qualifiersToShorten", "Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;", "getQualifiersToShorten", "typesToShorten", "Lorg/jetbrains/kotlin/psi/KtUserType;", "getTypesToShorten", "visitedProperty", "", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "candidateClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getCandidateClassId", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/name/ClassId;", "outerClassesWithSelf", "Lkotlin/sequences/Sequence;", "getOuterClassesWithSelf", "(Lorg/jetbrains/kotlin/name/ClassId;)Lkotlin/sequences/Sequence;", "qualifiedExpressionsWithSelf", "getQualifiedExpressionsWithSelf", "(Lorg/jetbrains/kotlin/psi/KtDotQualifiedExpression;)Lkotlin/sequences/Sequence;", "qualifiedTypesWithSelf", "getQualifiedTypesWithSelf", "(Lorg/jetbrains/kotlin/psi/KtUserType;)Lkotlin/sequences/Sequence;", "addElementToShorten", "", "element", "Lorg/jetbrains/kotlin/analysis/api/fir/components/ElementToShorten;", "canBePossibleToDropReceiver", "", "functionCall", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "findClassifierElementsToShorten", "E", "positionScopes", "", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "allClassIds", "allQualifiedElements", "createElementToShorten", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "name", "nameToImport", "importAllInParent", "findFakePackageToShortenFn", "findFakePackageToShorten", "Lorg/jetbrains/kotlin/analysis/api/fir/components/ShortenQualifier;", "wholeQualifiedExpression", "Lorg/jetbrains/kotlin/analysis/api/fir/components/ShortenType;", "typeElement", "findTypeQualifierToShorten", "wholeClassQualifier", "wholeQualifierElement", "findTypeToShorten", "wholeClassifierId", "wholeTypeElement", "findUnambiguousReferencedCallableId", "namedReference", "Lorg/jetbrains/kotlin/fir/references/FirNamedReference;", "getSingleUnambiguousCandidate", "Lorg/jetbrains/kotlin/fir/references/FirErrorNamedReference;", "processCallableQualifiedAccess", "calledSymbol", "qualifiedCallExpression", "expressionToGetScope", "Lorg/jetbrains/kotlin/psi/KtExpression;", "findCallableInScopes", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/analysis/api/fir/components/AvailableSymbol;", "processFunctionCall", "processPropertyReference", "resolvedNamedReference", "Lorg/jetbrains/kotlin/fir/references/FirResolvedNamedReference;", "processTypeQualifier", "resolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvedQualifier;", "processTypeRef", "resolvedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "visitElement", "Lorg/jetbrains/kotlin/fir/FirElement;", "visitErrorResolvedQualifier", "errorResolvedQualifier", "Lorg/jetbrains/kotlin/fir/expressions/FirErrorResolvedQualifier;", "visitErrorTypeRef", "errorTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirErrorTypeRef;", "visitFunctionCall", "visitProperty", "property", "visitResolvedNamedReference", "visitResolvedQualifier", "visitResolvedTypeRef", "visitValueParameter", "valueParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "analysis-api-fir"})
@SourceDebugExtension(value={"SMAP\nKtFirReferenceShortener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtFirReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/fir/components/ElementsToShortenCollector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,661:1\n429#1,41:663\n429#1,41:704\n1#2:662\n3190#3,10:745\n1726#3,3:755\n1747#3,3:758\n1549#3:761\n1620#3,3:762\n1655#3,8:765\n1549#3:773\n1620#3,3:774\n*S KotlinDebug\n*F\n+ 1 KtFirReferenceShortener.kt\norg/jetbrains/kotlin/analysis/api/fir/components/ElementsToShortenCollector\n*L\n376#1:663,41\n412#1:704,41\n507#1:745,10\n511#1:755,3\n522#1:758,3\n561#1:761\n561#1:762,3\n564#1:765,8\n566#1:773\n566#1:774,3\n*E\n"})
final class ElementsToShortenCollector
extends FirVisitorVoid {
    @NotNull
    private final FirShorteningContext shorteningContext;
    @NotNull
    private final FirTowerContextProvider towerContextProvider;
    @NotNull
    private final TextRange selection;
    @NotNull
    private final Function1<FirClassLikeSymbol<?>, ShortenOption> classShortenOption;
    @NotNull
    private final Function1<FirCallableSymbol<?>, ShortenOption> callableShortenOption;
    @NotNull
    private final LLFirResolveSession firResolveSession;
    @NotNull
    private final List<FqName> namesToImport;
    @NotNull
    private final List<FqName> namesToImportWithStar;
    @NotNull
    private final List<KtUserType> typesToShorten;
    @NotNull
    private final List<KtDotQualifiedExpression> qualifiersToShorten;
    @NotNull
    private final Set<FirProperty> visitedProperty;

    public ElementsToShortenCollector(@NotNull FirShorteningContext shorteningContext, @NotNull FirTowerContextProvider towerContextProvider, @NotNull TextRange selection, @NotNull Function1<? super FirClassLikeSymbol<?>, ? extends ShortenOption> classShortenOption, @NotNull Function1<? super FirCallableSymbol<?>, ? extends ShortenOption> callableShortenOption, @NotNull LLFirResolveSession firResolveSession) {
        Intrinsics.checkNotNullParameter((Object)shorteningContext, (String)"shorteningContext");
        Intrinsics.checkNotNullParameter((Object)towerContextProvider, (String)"towerContextProvider");
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter(classShortenOption, (String)"classShortenOption");
        Intrinsics.checkNotNullParameter(callableShortenOption, (String)"callableShortenOption");
        Intrinsics.checkNotNullParameter((Object)firResolveSession, (String)"firResolveSession");
        this.shorteningContext = shorteningContext;
        this.towerContextProvider = towerContextProvider;
        this.selection = selection;
        this.classShortenOption = classShortenOption;
        this.callableShortenOption = callableShortenOption;
        this.firResolveSession = firResolveSession;
        this.namesToImport = new ArrayList();
        this.namesToImportWithStar = new ArrayList();
        this.typesToShorten = new ArrayList();
        this.qualifiersToShorten = new ArrayList();
        this.visitedProperty = new LinkedHashSet();
    }

    @NotNull
    public final List<FqName> getNamesToImport() {
        return this.namesToImport;
    }

    @NotNull
    public final List<FqName> getNamesToImportWithStar() {
        return this.namesToImportWithStar;
    }

    @NotNull
    public final List<KtUserType> getTypesToShorten() {
        return this.typesToShorten;
    }

    @NotNull
    public final List<KtDotQualifiedExpression> getQualifiersToShorten() {
        return this.qualifiersToShorten;
    }

    @Override
    public void visitValueParameter(@NotNull FirValueParameter valueParameter2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)valueParameter2, (String)"valueParameter");
            super.visitValueParameter(valueParameter2);
            FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(valueParameter2);
            if (firProperty == null) break block0;
            FirProperty it = firProperty;
            boolean bl = false;
            this.visitProperty(it);
        }
    }

    @Override
    public void visitProperty(@NotNull FirProperty property2) {
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        if (this.visitedProperty.add(property2)) {
            super.visitProperty(property2);
        }
    }

    @Override
    public void visitElement(@NotNull FirElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        element.acceptChildren(this);
    }

    @Override
    public void visitErrorTypeRef(@NotNull FirErrorTypeRef errorTypeRef) {
        Intrinsics.checkNotNullParameter((Object)errorTypeRef, (String)"errorTypeRef");
        this.visitResolvedTypeRef(errorTypeRef);
    }

    @Override
    public void visitResolvedTypeRef(@NotNull FirResolvedTypeRef resolvedTypeRef) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)resolvedTypeRef, (String)"resolvedTypeRef");
            this.processTypeRef(resolvedTypeRef);
            resolvedTypeRef.acceptChildren(this);
            FirTypeRef firTypeRef = resolvedTypeRef.getDelegatedTypeRef();
            if (firTypeRef == null) break block0;
            firTypeRef.accept(this);
        }
    }

    @Override
    public void visitResolvedQualifier(@NotNull FirResolvedQualifier resolvedQualifier) {
        Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
        super.visitResolvedQualifier(resolvedQualifier);
        this.processTypeQualifier(resolvedQualifier);
    }

    @Override
    public void visitErrorResolvedQualifier(@NotNull FirErrorResolvedQualifier errorResolvedQualifier) {
        Intrinsics.checkNotNullParameter((Object)errorResolvedQualifier, (String)"errorResolvedQualifier");
        super.visitErrorResolvedQualifier(errorResolvedQualifier);
        this.processTypeQualifier(errorResolvedQualifier);
    }

    @Override
    public void visitResolvedNamedReference(@NotNull FirResolvedNamedReference resolvedNamedReference) {
        Intrinsics.checkNotNullParameter((Object)resolvedNamedReference, (String)"resolvedNamedReference");
        super.visitResolvedNamedReference(resolvedNamedReference);
        this.processPropertyReference(resolvedNamedReference);
    }

    @Override
    public void visitFunctionCall(@NotNull FirFunctionCall functionCall) {
        Intrinsics.checkNotNullParameter((Object)functionCall, (String)"functionCall");
        super.visitFunctionCall(functionCall);
        this.processFunctionCall(functionCall);
    }

    private final void processTypeRef(FirResolvedTypeRef resolvedTypeRef) {
        block5: {
            PsiElement psiElement = UtilsKt.getPsi(resolvedTypeRef);
            KtTypeReference ktTypeReference = psiElement instanceof KtTypeReference ? (KtTypeReference)psiElement : null;
            if (ktTypeReference == null) {
                return;
            }
            KtTypeReference wholeTypeReference = ktTypeReference;
            if (!wholeTypeReference.getTextRange().intersects(this.selection)) {
                return;
            }
            ClassId classId = this.getCandidateClassId(ConeTypeUtilsKt.lowerBoundIfFlexible(resolvedTypeRef.getType()));
            if (classId == null) {
                return;
            }
            ClassId wholeClassifierId = classId;
            KtTypeElement ktTypeElement = wholeTypeReference.getTypeElement();
            KtTypeElement ktTypeElement2 = ktTypeElement != null ? KtPsiUtilKt.unwrapNullability(ktTypeElement) : null;
            KtUserType ktUserType = ktTypeElement2 instanceof KtUserType ? (KtUserType)ktTypeElement2 : null;
            if (ktUserType == null) {
                return;
            }
            KtUserType wholeTypeElement = ktUserType;
            if (wholeTypeElement.getQualifier() == null) {
                return;
            }
            ElementToShorten elementToShorten = this.findTypeToShorten(wholeClassifierId, wholeTypeElement);
            if (elementToShorten == null) break block5;
            ElementToShorten p0 = elementToShorten;
            boolean bl = false;
            this.addElementToShorten(p0);
        }
    }

    @Nullable
    public final ClassId getCandidateClassId(@NotNull ConeKotlinType $this$candidateClassId) {
        ConeDiagnostic diagnostic;
        Intrinsics.checkNotNullParameter((Object)$this$candidateClassId, (String)"<this>");
        ConeKotlinType coneKotlinType = $this$candidateClassId;
        return coneKotlinType instanceof ConeErrorType ? ((diagnostic = ((ConeErrorType)$this$candidateClassId).getDiagnostic()) instanceof ConeUnmatchedTypeArgumentsError ? ((FirClassLikeSymbol)((ConeUnmatchedTypeArgumentsError)diagnostic).getSymbol()).getClassId() : null) : (coneKotlinType instanceof ConeClassLikeType ? ((ConeClassLikeType)$this$candidateClassId).getLookupTag().getClassId() : null);
    }

    /*
     * WARNING - void declaration
     */
    private final ElementToShorten findTypeToShorten(ClassId wholeClassifierId, KtUserType wholeTypeElement) {
        ElementToShorten elementToShorten;
        block12: {
            List<FirScope> list2 = this.shorteningContext.findScopesAtPosition(wholeTypeElement, this.namesToImport, this.towerContextProvider);
            if (list2 == null) {
                return null;
            }
            List<FirScope> positionScopes = list2;
            Sequence<ClassId> allClassIds = this.getOuterClassesWithSelf(wholeClassifierId);
            Sequence<KtUserType> allQualifiedTypeElements = this.getQualifiedTypesWithSelf(wholeTypeElement);
            ElementsToShortenCollector this_$iv = this;
            boolean $i$f$findClassifierElementsToShorten = false;
            for (Pair pair : SequencesKt.zip(allClassIds, allQualifiedTypeElements)) {
                ClassId classId$iv = (ClassId)pair.component1();
                Object element$iv = pair.component2();
                FirClassLikeSymbol<?> firClassLikeSymbol = this_$iv.shorteningContext.toClassSymbol(classId$iv);
                if (firClassLikeSymbol == null) {
                    Object var12_14 = null;
                    elementToShorten = var12_14;
                } else {
                    ShortenOption option$iv = (ShortenOption)((Object)this_$iv.classShortenOption.invoke(firClassLikeSymbol));
                    if (option$iv == ShortenOption.DO_NOT_SHORTEN) continue;
                    FirShorteningContext firShorteningContext = this_$iv.shorteningContext;
                    Name name2 = classId$iv.getShortClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classId.shortClassName");
                    AvailableSymbol<ClassId> availableClassifier$iv = firShorteningContext.findFirstClassifierInScopesByName(positionScopes, name2);
                    if (availableClassifier$iv == null) {
                        void p2;
                        void p1;
                        if (option$iv == ShortenOption.SHORTEN_IF_ALREADY_IMPORTED) continue;
                        boolean bl = option$iv == ShortenOption.SHORTEN_AND_STAR_IMPORT;
                        FqName fqName2 = classId$iv.asSingleFqName();
                        KtUserType p0 = (KtUserType)element$iv;
                        boolean bl2 = false;
                        elementToShorten = new ShortenType(p0, (FqName)p1, (boolean)p2);
                    } else if (Intrinsics.areEqual((Object)availableClassifier$iv.getSymbol(), (Object)classId$iv)) {
                        if (availableClassifier$iv.getImportKind() == ImportKind.EXPLICIT && option$iv == ShortenOption.SHORTEN_AND_STAR_IMPORT) {
                            boolean p2 = true;
                            FqName p1 = classId$iv.asSingleFqName();
                            KtUserType p0 = (KtUserType)element$iv;
                            boolean bl = false;
                            elementToShorten = new ShortenType(p0, p1, p2);
                        } else {
                            boolean p2 = false;
                            FqName p1 = null;
                            KtUserType p0 = (KtUserType)element$iv;
                            boolean bl = false;
                            elementToShorten = new ShortenType(p0, p1, p2);
                        }
                    } else if (availableClassifier$iv.getImportKind() == ImportKind.DEFAULT_STAR && option$iv == ShortenOption.SHORTEN_AND_STAR_IMPORT) {
                        boolean p2 = true;
                        FqName p1 = classId$iv.asSingleFqName();
                        KtUserType p0 = (KtUserType)element$iv;
                        boolean bl = false;
                        elementToShorten = new ShortenType(p0, p1, p2);
                    } else {
                        if (!availableClassifier$iv.getImportKind().getCanBeOverwrittenByExplicitImport() || option$iv != ShortenOption.SHORTEN_AND_IMPORT) continue;
                        boolean p2 = false;
                        FqName p1 = classId$iv.asSingleFqName();
                        KtUserType p0 = (KtUserType)element$iv;
                        boolean bl = false;
                        elementToShorten = new ShortenType(p0, p1, p2);
                    }
                }
                break block12;
            }
            KtUserType p0 = (KtUserType)SequencesKt.last(allQualifiedTypeElements);
            boolean bl = false;
            elementToShorten = this.findFakePackageToShorten(p0);
        }
        return elementToShorten;
    }

    private final ShortenType findFakePackageToShorten(KtUserType typeElement) {
        KtUserType deepestTypeWithQualifier = (KtUserType)SequencesKt.last(this.getQualifiedTypesWithSelf(typeElement));
        return KtFirReferenceShortenerKt.access$hasFakeRootPrefix(deepestTypeWithQualifier) ? new ShortenType(deepestTypeWithQualifier, null, false, 6, null) : null;
    }

    private final void processTypeQualifier(FirResolvedQualifier resolvedQualifier) {
        block8: {
            KtDotQualifiedExpression ktDotQualifiedExpression;
            ClassId classId = resolvedQualifier.getClassId();
            if (classId == null) {
                return;
            }
            ClassId wholeClassQualifier = classId;
            PsiElement psiElement = UtilsKt.getPsi(resolvedQualifier);
            if (psiElement == null) {
                return;
            }
            PsiElement qualifierPsi = psiElement;
            if (!qualifierPsi.getTextRange().intersects(this.selection)) {
                return;
            }
            PsiElement psiElement2 = qualifierPsi;
            if (psiElement2 instanceof KtDotQualifiedExpression) {
                ktDotQualifiedExpression = (KtDotQualifiedExpression)qualifierPsi;
            } else if (psiElement2 instanceof KtNameReferenceExpression) {
                ktDotQualifiedExpression = KtFirReferenceShortenerKt.getDotQualifiedExpressionForSelector((KtElement)qualifierPsi);
                if (ktDotQualifiedExpression == null) {
                    return;
                }
            } else {
                return;
            }
            KtDotQualifiedExpression wholeQualifierElement = ktDotQualifiedExpression;
            ElementToShorten elementToShorten = this.findTypeQualifierToShorten(wholeClassQualifier, wholeQualifierElement);
            if (elementToShorten == null) break block8;
            ElementToShorten p0 = elementToShorten;
            boolean bl = false;
            this.addElementToShorten(p0);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final ElementToShorten findTypeQualifierToShorten(ClassId wholeClassQualifier, KtDotQualifiedExpression wholeQualifierElement) {
        ElementToShorten elementToShorten;
        block12: {
            List<FirScope> list2 = this.shorteningContext.findScopesAtPosition(wholeQualifierElement, this.namesToImport, this.towerContextProvider);
            if (list2 == null) {
                return null;
            }
            List<FirScope> positionScopes = list2;
            Sequence<ClassId> allClassIds = this.getOuterClassesWithSelf(wholeClassQualifier);
            Sequence<KtDotQualifiedExpression> allQualifiers = this.getQualifiedExpressionsWithSelf(wholeQualifierElement);
            ElementsToShortenCollector this_$iv = this;
            boolean $i$f$findClassifierElementsToShorten = false;
            for (Pair pair : SequencesKt.zip(allClassIds, allQualifiers)) {
                ClassId classId$iv = (ClassId)pair.component1();
                Object element$iv = pair.component2();
                FirClassLikeSymbol<?> firClassLikeSymbol = this_$iv.shorteningContext.toClassSymbol(classId$iv);
                if (firClassLikeSymbol == null) {
                    Object var12_14 = null;
                    elementToShorten = var12_14;
                } else {
                    ShortenOption option$iv = (ShortenOption)((Object)this_$iv.classShortenOption.invoke(firClassLikeSymbol));
                    if (option$iv == ShortenOption.DO_NOT_SHORTEN) continue;
                    FirShorteningContext firShorteningContext = this_$iv.shorteningContext;
                    Name name2 = classId$iv.getShortClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classId.shortClassName");
                    AvailableSymbol<ClassId> availableClassifier$iv = firShorteningContext.findFirstClassifierInScopesByName(positionScopes, name2);
                    if (availableClassifier$iv == null) {
                        void p2;
                        void p1;
                        if (option$iv == ShortenOption.SHORTEN_IF_ALREADY_IMPORTED) continue;
                        boolean bl = option$iv == ShortenOption.SHORTEN_AND_STAR_IMPORT;
                        FqName fqName2 = classId$iv.asSingleFqName();
                        KtDotQualifiedExpression p0 = (KtDotQualifiedExpression)element$iv;
                        boolean bl2 = false;
                        elementToShorten = new ShortenQualifier(p0, (FqName)p1, (boolean)p2);
                    } else if (Intrinsics.areEqual((Object)availableClassifier$iv.getSymbol(), (Object)classId$iv)) {
                        if (availableClassifier$iv.getImportKind() == ImportKind.EXPLICIT && option$iv == ShortenOption.SHORTEN_AND_STAR_IMPORT) {
                            boolean p2 = true;
                            FqName p1 = classId$iv.asSingleFqName();
                            KtDotQualifiedExpression p0 = (KtDotQualifiedExpression)element$iv;
                            boolean bl = false;
                            elementToShorten = new ShortenQualifier(p0, p1, p2);
                        } else {
                            boolean p2 = false;
                            FqName p1 = null;
                            KtDotQualifiedExpression p0 = (KtDotQualifiedExpression)element$iv;
                            boolean bl = false;
                            elementToShorten = new ShortenQualifier(p0, p1, p2);
                        }
                    } else if (availableClassifier$iv.getImportKind() == ImportKind.DEFAULT_STAR && option$iv == ShortenOption.SHORTEN_AND_STAR_IMPORT) {
                        boolean p2 = true;
                        FqName p1 = classId$iv.asSingleFqName();
                        KtDotQualifiedExpression p0 = (KtDotQualifiedExpression)element$iv;
                        boolean bl = false;
                        elementToShorten = new ShortenQualifier(p0, p1, p2);
                    } else {
                        if (!availableClassifier$iv.getImportKind().getCanBeOverwrittenByExplicitImport() || option$iv != ShortenOption.SHORTEN_AND_IMPORT) continue;
                        boolean p2 = false;
                        FqName p1 = classId$iv.asSingleFqName();
                        KtDotQualifiedExpression p0 = (KtDotQualifiedExpression)element$iv;
                        boolean bl = false;
                        elementToShorten = new ShortenQualifier(p0, p1, p2);
                    }
                }
                break block12;
            }
            KtDotQualifiedExpression p0 = (KtDotQualifiedExpression)SequencesKt.last(allQualifiers);
            boolean bl = false;
            elementToShorten = this.findFakePackageToShorten(p0);
        }
        return elementToShorten;
    }

    private final <E> ElementToShorten findClassifierElementsToShorten(List<? extends FirScope> positionScopes, Sequence<ClassId> allClassIds, Sequence<? extends E> allQualifiedElements, Function3<? super E, ? super FqName, ? super Boolean, ? extends ElementToShorten> createElementToShorten, Function1<? super E, ? extends ElementToShorten> findFakePackageToShortenFn) {
        boolean $i$f$findClassifierElementsToShorten = false;
        for (Pair pair : SequencesKt.zip(allClassIds, allQualifiedElements)) {
            ClassId classId = (ClassId)pair.component1();
            Object element = pair.component2();
            FirClassLikeSymbol<?> firClassLikeSymbol = this.shorteningContext.toClassSymbol(classId);
            if (firClassLikeSymbol == null) {
                return null;
            }
            ShortenOption option = (ShortenOption)((Object)this.classShortenOption.invoke(firClassLikeSymbol));
            if (option == ShortenOption.DO_NOT_SHORTEN) continue;
            Name name2 = classId.getShortClassName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"classId.shortClassName");
            AvailableSymbol<ClassId> availableClassifier = this.shorteningContext.findFirstClassifierInScopesByName(positionScopes, name2);
            if (availableClassifier == null) {
                if (option == ShortenOption.SHORTEN_IF_ALREADY_IMPORTED) continue;
                return (ElementToShorten)createElementToShorten.invoke(element, (Object)classId.asSingleFqName(), (Object)(option == ShortenOption.SHORTEN_AND_STAR_IMPORT ? 1 : 0));
            }
            if (Intrinsics.areEqual((Object)availableClassifier.getSymbol(), (Object)classId)) {
                return availableClassifier.getImportKind() == ImportKind.EXPLICIT && option == ShortenOption.SHORTEN_AND_STAR_IMPORT ? (ElementToShorten)createElementToShorten.invoke(element, (Object)classId.asSingleFqName(), (Object)true) : (ElementToShorten)createElementToShorten.invoke(element, null, (Object)false);
            }
            if (availableClassifier.getImportKind() == ImportKind.DEFAULT_STAR && option == ShortenOption.SHORTEN_AND_STAR_IMPORT) {
                return (ElementToShorten)createElementToShorten.invoke(element, (Object)classId.asSingleFqName(), (Object)true);
            }
            if (!availableClassifier.getImportKind().getCanBeOverwrittenByExplicitImport() || option != ShortenOption.SHORTEN_AND_IMPORT) continue;
            return (ElementToShorten)createElementToShorten.invoke(element, (Object)classId.asSingleFqName(), (Object)false);
        }
        return (ElementToShorten)findFakePackageToShortenFn.invoke(SequencesKt.last(allQualifiedElements));
    }

    private final void processPropertyReference(FirResolvedNamedReference resolvedNamedReference) {
        PsiElement psiElement = UtilsKt.getPsi(resolvedNamedReference);
        KtNameReferenceExpression ktNameReferenceExpression = psiElement instanceof KtNameReferenceExpression ? (KtNameReferenceExpression)psiElement : null;
        if (ktNameReferenceExpression == null) {
            return;
        }
        KtNameReferenceExpression referenceExpression2 = ktNameReferenceExpression;
        if (!referenceExpression2.getTextRange().intersects(this.selection)) {
            return;
        }
        KtDotQualifiedExpression ktDotQualifiedExpression = KtFirReferenceShortenerKt.getDotQualifiedExpressionForSelector(referenceExpression2);
        if (ktDotQualifiedExpression == null) {
            return;
        }
        KtDotQualifiedExpression qualifiedProperty = ktDotQualifiedExpression;
        FirBasedSymbol<?> firBasedSymbol = resolvedNamedReference.getResolvedSymbol();
        FirCallableSymbol firCallableSymbol = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol callableSymbol = firCallableSymbol;
        this.processCallableQualifiedAccess(callableSymbol, qualifiedProperty, qualifiedProperty, (Function2)new Function2<List<? extends FirScope>, Name, List<? extends AvailableSymbol<? extends FirVariableSymbol<?>>>>(this.shorteningContext){

            @NotNull
            public final List<AvailableSymbol<FirVariableSymbol<?>>> invoke(@NotNull List<? extends FirScope> p0, @NotNull Name p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((FirShorteningContext)this.receiver).findPropertiesInScopes(p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "findPropertiesInScopes(Ljava/util/List;Lorg/jetbrains/kotlin/name/Name;)Ljava/util/List;";
            }

            @NotNull
            public final String getName() {
                return "findPropertiesInScopes";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(FirShorteningContext.class);
            }
        });
    }

    private final void processFunctionCall(FirFunctionCall functionCall) {
        if (!this.canBePossibleToDropReceiver(functionCall)) {
            return;
        }
        PsiElement psiElement = UtilsKt.getPsi(functionCall);
        KtDotQualifiedExpression ktDotQualifiedExpression = psiElement instanceof KtDotQualifiedExpression ? (KtDotQualifiedExpression)psiElement : null;
        if (ktDotQualifiedExpression == null) {
            return;
        }
        KtDotQualifiedExpression qualifiedCallExpression = ktDotQualifiedExpression;
        if (!qualifiedCallExpression.getTextRange().intersects(this.selection)) {
            return;
        }
        KtExpression ktExpression = qualifiedCallExpression.getSelectorExpression();
        KtCallExpression ktCallExpression = ktExpression instanceof KtCallExpression ? (KtCallExpression)ktExpression : null;
        if (ktCallExpression == null) {
            return;
        }
        KtCallExpression callExpression = ktCallExpression;
        FirNamedReference calleeReference = functionCall.getCalleeReference();
        FirCallableSymbol<?> firCallableSymbol = this.findUnambiguousReferencedCallableId(calleeReference);
        if (firCallableSymbol == null) {
            return;
        }
        FirCallableSymbol<?> calledSymbol = firCallableSymbol;
        this.processCallableQualifiedAccess(calledSymbol, qualifiedCallExpression, callExpression, (Function2)new Function2<List<? extends FirScope>, Name, List<? extends AvailableSymbol<? extends FirNamedFunctionSymbol>>>((Object)this.shorteningContext){

            @NotNull
            public final List<AvailableSymbol<FirNamedFunctionSymbol>> invoke(@NotNull List<? extends FirScope> p0, @NotNull Name p1) {
                Intrinsics.checkNotNullParameter(p0, (String)"p0");
                Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                return ((FirShorteningContext)this.receiver).findFunctionsInScopes(p0, p1);
            }

            @NotNull
            public final String getSignature() {
                return "findFunctionsInScopes(Ljava/util/List;Lorg/jetbrains/kotlin/name/Name;)Ljava/util/List;";
            }

            @NotNull
            public final String getName() {
                return "findFunctionsInScopes";
            }

            @NotNull
            public final KDeclarationContainer getOwner() {
                return (KDeclarationContainer)Reflection.getOrCreateKotlinClass(FirShorteningContext.class);
            }
        });
    }

    private final void processCallableQualifiedAccess(FirCallableSymbol<?> calledSymbol, KtDotQualifiedExpression qualifiedCallExpression, KtExpression expressionToGetScope, Function2<? super List<? extends FirScope>, ? super Name, ? extends List<? extends AvailableSymbol<? extends FirCallableSymbol<?>>>> findCallableInScopes) {
        block17: {
            ShortenQualifier callToShorten;
            ShortenQualifier shortenQualifier;
            boolean bl;
            List matchedCallables;
            FqName nameToImport;
            ShortenOption option;
            block15: {
                option = (ShortenOption)((Object)this.callableShortenOption.invoke(calledSymbol));
                if (option == ShortenOption.DO_NOT_SHORTEN) {
                    return;
                }
                List<FirScope> list2 = this.shorteningContext.findScopesAtPosition(expressionToGetScope, this.namesToImport, this.towerContextProvider);
                if (list2 == null) {
                    return;
                }
                List<FirScope> scopes2 = list2;
                List availableCallables = (List)findCallableInScopes.invoke(scopes2, (Object)calledSymbol.getName());
                nameToImport = this.shorteningContext.convertToImportableName(calledSymbol);
                Iterable $this$partition$iv = availableCallables;
                boolean $i$f$partition = false;
                ArrayList first$iv = new ArrayList();
                ArrayList second$iv = new ArrayList();
                for (Object element$iv : $this$partition$iv) {
                    AvailableSymbol it = (AvailableSymbol)element$iv;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)((FirCallableSymbol)it.getSymbol()).getCallableId(), (Object)calledSymbol.getCallableId())) {
                        first$iv.add(element$iv);
                        continue;
                    }
                    second$iv.add(element$iv);
                }
                Pair pair = new Pair(first$iv, second$iv);
                matchedCallables = (List)pair.component1();
                List otherCallables = (List)pair.component2();
                Iterable $this$all$iv = otherCallables;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        AvailableSymbol it = (AvailableSymbol)element$iv;
                        boolean bl3 = false;
                        if (it.getImportKind() == ImportKind.DEFAULT_STAR) continue;
                        bl = false;
                        break block15;
                    }
                    bl = true;
                }
            }
            if (bl) {
                if (matchedCallables.isEmpty()) {
                    if (nameToImport == null || option == ShortenOption.SHORTEN_IF_ALREADY_IMPORTED) {
                        return;
                    }
                    shortenQualifier = new ShortenQualifier(qualifiedCallExpression, nameToImport, option == ShortenOption.SHORTEN_AND_STAR_IMPORT);
                } else {
                    boolean bl4;
                    block16: {
                        Iterable $this$any$iv = matchedCallables;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl4 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                AvailableSymbol it = (AvailableSymbol)element$iv;
                                boolean bl5 = false;
                                if (!(it.getImportKind() == ImportKind.EXPLICIT)) continue;
                                bl4 = true;
                                break block16;
                            }
                            bl4 = false;
                        }
                    }
                    shortenQualifier = bl4 && option == ShortenOption.SHORTEN_AND_STAR_IMPORT ? new ShortenQualifier(qualifiedCallExpression, nameToImport, true) : new ShortenQualifier(qualifiedCallExpression, null, false, 6, null);
                }
            } else {
                shortenQualifier = this.findFakePackageToShorten(qualifiedCallExpression);
            }
            ShortenQualifier shortenQualifier2 = callToShorten = shortenQualifier;
            if (shortenQualifier2 == null) break block17;
            ElementToShorten p0 = shortenQualifier2;
            boolean bl6 = false;
            this.addElementToShorten(p0);
        }
    }

    private final boolean canBePossibleToDropReceiver(FirFunctionCall functionCall) {
        FirExpression firExpression2 = functionCall.getExplicitReceiver();
        FirResolvedQualifier firResolvedQualifier = firExpression2 instanceof FirResolvedQualifier ? (FirResolvedQualifier)firExpression2 : null;
        if (firResolvedQualifier == null) {
            return false;
        }
        FirResolvedQualifier explicitReceiver = firResolvedQualifier;
        if (functionCall.getExtensionReceiver() instanceof FirNoReceiverExpression) {
            return true;
        }
        FirRegularClass firRegularClass = this.shorteningContext.getRegularClass(explicitReceiver.getTypeRef());
        if (firRegularClass == null) {
            return true;
        }
        FirRegularClass receiverType = firRegularClass;
        return receiverType.getClassKind() != ClassKind.OBJECT;
    }

    private final FirCallableSymbol<?> findUnambiguousReferencedCallableId(FirNamedReference namedReference) {
        FirNamedReference firNamedReference = namedReference;
        FirBasedSymbol unambiguousSymbol = firNamedReference instanceof FirResolvedNamedReference ? ((FirResolvedNamedReference)namedReference).getResolvedSymbol() : (firNamedReference instanceof FirErrorNamedReference ? (FirBasedSymbol)this.getSingleUnambiguousCandidate((FirErrorNamedReference)namedReference) : null);
        return unambiguousSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)unambiguousSymbol : null;
    }

    /*
     * WARNING - void declaration
     */
    private final FirCallableSymbol<?> getSingleUnambiguousCandidate(FirErrorNamedReference namedReference) {
        FirCallableSymbol it;
        Object object;
        void $this$mapTo$iv$iv;
        ConeDiagnostic coneDiagnostic = namedReference.getDiagnostic();
        ConeAmbiguityError coneAmbiguityError = coneDiagnostic instanceof ConeAmbiguityError ? (ConeAmbiguityError)coneDiagnostic : null;
        if (coneAmbiguityError == null) {
            return null;
        }
        ConeAmbiguityError coneAmbiguityError2 = coneAmbiguityError;
        Iterable $this$map$iv = coneAmbiguityError2.getCandidates();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            AbstractCandidate abstractCandidate = (AbstractCandidate)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            FirBasedSymbol<?> firBasedSymbol = ((AbstractCandidate)((Object)it)).getSymbol();
            Intrinsics.checkNotNull(firBasedSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol<*>");
            object.add((FirCallableSymbol)firBasedSymbol);
        }
        List candidates2 = (List)destination$iv$iv;
        if (!(!((Collection)candidates2).isEmpty())) {
            boolean $i$a$-require-ElementsToShortenCollector$getSingleUnambiguousCandidate$22 = false;
            String $i$a$-require-ElementsToShortenCollector$getSingleUnambiguousCandidate$22 = "Cannot have zero candidates";
            throw new IllegalArgumentException($i$a$-require-ElementsToShortenCollector$getSingleUnambiguousCandidate$22.toString());
        }
        Iterable $this$distinctBy$iv = candidates2;
        boolean $i$f$distinctBy2 = false;
        HashSet<CallableId> set$iv = new HashSet<CallableId>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            it = (FirCallableSymbol)e$iv;
            boolean bl = false;
            CallableId key$iv = it.getCallableId();
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        List distinctCandidates = list$iv;
        FirCallableSymbol firCallableSymbol = (FirCallableSymbol)kotlin.collections.CollectionsKt.singleOrNull((List)distinctCandidates);
        if (firCallableSymbol == null) {
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Iterable $i$f$distinctBy2 = distinctCandidates;
            object = new StringBuilder().append("Expected all candidates to have same callableId, but got: ");
            boolean $i$f$map2 = false;
            list$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(kotlin.collections.CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it2;
                FirCallableSymbol firCallableSymbol2 = (FirCallableSymbol)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl = false;
                collection.add(it2.getCallableId());
            }
            String string2 = ((StringBuilder)object).append((List)destination$iv$iv2).toString();
            throw new IllegalStateException(string2.toString());
        }
        return firCallableSymbol;
    }

    private final ShortenQualifier findFakePackageToShorten(KtDotQualifiedExpression wholeQualifiedExpression) {
        KtDotQualifiedExpression deepestQualifier = (KtDotQualifiedExpression)SequencesKt.last(this.getQualifiedExpressionsWithSelf(wholeQualifiedExpression));
        return KtFirReferenceShortenerKt.access$hasFakeRootPrefix(deepestQualifier) ? new ShortenQualifier(deepestQualifier, null, false, 6, null) : null;
    }

    /*
     * Unable to fully structure code
     */
    private final void addElementToShorten(ElementToShorten element) {
        if (!element.getImportAllInParent()) ** GOTO lbl-1000
        v0 = element.getNameToImport();
        v1 = v0 != null && (v0 = FqNamesUtilKt.parentOrNull(v0)) != null ? !v0.isRoot() : false;
        if (v1) {
            v2 = element.getNameToImport();
            CollectionsKt.addIfNotNull((Collection)this.namesToImportWithStar, v2 != null ? v2.parent() : null);
        } else lbl-1000:
        // 2 sources

        {
            CollectionsKt.addIfNotNull((Collection)this.namesToImport, element.getNameToImport());
        }
        var2_2 = element;
        if (var2_2 instanceof ShortenType) {
            this.typesToShorten.add(((ShortenType)element).getElement());
        } else if (var2_2 instanceof ShortenQualifier) {
            this.qualifiersToShorten.add(((ShortenQualifier)element).getElement());
        }
    }

    private final Sequence<ClassId> getOuterClassesWithSelf(ClassId $this$outerClassesWithSelf) {
        return SequencesKt.generateSequence((Object)$this$outerClassesWithSelf, (Function1)outerClassesWithSelf.1.INSTANCE);
    }

    private final Sequence<KtUserType> getQualifiedTypesWithSelf(KtUserType $this$qualifiedTypesWithSelf) {
        if (!($this$qualifiedTypesWithSelf.getQualifier() != null)) {
            boolean bl = false;
            String string2 = "Type element should have at least one qualifier, instead it was " + $this$qualifiedTypesWithSelf.getText();
            throw new IllegalArgumentException(string2.toString());
        }
        return SequencesKt.takeWhile((Sequence)SequencesKt.generateSequence((Object)$this$qualifiedTypesWithSelf, (Function1)qualifiedTypesWithSelf.2.INSTANCE), (Function1)qualifiedTypesWithSelf.3.INSTANCE);
    }

    private final Sequence<KtDotQualifiedExpression> getQualifiedExpressionsWithSelf(KtDotQualifiedExpression $this$qualifiedExpressionsWithSelf) {
        return SequencesKt.generateSequence((Object)$this$qualifiedExpressionsWithSelf, (Function1)qualifiedExpressionsWithSelf.1.INSTANCE);
    }
}

