/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.compiler.plugin.definitions;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.script.experimental.api.ResultWithDiagnostics;
import kotlin.script.experimental.api.ScriptCompilationConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.scripting.definitions.DefinitionsKt;
import org.jetbrains.kotlin.scripting.definitions.ScriptDefinition;
import org.jetbrains.kotlin.scripting.definitions.ScriptDependenciesProvider;
import org.jetbrains.kotlin.scripting.resolve.KtFileScriptSource;
import org.jetbrains.kotlin.scripting.resolve.RefineCompilationConfigurationKt;
import org.jetbrains.kotlin.scripting.resolve.ScriptCompilationConfigurationWrapper;
import org.jetbrains.kotlin.scripting.resolve.ScriptReportSink;
import org.jetbrains.kotlin.scripting.resolve.VirtualFileScriptSource;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u001e\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016RF\u0010\u0005\u001a:\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n0\u0006j\u001c\u0012\u0004\u0012\u00020\u0007\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\t\u0018\u00010\bj\u0004\u0018\u0001`\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/scripting/compiler/plugin/definitions/CliScriptDependenciesProvider;", "Lorg/jetbrains/kotlin/scripting/definitions/ScriptDependenciesProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cache", "Ljava/util/HashMap;", "", "Lkotlin/script/experimental/api/ResultWithDiagnostics;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationWrapper;", "Lorg/jetbrains/kotlin/scripting/resolve/ScriptCompilationConfigurationResult;", "Lkotlin/collections/HashMap;", "cacheLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "knownVirtualFileSources", "", "Lorg/jetbrains/kotlin/scripting/resolve/VirtualFileScriptSource;", "calculateRefinedConfiguration", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "providedConfiguration", "Lkotlin/script/experimental/api/ScriptCompilationConfiguration;", "getScriptConfigurationResult", "kotlin-scripting-compiler"})
public final class CliScriptDependenciesProvider
extends ScriptDependenciesProvider {
    @NotNull
    private final ReentrantReadWriteLock cacheLock;
    @NotNull
    private final HashMap<String, ResultWithDiagnostics<ScriptCompilationConfigurationWrapper>> cache;
    @NotNull
    private final Map<String, VirtualFileScriptSource> knownVirtualFileSources;

    public CliScriptDependenciesProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.cacheLock = new ReentrantReadWriteLock();
        this.cache = new HashMap();
        this.knownVirtualFileSources = new LinkedHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getScriptConfigurationResult(@NotNull KtFile file2) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            resultWithDiagnostics = this.calculateRefinedConfiguration(file2, null);
        }
        finally {
            readLock.unlock();
        }
        return resultWithDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> getScriptConfigurationResult(@NotNull KtFile file2, @Nullable ScriptCompilationConfiguration providedConfiguration) {
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ReentrantReadWriteLock.ReadLock readLock = this.cacheLock.readLock();
        readLock.lock();
        try {
            boolean bl = false;
            resultWithDiagnostics = this.calculateRefinedConfiguration(file2, providedConfiguration);
        }
        finally {
            readLock.unlock();
        }
        return resultWithDiagnostics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> calculateRefinedConfiguration(KtFile file2, ScriptCompilationConfiguration providedConfiguration) {
        String path2 = file2.getVirtualFilePath();
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> cached2 = this.cache.get(path2);
        ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics = cached2;
        if (resultWithDiagnostics == null) {
            ScriptDefinition scriptDef = DefinitionsKt.findScriptDefinition((PsiFile)file2);
            if (scriptDef != null) {
                ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> result2 = RefineCompilationConfigurationKt.refineScriptCompilationConfiguration(new KtFileScriptSource(file2, null, 2, null), scriptDef, this.getProject(), providedConfiguration, this.knownVirtualFileSources);
                ScriptReportSink scriptReportSink = (ScriptReportSink)ServiceManager.getService((Project)this.getProject(), ScriptReportSink.class);
                if (scriptReportSink != null) {
                    VirtualFile virtualFile = file2.getVirtualFile();
                    Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"file.virtualFile");
                    scriptReportSink.attachReports(virtualFile, result2.getReports());
                }
                ReentrantReadWriteLock reentrantReadWriteLock = this.cacheLock;
                ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
                int n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
                for (int j = 0; j < n; ++j) {
                    readLock.unlock();
                }
                ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                try {
                    boolean bl = false;
                    ResultWithDiagnostics<ScriptCompilationConfigurationWrapper> resultWithDiagnostics2 = this.cache.put(path2, result2);
                }
                finally {
                    for (int j = 0; j < n; ++j) {
                        readLock.lock();
                    }
                    writeLock.unlock();
                }
                resultWithDiagnostics = result2;
            } else {
                resultWithDiagnostics = null;
            }
        }
        return resultWithDiagnostics;
    }
}

