/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.low.level.api.fir.LLFirModuleResolveComponents;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignation;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.FirDesignationKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.LLFirClassSpecificMembersResolveTarget;
import org.jetbrains.kotlin.analysis.low.level.api.fir.api.targets.TargetUtilsKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.ClassDeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.DeclarationStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElement;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.FileStructureElementKt;
import org.jetbrains.kotlin.analysis.low.level.api.fir.file.structure.RootScriptStructureElement;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirScript;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.impl.FirPrimaryConstructor;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory;", "", "<init>", "()V", "createFileStructureElement", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileStructureElement;", "firDeclaration", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "firFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "moduleComponents", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/LLFirModuleResolveComponents;", "lazyResolveClassGeneratedMembers", "", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "low-level-api-fir"})
@SourceDebugExtension(value={"SMAP\nFileElementFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileElementFactory.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1869#2,2:61\n774#2:63\n865#2,2:64\n*S KotlinDebug\n*F\n+ 1 FileElementFactory.kt\norg/jetbrains/kotlin/analysis/low/level/api/fir/file/structure/FileElementFactory\n*L\n38#1:61,2\n48#1:63\n48#1:64,2\n*E\n"})
public final class FileElementFactory {
    @NotNull
    public static final FileElementFactory INSTANCE = new FileElementFactory();

    private FileElementFactory() {
    }

    @NotNull
    public final FileStructureElement createFileStructureElement(@NotNull FirDeclaration firDeclaration, @NotNull FirFile firFile, @NotNull LLFirModuleResolveComponents moduleComponents) {
        FileStructureElement fileStructureElement;
        Intrinsics.checkNotNullParameter((Object)firDeclaration, (String)"firDeclaration");
        Intrinsics.checkNotNullParameter((Object)firFile, (String)"firFile");
        Intrinsics.checkNotNullParameter((Object)moduleComponents, (String)"moduleComponents");
        FirDeclaration firDeclaration2 = firDeclaration;
        if (firDeclaration2 instanceof FirRegularClass) {
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE.getPrevious());
            this.lazyResolveClassGeneratedMembers((FirRegularClass)firDeclaration);
            fileStructureElement = new ClassDeclarationStructureElement(firFile, (FirRegularClass)firDeclaration, moduleComponents);
        } else if (firDeclaration2 instanceof FirScript) {
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE.getPrevious());
            fileStructureElement = new RootScriptStructureElement(firFile, (FirScript)firDeclaration, moduleComponents);
        } else {
            FirLazyDeclarationResolverKt.lazyResolveToPhase(firDeclaration, FirResolvePhase.BODY_RESOLVE);
            if (firDeclaration instanceof FirPrimaryConstructor) {
                Iterable $this$forEach$iv = ((FirPrimaryConstructor)firDeclaration).getValueParameters();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirValueParameter parameter = (FirValueParameter)element$iv;
                    boolean bl = false;
                    FirProperty firProperty = ClassMembersKt.getCorrespondingProperty(parameter);
                    if (firProperty != null) {
                        FirLazyDeclarationResolverKt.lazyResolveToPhase(firProperty, FirResolvePhase.BODY_RESOLVE);
                    }
                }
            }
            fileStructureElement = new DeclarationStructureElement(firFile, firDeclaration, moduleComponents);
        }
        return fileStructureElement;
    }

    /*
     * WARNING - void declaration
     */
    private final void lazyResolveClassGeneratedMembers(FirRegularClass firClass) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = firClass.getDeclarations();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FirDeclaration p0 = (FirDeclaration)element$iv$iv;
            boolean bl = false;
            if (!FileStructureElementKt.isPartOfClassStructureElement(p0)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List classMembersToResolve = (List)destination$iv$iv;
        if (classMembersToResolve.isEmpty()) {
            return;
        }
        FirDesignation firClassDesignation = FirDesignationKt.collectDesignation$default(firClass, null, 1, null);
        LLFirClassSpecificMembersResolveTarget designationWithMembers = new LLFirClassSpecificMembersResolveTarget(firClassDesignation, classMembersToResolve);
        TargetUtilsKt.resolve(designationWithMembers, FirResolvePhase.BODY_RESOLVE);
    }
}

