/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.js;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.wasm.ic.WasmICContext;
import org.jetbrains.kotlin.cli.common.arguments.K2JSCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.js.HelpersKt;
import org.jetbrains.kotlin.cli.js.IcCachesArtifacts;
import org.jetbrains.kotlin.cli.js.IcCachesConfigurationData;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.ir.backend.js.JsICContext;
import org.jetbrains.kotlin.ir.backend.js.ic.CacheUpdater;
import org.jetbrains.kotlin.ir.backend.js.ic.DirtyFileState;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinLibraryFile;
import org.jetbrains.kotlin.ir.backend.js.ic.KotlinSourceFile;
import org.jetbrains.kotlin.ir.backend.js.ic.PlatformDependentICContext;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u001ad\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001ad\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u000e\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u00a8\u0006\u0014"}, d2={"prepareIcCaches", "Lorg/jetbrains/kotlin/cli/js/IcCachesArtifacts;", "cacheDirectory", "", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JSCompilerArguments;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "outputDir", "Ljava/io/File;", "libraries", "", "friendLibraries", "targetConfiguration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "mainCallArguments", "icCacheReadOnly", "", "icConfigurationData", "Lorg/jetbrains/kotlin/cli/js/IcCachesConfigurationData;", "cli-js"})
@SourceDebugExtension(value={"SMAP\nIcCaches.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IcCaches.kt\norg/jetbrains/kotlin/cli/js/IcCachesKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,152:1\n1#2:153\n1740#3,3:154\n1761#3,3:157\n774#3:160\n865#3,2:161\n*S KotlinDebug\n*F\n+ 1 IcCaches.kt\norg/jetbrains/kotlin/cli/js/IcCachesKt\n*L\n128#1:154,3\n135#1:157,3\n141#1:160\n141#1:161,2\n*E\n"})
public final class IcCachesKt {
    @NotNull
    public static final IcCachesArtifacts prepareIcCaches(@NotNull String cacheDirectory2, @NotNull K2JSCompilerArguments arguments, @NotNull MessageCollector messageCollector2, @NotNull File outputDir, @NotNull List<String> libraries, @NotNull List<String> friendLibraries, @NotNull CompilerConfiguration targetConfiguration, @Nullable List<String> mainCallArguments, boolean icCacheReadOnly) {
        IcCachesConfigurationData icCachesConfigurationData;
        Intrinsics.checkNotNullParameter((Object)cacheDirectory2, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        Intrinsics.checkNotNullParameter(friendLibraries, (String)"friendLibraries");
        Intrinsics.checkNotNullParameter((Object)targetConfiguration, (String)"targetConfiguration");
        if (arguments.getWasm()) {
            String string = arguments.getIncludes();
            Intrinsics.checkNotNull((Object)string);
            icCachesConfigurationData = new IcCachesConfigurationData.Wasm(string, arguments.getWasmDebug(), arguments.getPreserveIcOrder(), arguments.getWasmGenerateWat());
        } else {
            String string = arguments.getIncludes();
            Intrinsics.checkNotNull((Object)string);
            icCachesConfigurationData = new IcCachesConfigurationData.Js(string, HelpersKt.getGranularity(arguments));
        }
        IcCachesConfigurationData data = icCachesConfigurationData;
        return IcCachesKt.prepareIcCaches(cacheDirectory2, data, messageCollector2, outputDir, libraries, friendLibraries, targetConfiguration, mainCallArguments, icCacheReadOnly);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final IcCachesArtifacts prepareIcCaches(@NotNull String cacheDirectory2, @NotNull IcCachesConfigurationData icConfigurationData, @NotNull MessageCollector messageCollector2, @NotNull File outputDir, @NotNull List<String> libraries, @NotNull List<String> friendLibraries, @NotNull CompilerConfiguration targetConfiguration, @Nullable List<String> mainCallArguments, boolean icCacheReadOnly) {
        PlatformDependentICContext platformDependentICContext;
        Intrinsics.checkNotNullParameter((Object)cacheDirectory2, (String)"cacheDirectory");
        Intrinsics.checkNotNullParameter((Object)icConfigurationData, (String)"icConfigurationData");
        Intrinsics.checkNotNullParameter((Object)messageCollector2, (String)"messageCollector");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        Intrinsics.checkNotNullParameter(libraries, (String)"libraries");
        Intrinsics.checkNotNullParameter(friendLibraries, (String)"friendLibraries");
        Intrinsics.checkNotNullParameter((Object)targetConfiguration, (String)"targetConfiguration");
        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, "", null, 4, null);
        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Building cache:", null, 4, null);
        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, "to: " + outputDir, null, 4, null);
        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, "cache directory: " + cacheDirectory2, null, 4, null);
        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, libraries.toString(), null, 4, null);
        long start = System.currentTimeMillis();
        IcCachesConfigurationData icCachesConfigurationData = icConfigurationData;
        if (icCachesConfigurationData instanceof IcCachesConfigurationData.Js) {
            platformDependentICContext = (PlatformDependentICContext)new JsICContext(mainCallArguments, ((IcCachesConfigurationData.Js)icConfigurationData).getGranularity(), null, 4, null);
        } else if (icCachesConfigurationData instanceof IcCachesConfigurationData.Wasm) {
            platformDependentICContext = (PlatformDependentICContext)new WasmICContext(false, !((IcCachesConfigurationData.Wasm)icConfigurationData).getWasmDebug(), ((IcCachesConfigurationData.Wasm)icConfigurationData).getPreserveIcOrder(), !((IcCachesConfigurationData.Wasm)icConfigurationData).getGenerateWat());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        PlatformDependentICContext icContext = platformDependentICContext;
        CacheUpdater cacheUpdater = new CacheUpdater(icConfigurationData.getIncludes(), (Collection)libraries, (Collection)friendLibraries, cacheDirectory2, targetConfiguration, icContext, icConfigurationData instanceof IcCachesConfigurationData.Wasm, !icCacheReadOnly);
        List artifacts = cacheUpdater.actualizeCaches();
        MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, "IC rebuilt overall time: " + (System.currentTimeMillis() - start) + "ms", null, 4, null);
        for (Object object : cacheUpdater.getStopwatchLastLaps()) {
            String entry = (String)object.component1();
            long duration = ((Number)object.component2()).longValue();
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, "  " + entry + ": " + (int)((double)duration / 1000000.0) + "ms", null, 4, null);
        }
        int libIndex = 0;
        for (Map.Entry entry : ((Map)cacheUpdater.getDirtyFileLastStats()).entrySet()) {
            Pair pair;
            EnumSet enumSet;
            Collection it;
            String libFile = ((KotlinLibraryFile)entry.getKey()).unbox-impl();
            Map srcFiles = (Map)entry.getValue();
            EnumSet enumSet2 = (EnumSet)CollectionsKt.firstOrNull((Iterable)srcFiles.values());
            if (enumSet2 != null && (enumSet2 = (DirtyFileState)CollectionsKt.singleOrNull((Iterable)enumSet2)) != null) {
                boolean bl;
                EnumSet enumSet3;
                block20: {
                    EnumSet singleState = enumSet2;
                    boolean bl2 = false;
                    EnumSet it2 = enumSet3 = singleState;
                    boolean bl3 = false;
                    Iterable $this$all$iv = srcFiles.values();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            it = (EnumSet)element$iv;
                            boolean bl4 = false;
                            if (CollectionsKt.singleOrNull((Iterable)it) == singleState) continue;
                            bl = false;
                            break block20;
                        }
                        bl = true;
                    }
                }
                enumSet = bl ? enumSet3 : null;
            } else {
                enumSet = null;
            }
            EnumSet singleState = enumSet;
            if (singleState == DirtyFileState.NON_MODIFIED_IR) continue;
            if (singleState == DirtyFileState.REMOVED_FILE) {
                pair = TuplesKt.to((Object)"removed", (Object)MapsKt.emptyMap());
            } else if (singleState == DirtyFileState.ADDED_FILE) {
                pair = TuplesKt.to((Object)"built clean", (Object)MapsKt.emptyMap());
            } else {
                boolean bl;
                block21: {
                    Iterable $this$any$iv = srcFiles.values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            EnumSet enumSet4 = (EnumSet)element$iv;
                            boolean bl5 = false;
                            if (!(CollectionsKt.singleOrNull((Iterable)enumSet4) == DirtyFileState.NON_MODIFIED_IR)) continue;
                            bl = true;
                            break block21;
                        }
                        bl = false;
                    }
                }
                pair = bl ? TuplesKt.to((Object)"partially rebuilt", (Object)srcFiles) : TuplesKt.to((Object)"fully rebuilt", (Object)srcFiles);
            }
            Pair pair2 = pair;
            String msg = (String)pair2.component1();
            Map showFiles = (Map)pair2.component2();
            MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, ++libIndex + ") module [" + new File(libFile).getName() + "] was " + msg, null, 4, null);
            int fileIndex = 0;
            for (Map.Entry entry2 : showFiles.entrySet()) {
                List filteredStats;
                void $this$filterTo$iv$iv;
                Object element$iv;
                KotlinSourceFile srcFile = (KotlinSourceFile)entry2.getKey();
                EnumSet stat = (EnumSet)entry2.getValue();
                Iterable $this$filter$iv = stat;
                boolean $i$f$filter = false;
                element$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    DirtyFileState it4 = (DirtyFileState)element$iv$iv;
                    boolean bl = false;
                    if (!(it4 != DirtyFileState.NON_MODIFIED_IR)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = filteredStats = (List)destination$iv$iv;
                it = list;
                boolean bl = false;
                List list2 = !((Collection)it).isEmpty() ? list : null;
                if (list2 == null || (list2 = CollectionsKt.joinToString$default((Iterable)list2, null, null, null, (int)0, null, IcCachesKt::prepareIcCaches$lambda$6, (int)31, null)) == null) continue;
                List statStr = list2;
                MessageCollector.report$default(messageCollector2, CompilerMessageSeverity.INFO, "  " + libIndex + '.' + ++fileIndex + ") file [" + new File(srcFile.getPath()).getName() + "]: (" + (String)((Object)statStr) + ')', null, 4, null);
            }
        }
        return new IcCachesArtifacts(artifacts);
    }

    private static final CharSequence prepareIcCaches$lambda$6(DirtyFileState it) {
        return it.getStr();
    }
}

