/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm.compiler;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.jvm.index.JavaRoot;
import org.jetbrains.kotlin.cli.jvm.index.JvmDependenciesIndex;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.builtins.BuiltInSerializerProtocol;
import org.jetbrains.kotlin.util.PerformanceManager;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0012\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0017\u0010\u0010\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0018H\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J(\u0010\u001c\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0015H\u0002J\u001f\u0010 \u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00112\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020\u0016H\u0002J-\u0010#\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00112\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u00162\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0015H\u0002J\u0017\u0010#\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010$\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder;", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "index", "Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "enableSearchInCtSym", "", "perfManager", "Lorg/jetbrains/kotlin/util/PerformanceManager;", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/index/JvmDependenciesIndex;Lcom/intellij/psi/search/GlobalSearchScope;ZLorg/jetbrains/kotlin/util/PerformanceManager;)V", "findVirtualFileWithHeader", "Lcom/intellij/openapi/vfs/VirtualFile;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "findSourceOrBinaryVirtualFile", "Lorg/jetbrains/annotations/Nullable;", "findMetadata", "Ljava/io/InputStream;", "findMetadataTopLevelClassesInPackage", "", "", "packageFqName", "Lorg/jetbrains/kotlin/name/FqName;", "hasMetadataPackage", "fqName", "findBuiltInsData", "findClass", "fileName", "rootType", "Lorg/jetbrains/kotlin/cli/jvm/index/JavaRoot$RootType;", "findSigFileIfEnabled", "dir", "simpleName", "findBinaryOrSigClass", "findBinaryClass", "findSourceClass", "cli-base"})
@SourceDebugExtension(value={"SMAP\nCliVirtualFileFinder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CliVirtualFileFinder.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,99:1\n1#2:100\n295#3,2:101\n295#3,2:103\n12637#4,2:105\n*S KotlinDebug\n*F\n+ 1 CliVirtualFileFinder.kt\norg/jetbrains/kotlin/cli/jvm/compiler/CliVirtualFileFinder\n*L\n80#1:101,2\n91#1:103,2\n63#1:105,2\n*E\n"})
public final class CliVirtualFileFinder
extends VirtualFileFinder {
    @NotNull
    private final JvmDependenciesIndex index;
    @NotNull
    private final GlobalSearchScope scope;
    private final boolean enableSearchInCtSym;

    public CliVirtualFileFinder(@NotNull JvmDependenciesIndex index2, @NotNull GlobalSearchScope scope2, boolean enableSearchInCtSym, @Nullable PerformanceManager perfManager) {
        Intrinsics.checkNotNullParameter((Object)index2, (String)"index");
        Intrinsics.checkNotNullParameter((Object)scope2, (String)"scope");
        super(perfManager);
        this.index = index2;
        this.scope = scope2;
        this.enableSearchInCtSym = enableSearchInCtSym;
    }

    @Override
    @Nullable
    public VirtualFile findVirtualFileWithHeader(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return this.findBinaryOrSigClass(classId);
    }

    @Override
    @Nullable
    public VirtualFile findSourceOrBinaryVirtualFile(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        VirtualFile virtualFile = this.findBinaryOrSigClass(classId);
        if (virtualFile == null) {
            virtualFile = this.findSourceClass(classId, classId.getRelativeClassName().asString() + ".java");
        }
        return virtualFile;
    }

    @Override
    @Nullable
    public InputStream findMetadata(@NotNull ClassId classId) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        boolean bl2 = bl = !classId.isNestedClass();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Nested classes are not supported here: " + classId;
            throw new AssertionError((Object)string);
        }
        VirtualFile virtualFile = this.findBinaryClass(classId, classId.getShortClassName().asString() + ".kotlin_metadata");
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    @Override
    @NotNull
    public Set<String> findMetadataTopLevelClassesInPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        ObjectOpenHashSet result2 = new ObjectOpenHashSet();
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(this.index, packageFqName, null, (arg_0, arg_1) -> CliVirtualFileFinder.findMetadataTopLevelClassesInPackage$lambda$1(result2, arg_0, arg_1), 2, null);
        return (Set)result2;
    }

    @Override
    public boolean hasMetadataPackage(@NotNull FqName fqName) {
        Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
        Ref.BooleanRef found = new Ref.BooleanRef();
        JvmDependenciesIndex.traverseDirectoriesInPackage$default(this.index, fqName, null, (arg_0, arg_1) -> CliVirtualFileFinder.hasMetadataPackage$lambda$3(found, arg_0, arg_1), 2, null);
        return found.element;
    }

    @Override
    @Nullable
    public InputStream findBuiltInsData(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter((Object)packageFqName, (String)"packageFqName");
        Name name2 = Name.special("<builtins-metadata>");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"special(...)");
        ClassId classId = new ClassId(packageFqName, name2);
        VirtualFile virtualFile = this.findBinaryClass(classId, BuiltInSerializerProtocol.INSTANCE.getBuiltInsFileName(packageFqName));
        return virtualFile != null ? virtualFile.getInputStream() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile findClass(ClassId classId, String fileName, Set<? extends JavaRoot.RootType> rootType) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Iterable iterable = this.index.findClasses(classId, rootType, (arg_0, arg_1) -> CliVirtualFileFinder.findClass$lambda$4(fileName, arg_0, arg_1));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!this.scope.contains(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final VirtualFile findSigFileIfEnabled(VirtualFile dir2, String simpleName) {
        return this.enableSearchInCtSym ? dir2.findChild(simpleName + ".sig") : null;
    }

    /*
     * WARNING - void declaration
     */
    private final VirtualFile findBinaryOrSigClass(ClassId classId, String simpleName, Set<? extends JavaRoot.RootType> rootType) {
        Object v0;
        block1: {
            void $this$firstOrNull$iv;
            Iterable iterable = this.index.findClasses(classId, rootType, (arg_0, arg_1) -> CliVirtualFileFinder.findBinaryOrSigClass$lambda$6(simpleName, this, arg_0, arg_1));
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl = false;
                if (!this.scope.contains(it)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final VirtualFile findBinaryOrSigClass(ClassId classId) {
        return this.findBinaryOrSigClass(classId, StringsKt.replace$default((String)classId.getRelativeClassName().asString(), (char)'.', (char)'$', (boolean)false, (int)4, null), JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findBinaryClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlyBinary());
    }

    private final VirtualFile findSourceClass(ClassId classId, String fileName) {
        return this.findClass(classId, fileName, JavaRoot.RootTypes.getOnlySource());
    }

    private static final boolean findMetadataTopLevelClassesInPackage$lambda$1(ObjectOpenHashSet $result, VirtualFile dir2, JavaRoot.RootType rootType) {
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<unused var>");
        Iterator iterator2 = ArrayIteratorKt.iterator((Object[])dir2.getChildren());
        while (iterator2.hasNext()) {
            VirtualFile child = (VirtualFile)iterator2.next();
            if (!Intrinsics.areEqual((Object)child.getExtension(), (Object)"kotlin_metadata")) continue;
            $result.add((Object)child.getNameWithoutExtension());
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean hasMetadataPackage$lambda$3(Ref.BooleanRef $found, VirtualFile dir2, JavaRoot.RootType rootType) {
        boolean bl;
        boolean bl2;
        block1: {
            void $this$any$iv;
            Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
            Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<unused var>");
            boolean bl3 = $found.element;
            VirtualFile[] virtualFileArray = dir2.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getChildren(...)");
            Object[] objectArray = virtualFileArray;
            bl2 = bl3;
            Ref.BooleanRef booleanRef = $found;
            boolean $i$f$any = false;
            for (void element$iv : $this$any$iv) {
                VirtualFile it = (VirtualFile)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getExtension(), (Object)"kotlin_metadata")) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        boolean bl5 = bl;
        booleanRef.element = bl2 | bl5;
        return !$found.element;
    }

    private static final VirtualFile findClass$lambda$4(String $fileName, VirtualFile dir2, JavaRoot.RootType rootType) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<unused var>");
        VirtualFile virtualFile = dir2.findChild($fileName);
        if (virtualFile != null) {
            VirtualFile virtualFile2;
            VirtualFile p0 = virtualFile2 = virtualFile;
            boolean bl = false;
            object = p0.isValid() ? virtualFile2 : null;
        } else {
            object = null;
        }
        return object;
    }

    private static final VirtualFile findBinaryOrSigClass$lambda$6(String $simpleName, CliVirtualFileFinder this$0, VirtualFile dir2, JavaRoot.RootType rootType) {
        VirtualFile file;
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)((Object)rootType), (String)"<unused var>");
        VirtualFile virtualFile = dir2.findChild($simpleName + ".class");
        if (virtualFile == null) {
            virtualFile = this$0.findSigFileIfEnabled(dir2, $simpleName);
        }
        return (file = virtualFile) != null && file.isValid() ? file : null;
    }
}

