/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.TypeUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntersectionType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ProjectionKind;
import org.jetbrains.kotlin.utils.DFS;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0002H\u0016R\u00020\bR\u00020\nj\u0006\u0010\t\u001a\u00020\bj\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ*\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000f2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J*\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00102\u0018\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u00110\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFiniteBoundRestrictionChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "<init>", "()V", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "buildTypeEdges", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "isInCycle", "", "start", "edges", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirFiniteBoundRestrictionChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirFiniteBoundRestrictionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFiniteBoundRestrictionChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt\n+ 5 ConeTypeUtils.kt\norg/jetbrains/kotlin/fir/types/ConeTypeUtilsKt$forEachType$1\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,118:1\n865#2,2:119\n1625#2:121\n1869#2:122\n1870#2:124\n1626#2:125\n1563#2:126\n1634#2,3:127\n1761#2,3:130\n1869#2,2:133\n1869#2,2:160\n1#3:123\n71#4,8:135\n79#4,13:144\n94#4:159\n72#5:143\n13472#6,2:157\n382#7,7:162\n382#7,7:169\n*S KotlinDebug\n*F\n+ 1 FirFiniteBoundRestrictionChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFiniteBoundRestrictionChecker\n*L\n43#1:119,2\n53#1:121\n53#1:122\n53#1:124\n53#1:125\n55#1:126\n55#1:127,3\n56#1:130,3\n89#1:133,2\n75#1:160,2\n53#1:123\n67#1:135,8\n67#1:144,13\n67#1:159\n67#1:143\n67#1:157,2\n82#1:162,7\n83#1:169,7\n*E\n"})
public final class FirFiniteBoundRestrictionChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirFiniteBoundRestrictionChecker INSTANCE = new FirFiniteBoundRestrictionChecker();

    private FirFiniteBoundRestrictionChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirRegularClass declaration) {
        boolean bl;
        List list;
        block10: {
            void $this$mapTo$iv$iv;
            void destination$iv;
            Iterator<FirTypeParameterRef> $this$filterTo$iv;
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            if (declaration.getTypeParameters().isEmpty()) {
                return;
            }
            Map<ConeKotlinType, Set<ConeKotlinType>> edges = this.buildTypeEdges(declaration, context2.getSession());
            Iterable iterable = edges.keySet();
            Collection collection = new LinkedHashSet();
            boolean $i$f$filterTo232 = false;
            Iterator iterator2 = $this$filterTo$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl2 = false;
                if (!INSTANCE.isInCycle(it, edges)) continue;
                collection.add(element$iv);
            }
            Set problemNodes = (Set)collection;
            if (problemNodes.isEmpty()) {
                return;
            }
            for (FirTypeParameterRef firTypeParameterRef : declaration.getTypeParameters()) {
                if (!problemNodes.remove(FirNestedClassifierScopeKt.toConeType(firTypeParameterRef))) continue;
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)firTypeParameterRef.getSource(), FirErrors.INSTANCE.getFINITE_BOUNDS_VIOLATION(), null, 8, null);
                return;
            }
            Iterable iterable2 = problemNodes;
            Collection $i$f$filterTo232 = new LinkedHashSet();
            boolean $i$f$mapNotNullTo = false;
            Iterable $this$forEach$iv$iv = iterable2;
            boolean $i$f$forEach = false;
            for (Object element$iv$iv : $this$forEach$iv$iv) {
                FirTypeParameterSymbol it$iv;
                Object element$iv = element$iv$iv;
                boolean bl3 = false;
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl4 = false;
                if (ToSymbolUtilsKt.toTypeParameterSymbol(it, context2.getSession()) == null) continue;
                boolean bl5 = false;
                destination$iv.add(it$iv);
            }
            Set problemSymbols = (Set)destination$iv;
            Iterable $this$map$iv = problemSymbols;
            boolean $i$f$map = false;
            $this$forEach$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeParameterSymbol bl3 = (FirTypeParameterSymbol)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl6 = false;
                collection2.add(it.getContainingDeclarationSymbol());
            }
            list = (List)destination$iv$iv;
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FirBasedSymbol it = (FirBasedSymbol)element$iv;
                    boolean bl7 = false;
                    if (!(!(it.getOrigin() instanceof FirDeclarationOrigin.Java))) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getFINITE_BOUNDS_VIOLATION_IN_JAVA(), (Object)list, null, 16, null);
    }

    private final Map<ConeKotlinType, Set<ConeKotlinType>> buildTypeEdges(FirRegularClass declaration, FirSession session2) {
        Map edges = new LinkedHashMap();
        Set visitedSymbols = new LinkedHashSet();
        Iterable $this$forEach$iv = declaration.getTypeParameters();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
            boolean bl = false;
            FirFiniteBoundRestrictionChecker.buildTypeEdges$visit(session2, visitedSymbols, edges, FirNestedClassifierScopeKt.toConeType(it));
        }
        return edges;
    }

    private final boolean isInCycle(ConeKotlinType start, Map<ConeKotlinType, ? extends Set<? extends ConeKotlinType>> edges) {
        Ref.BooleanRef containsCycle = new Ref.BooleanRef();
        DFS.Neighbors<ConeKotlinType> dfsNeighbors = arg_0 -> FirFiniteBoundRestrictionChecker.isInCycle$lambda$9(edges, arg_0);
        DFS.VisitedWithSet<ConeKotlinType> dfsVisited2 = new DFS.VisitedWithSet<ConeKotlinType>(start, containsCycle){
            final /* synthetic */ ConeKotlinType $start;
            final /* synthetic */ Ref.BooleanRef $containsCycle;
            {
                this.$start = $start;
                this.$containsCycle = $containsCycle;
            }

            public boolean checkAndMarkVisited(ConeKotlinType current) {
                Intrinsics.checkNotNullParameter((Object)current, (String)"current");
                boolean added = super.checkAndMarkVisited(current);
                if (!added && Intrinsics.areEqual((Object)current, (Object)this.$start)) {
                    this.$containsCycle.element = true;
                }
                return added;
            }
        };
        DFS.AbstractNodeHandler<ConeKotlinType, Unit> dfsHandler2 = new DFS.AbstractNodeHandler<ConeKotlinType, Unit>(){

            public void result() {
            }
        };
        DFS.dfs(CollectionsKt.listOf((Object)start), dfsNeighbors, dfsVisited2, dfsHandler2);
        return containsCycle.element;
    }

    private static final void buildTypeEdges$visit(FirSession $session, Set<FirClassifierSymbol<?>> visitedSymbols, Map<ConeKotlinType, Set<ConeKotlinType>> edges, ConeKotlinType coneType) {
        Set constituentTypes = new LinkedHashSet();
        for (ConeClassLikeType coneClassLikeType : TypeUtilsKt.collectUpperBounds(coneType)) {
            ConeKotlinType $this$forEachType_u24default$iv = coneClassLikeType;
            boolean $i$f$forEachType = false;
            Object[] n = new ConeKotlinType[]{$this$forEachType_u24default$iv};
            List stack$iv = CollectionsKt.mutableListOf((Object[])n);
            while (!((Collection)stack$iv).isEmpty()) {
                ConeKotlinType it;
                ConeKotlinType next$iv;
                Object e = AddToStdlibKt.popLast(stack$iv);
                boolean bl = false;
                it = next$iv = (it = (ConeKotlinType)e);
                boolean bl2 = false;
                constituentTypes.add(it);
                ConeKotlinType coneKotlinType = next$iv;
                if (coneKotlinType instanceof ConeFlexibleType) {
                    stack$iv.add(((ConeFlexibleType)next$iv).getLowerBound());
                    if (((ConeFlexibleType)next$iv).isTrivial()) continue;
                    stack$iv.add(((ConeFlexibleType)next$iv).getUpperBound());
                    continue;
                }
                if (coneKotlinType instanceof ConeDefinitelyNotNullType) {
                    stack$iv.add(((ConeDefinitelyNotNullType)next$iv).getOriginal());
                    continue;
                }
                if (coneKotlinType instanceof ConeIntersectionType) {
                    stack$iv.addAll(((ConeIntersectionType)next$iv).getIntersectedTypes());
                    continue;
                }
                ConeTypeProjection[] $this$forEach$iv$iv = next$iv.getTypeArguments();
                boolean $i$f$forEach = false;
                int n2 = $this$forEach$iv$iv.length;
                for (int j = 0; j < n2; ++j) {
                    ConeTypeProjection element$iv$iv;
                    ConeTypeProjection it$iv = element$iv$iv = $this$forEach$iv$iv[j];
                    boolean bl3 = false;
                    if (!(it$iv instanceof ConeKotlinTypeProjection)) continue;
                    stack$iv.add(((ConeKotlinTypeProjection)it$iv).getType());
                }
            }
        }
        for (ConeKotlinType coneKotlinType : constituentTypes) {
            FirClassifierSymbol<?> symbol = ToSymbolUtilsKt.toSymbol(coneKotlinType, $session);
            FirClassifierSymbol<?> firClassifierSymbol = symbol;
            if (firClassifierSymbol == null || (firClassifierSymbol = FirHelpersKt.getTypeParameterSymbols((FirBasedSymbol)firClassifierSymbol)) == null) continue;
            FirClassifierSymbol<?> parameters = firClassifierSymbol;
            if (visitedSymbols.add(symbol)) {
                Iterable $this$forEach$iv = (Iterable)((Object)parameters);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    FirTypeParameterSymbol it = (FirTypeParameterSymbol)element$iv;
                    boolean bl = false;
                    FirFiniteBoundRestrictionChecker.buildTypeEdges$visit($session, visitedSymbols, edges, FirNestedClassifierScopeKt.toConeType(it));
                }
            }
            if (parameters.size() != coneKotlinType.getTypeArguments().length) continue;
            int n = ((Collection)((Object)parameters)).size();
            for (int i2 = 0; i2 < n; ++i2) {
                Set set;
                Set answer$iv;
                if (coneKotlinType.getTypeArguments()[i2].getKind() == ProjectionKind.INVARIANT) continue;
                ConeTypeParameterType parameter = FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)parameters.get(i2));
                Map<ConeKotlinType, Set<ConeKotlinType>> $this$getOrPut$iv = edges;
                boolean $i$f$getOrPut = false;
                Set value$iv = $this$getOrPut$iv.get(coneType);
                if (value$iv == null) {
                    boolean bl = false;
                    answer$iv = new LinkedHashSet();
                    $this$getOrPut$iv.put(coneType, answer$iv);
                    set = answer$iv;
                } else {
                    set = value$iv;
                }
                set.add((ConeKotlinType)parameter);
                $this$getOrPut$iv = edges;
                $i$f$getOrPut = false;
                value$iv = $this$getOrPut$iv.get(parameter);
                if (value$iv != null) continue;
                boolean bl = false;
                answer$iv = new LinkedHashSet();
                $this$getOrPut$iv.put(parameter, answer$iv);
            }
        }
    }

    private static final Iterable isInCycle$lambda$9(Map $edges, ConeKotlinType it) {
        Set set = (Set)$edges.get(it);
        return set != null ? (Iterable)set : (Iterable)CollectionsKt.emptyList();
    }
}

