/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.backend.jvm.lower;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.common.FileLoweringPass;
import org.jetbrains.kotlin.backend.common.IrElementTransformerVoidWithContext;
import org.jetbrains.kotlin.backend.common.ScopeWithIr;
import org.jetbrains.kotlin.backend.common.phaser.PhaseDescription;
import org.jetbrains.kotlin.backend.jvm.JvmBackendContext;
import org.jetbrains.kotlin.backend.jvm.ir.IrArrayBuilderKt;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrBuilderKt;
import org.jetbrains.kotlin.backend.jvm.lower.VarargLoweringKt;
import org.jetbrains.kotlin.backend.jvm.mapping.IrTypeMapper;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.impl.BuildersKt;
import org.jetbrains.kotlin.ir.expressions.impl.IrCallImpl;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.DumpIrTreeKt;
import org.jetbrains.kotlin.ir.util.RenderIrElementKt;
import org.jetbrains.kotlin.ir.visitors.IrTransformer;
import org.jetbrains.org.objectweb.asm.Type;

@PhaseDescription(name="JvmBuiltInsLowering")
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0010H\u0002J\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u0012*\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R&\u0010\f\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltInsLowering;", "Lorg/jetbrains/kotlin/backend/common/FileLoweringPass;", "context", "Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;)V", "getContext", "()Lorg/jetbrains/kotlin/backend/jvm/JvmBackendContext;", "lower", "", "irFile", "Lorg/jetbrains/kotlin/ir/declarations/IrFile;", "jvm8builtInReplacements", "", "Lkotlin/Pair;", "", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "replaceWithCallTo", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "replacement", "coerceIfPossible", "toType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "backend.jvm.lower"})
@SourceDebugExtension(value={"SMAP\nJvmBuiltInsLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmBuiltInsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltInsLowering\n+ 2 addToStdlib.kt\norg/jetbrains/kotlin/utils/addToStdlib/AddToStdlibKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,118:1\n406#2,2:119\n408#2:124\n1634#3,3:121\n*S KotlinDebug\n*F\n+ 1 JvmBuiltInsLowering.kt\norg/jetbrains/kotlin/backend/jvm/lower/JvmBuiltInsLowering\n*L\n89#1:119,2\n89#1:124\n89#1:121,3\n*E\n"})
public final class JvmBuiltInsLowering
implements FileLoweringPass {
    @NotNull
    private final JvmBackendContext context;
    @NotNull
    private final Map<Pair<String, String>, IrSimpleFunctionSymbol> jvm8builtInReplacements;

    public JvmBuiltInsLowering(@NotNull JvmBackendContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        this.context = context2;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"compareTo"), (Object)this.context.getSymbols().getCompareUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"div"), (Object)this.context.getSymbols().getDivideUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"rem"), (Object)this.context.getSymbols().getRemainderUnsignedInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.UInt", (Object)"toString"), (Object)this.context.getSymbols().getToUnsignedStringInt()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"compareTo"), (Object)this.context.getSymbols().getCompareUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"div"), (Object)this.context.getSymbols().getDivideUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"rem"), (Object)this.context.getSymbols().getRemainderUnsignedLong()), TuplesKt.to((Object)TuplesKt.to((Object)"kotlin.ULong", (Object)"toString"), (Object)this.context.getSymbols().getToUnsignedStringLong())};
        this.jvm8builtInReplacements = MapsKt.mapOf((Pair[])pairArray);
    }

    @NotNull
    public final JvmBackendContext getContext() {
        return this.context;
    }

    public void lower(@NotNull IrFile irFile) {
        Intrinsics.checkNotNullParameter((Object)irFile, (String)"irFile");
        IrElementTransformerVoidWithContext transformer2 = new IrElementTransformerVoidWithContext(this){
            final /* synthetic */ JvmBuiltInsLowering this$0;
            {
                this.this$0 = $receiver;
            }

            public IrExpression visitCall(IrCall expression2) {
                IrExpression irExpression;
                IrSimpleFunctionSymbol jvm8Replacement;
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                expression2.transformChildren((IrTransformer)((Object)this), null);
                IrSimpleFunction callee = (IrSimpleFunction)expression2.getSymbol().getOwner();
                String parentClassName = AdditionalIrUtilsKt.getFqNameForIrSerialization(callee.getParent()).asString();
                String string = callee.getName().asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
                String functionName = string;
                if (Intrinsics.areEqual((Object)parentClassName, (Object)"kotlin.CompareToKt") && Intrinsics.areEqual((Object)functionName, (Object)"compareTo")) {
                    E e = expression2.getArguments().get(0);
                    Intrinsics.checkNotNull(e);
                    IrType operandType = ((IrExpression)e).getType();
                    if (IrTypePredicatesKt.isUInt(operandType)) {
                        return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, this.this$0.getContext().getSymbols().getCompareUnsignedInt());
                    }
                    if (IrTypePredicatesKt.isULong(operandType)) {
                        return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, this.this$0.getContext().getSymbols().getCompareUnsignedLong());
                    }
                }
                if ((jvm8Replacement = (IrSimpleFunctionSymbol)JvmBuiltInsLowering.access$getJvm8builtInReplacements$p(this.this$0).get(TuplesKt.to((Object)parentClassName, (Object)functionName))) != null) {
                    return JvmBuiltInsLowering.access$replaceWithCallTo(this.this$0, expression2, jvm8Replacement);
                }
                if (VarargLoweringKt.isArrayOf(callee)) {
                    irExpression = (IrExpression)expression2.getArguments().get(0);
                    if (irExpression == null) {
                        throw new AssertionError((Object)("Argument #0 expected: " + DumpIrTreeKt.dump$default(expression2, null, 1, null)));
                    }
                } else if (VarargLoweringKt.isEmptyArray(callee)) {
                    JvmBackendContext jvmBackendContext = this.this$0.getContext();
                    ScopeWithIr scopeWithIr = this.getCurrentScope();
                    Intrinsics.checkNotNull((Object)scopeWithIr);
                    irExpression = IrArrayBuilderKt.irArrayOf$default(JvmIrBuilderKt.createJvmIrBuilder(jvmBackendContext, scopeWithIr, (IrElement)expression2), expression2.getType(), null, 2, null);
                } else {
                    irExpression = expression2;
                }
                return irExpression;
            }
        };
        irFile.transformChildren((IrTransformer)transformer2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final IrExpression replaceWithCallTo(IrCall $this$replaceWithCallTo, IrSimpleFunctionSymbol replacement) {
        IrExpression irExpression;
        void $this$mapTo$iv$iv;
        void $this$assignFrom$iv;
        IrCallImpl irCallImpl;
        IrType expectedType = $this$replaceWithCallTo.getType();
        IrType intrinsicCallType = ((IrSimpleFunction)replacement.getOwner()).getReturnType();
        IrCallImpl newCall = irCallImpl = BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, $this$replaceWithCallTo.getStartOffset(), $this$replaceWithCallTo.getEndOffset(), intrinsicCallType, replacement, null, null, 48, null);
        boolean bl = false;
        List list = newCall.getArguments();
        Iterable other$iv = CollectionsKt.zip((Iterable)((IrSimpleFunction)replacement.getOwner()).getParameters(), (Iterable)$this$replaceWithCallTo.getArguments());
        boolean $i$f$assignFrom = false;
        $this$assignFrom$iv.clear();
        Iterable iterable = other$iv;
        Collection destination$iv$iv = (Collection)$this$assignFrom$iv;
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            IrExpression argument;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            IrValueParameter parameter = (IrValueParameter)pair.component1();
            IrExpression irExpression2 = argument = (IrExpression)pair.component2();
            Intrinsics.checkNotNull((Object)irExpression2);
            IrExpression irExpression3 = this.coerceIfPossible(irExpression2, parameter.getType());
            if (irExpression3 == null) {
                return $this$replaceWithCallTo;
            }
            collection.add(irExpression3);
        }
        IrCallImpl intrinsicCall = irCallImpl;
        if (IrTypePredicatesKt.isInt(intrinsicCallType) || IrTypePredicatesKt.isLong(intrinsicCallType)) {
            irExpression = this.coerceIfPossible(intrinsicCall, expectedType);
            if (irExpression == null) {
                throw new AssertionError((Object)("Can't coerce '" + RenderIrElementKt.render$default(intrinsicCallType, null, 1, null) + "' to '" + RenderIrElementKt.render$default(expectedType, null, 1, null) + '\''));
            }
        } else {
            irExpression = intrinsicCall;
        }
        return irExpression;
    }

    private final IrExpression coerceIfPossible(IrExpression $this$coerceIfPossible, IrType toType) {
        IrExpression irExpression;
        Type toJvmType;
        Type fromJvmType = IrTypeMapper.mapType$default(this.context.getDefaultTypeMapper(), $this$coerceIfPossible.getType(), null, null, false, 14, null);
        if (!Intrinsics.areEqual((Object)fromJvmType, (Object)(toJvmType = IrTypeMapper.mapType$default(this.context.getDefaultTypeMapper(), toType, null, null, false, 14, null)))) {
            irExpression = null;
        } else {
            IrCallImpl irCallImpl;
            IrCallImpl call = irCallImpl = BuildersKt.fromSymbolOwner$default(IrCallImpl.Companion, $this$coerceIfPossible.getStartOffset(), $this$coerceIfPossible.getEndOffset(), toType, this.context.getSymbols().getUnsafeCoerceIntrinsic(), null, null, 48, null);
            boolean bl = false;
            call.getTypeArguments().set(0, $this$coerceIfPossible.getType());
            call.getTypeArguments().set(1, toType);
            call.getArguments().set(0, $this$coerceIfPossible);
            irExpression = irCallImpl;
        }
        return irExpression;
    }

    public static final /* synthetic */ IrExpression access$replaceWithCallTo(JvmBuiltInsLowering $this, IrCall $receiver, IrSimpleFunctionSymbol replacement) {
        return $this.replaceWithCallTo($receiver, replacement);
    }

    public static final /* synthetic */ Map access$getJvm8builtInReplacements$p(JvmBuiltInsLowering $this) {
        return $this.jvm8builtInReplacements;
    }
}

