/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.protobuf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.protobuf.ByteString;
import org.jetbrains.kotlin.protobuf.CodedInputStream;
import org.jetbrains.kotlin.protobuf.CodedOutputStream;
import org.jetbrains.kotlin.protobuf.Internal;
import org.jetbrains.kotlin.protobuf.LazyField;
import org.jetbrains.kotlin.protobuf.MessageLite;
import org.jetbrains.kotlin.protobuf.SmallSortedMap;
import org.jetbrains.kotlin.protobuf.WireFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FieldSet<FieldDescriptorType extends FieldDescriptorLite<FieldDescriptorType>> {
    private final SmallSortedMap<FieldDescriptorType, Object> fields;
    private boolean isImmutable;
    private boolean hasLazyField = false;
    private static final FieldSet DEFAULT_INSTANCE = new FieldSet(true);

    private FieldSet() {
        this.fields = SmallSortedMap.newFieldMap(16);
    }

    private FieldSet(boolean dummy) {
        this.fields = SmallSortedMap.newFieldMap(0);
        this.makeImmutable();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> newFieldSet() {
        return new FieldSet();
    }

    public static <T extends FieldDescriptorLite<T>> FieldSet<T> emptySet() {
        return DEFAULT_INSTANCE;
    }

    public void makeImmutable() {
        if (this.isImmutable) {
            return;
        }
        this.fields.makeImmutable();
        this.isImmutable = true;
    }

    public boolean isImmutable() {
        return this.isImmutable;
    }

    public FieldSet<FieldDescriptorType> clone() {
        FieldDescriptorLite descriptor;
        FieldSet clone2 = FieldSet.newFieldSet();
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            descriptor = (FieldDescriptorLite)entry.getKey();
            clone2.setField(descriptor, entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            descriptor = (FieldDescriptorLite)entry.getKey();
            clone2.setField(descriptor, entry.getValue());
        }
        clone2.hasLazyField = this.hasLazyField;
        return clone2;
    }

    public void clear() {
        this.fields.clear();
        this.hasLazyField = false;
    }

    public Map<FieldDescriptorType, Object> getAllFields() {
        if (this.hasLazyField) {
            SmallSortedMap result2 = SmallSortedMap.newFieldMap(16);
            for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
                this.cloneFieldEntry(result2, this.fields.getArrayEntryAt(i2));
            }
            for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
                this.cloneFieldEntry(result2, entry);
            }
            if (this.fields.isImmutable()) {
                result2.makeImmutable();
            }
            return result2;
        }
        return this.fields.isImmutable() ? this.fields : Collections.unmodifiableMap(this.fields);
    }

    private void cloneFieldEntry(Map<FieldDescriptorType, Object> map, Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite key = (FieldDescriptorLite)entry.getKey();
        Object value2 = entry.getValue();
        if (value2 instanceof LazyField) {
            map.put(key, ((LazyField)value2).getValue());
        } else {
            map.put(key, value2);
        }
    }

    public Iterator<Map.Entry<FieldDescriptorType, Object>> iterator() {
        if (this.hasLazyField) {
            return new LazyField.LazyIterator(this.fields.entrySet().iterator());
        }
        return this.fields.entrySet().iterator();
    }

    public boolean hasField(FieldDescriptorType descriptor) {
        if (descriptor.isRepeated()) {
            throw new IllegalArgumentException("hasField() can only be called on non-repeated fields.");
        }
        return this.fields.get(descriptor) != null;
    }

    public Object getField(FieldDescriptorType descriptor) {
        Object o = this.fields.get(descriptor);
        if (o instanceof LazyField) {
            return ((LazyField)o).getValue();
        }
        return o;
    }

    public void setField(FieldDescriptorType descriptor, Object value2) {
        if (descriptor.isRepeated()) {
            if (!(value2 instanceof List)) {
                throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
            }
            ArrayList newList = new ArrayList();
            newList.addAll(value2);
            for (Object element : newList) {
                FieldSet.verifyType(descriptor.getLiteType(), element);
            }
            value2 = newList;
        } else {
            FieldSet.verifyType(descriptor.getLiteType(), value2);
        }
        if (value2 instanceof LazyField) {
            this.hasLazyField = true;
        }
        this.fields.put(descriptor, (Object)value2);
    }

    public void clearField(FieldDescriptorType descriptor) {
        this.fields.remove(descriptor);
        if (this.fields.isEmpty()) {
            this.hasLazyField = false;
        }
    }

    public int getRepeatedFieldCount(FieldDescriptorType descriptor) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value2 = this.getField(descriptor);
        if (value2 == null) {
            return 0;
        }
        return ((List)value2).size();
    }

    public Object getRepeatedField(FieldDescriptorType descriptor, int index2) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object value2 = this.getField(descriptor);
        if (value2 == null) {
            throw new IndexOutOfBoundsException();
        }
        return ((List)value2).get(index2);
    }

    public void setRepeatedField(FieldDescriptorType descriptor, int index2, Object value2) {
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("getRepeatedField() can only be called on repeated fields.");
        }
        Object list = this.getField(descriptor);
        if (list == null) {
            throw new IndexOutOfBoundsException();
        }
        FieldSet.verifyType(descriptor.getLiteType(), value2);
        ((List)list).set(index2, value2);
    }

    public void addRepeatedField(FieldDescriptorType descriptor, Object value2) {
        ArrayList<Object> list;
        if (!descriptor.isRepeated()) {
            throw new IllegalArgumentException("addRepeatedField() can only be called on repeated fields.");
        }
        FieldSet.verifyType(descriptor.getLiteType(), value2);
        Object existingValue = this.getField(descriptor);
        if (existingValue == null) {
            list = new ArrayList<Object>();
            this.fields.put(descriptor, (Object)list);
        } else {
            list = (ArrayList<Object>)existingValue;
        }
        list.add(value2);
    }

    private static void verifyType(WireFormat.FieldType type, Object value2) {
        if (value2 == null) {
            throw new NullPointerException();
        }
        boolean isValid = false;
        switch (type.getJavaType()) {
            case INT: {
                isValid = value2 instanceof Integer;
                break;
            }
            case LONG: {
                isValid = value2 instanceof Long;
                break;
            }
            case FLOAT: {
                isValid = value2 instanceof Float;
                break;
            }
            case DOUBLE: {
                isValid = value2 instanceof Double;
                break;
            }
            case BOOLEAN: {
                isValid = value2 instanceof Boolean;
                break;
            }
            case STRING: {
                isValid = value2 instanceof String;
                break;
            }
            case BYTE_STRING: {
                isValid = value2 instanceof ByteString || value2 instanceof byte[];
                break;
            }
            case ENUM: {
                isValid = value2 instanceof Integer || value2 instanceof Internal.EnumLite;
                break;
            }
            case MESSAGE: {
                boolean bl = isValid = value2 instanceof MessageLite || value2 instanceof LazyField;
            }
        }
        if (!isValid) {
            throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
        }
    }

    public boolean isInitialized() {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            if (this.isInitialized(this.fields.getArrayEntryAt(i2))) continue;
            return false;
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            if (this.isInitialized(entry)) continue;
            return false;
        }
        return true;
    }

    private boolean isInitialized(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            if (descriptor.isRepeated()) {
                for (MessageLite element : (List)entry.getValue()) {
                    if (element.isInitialized()) continue;
                    return false;
                }
            } else {
                Object value2 = entry.getValue();
                if (value2 instanceof MessageLite) {
                    if (!((MessageLite)value2).isInitialized()) {
                        return false;
                    }
                } else {
                    if (value2 instanceof LazyField) {
                        return true;
                    }
                    throw new IllegalArgumentException("Wrong object type used with protocol message reflection.");
                }
            }
        }
        return true;
    }

    static int getWireFormatForFieldType(WireFormat.FieldType type, boolean isPacked) {
        if (isPacked) {
            return 2;
        }
        return type.getWireType();
    }

    public void mergeFrom(FieldSet<FieldDescriptorType> other) {
        for (int i2 = 0; i2 < other.fields.getNumArrayEntries(); ++i2) {
            this.mergeFromField(other.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : other.fields.getOverflowEntries()) {
            this.mergeFromField(entry);
        }
    }

    private Object cloneIfMutable(Object value2) {
        if (value2 instanceof byte[]) {
            byte[] bytes = (byte[])value2;
            byte[] copy = new byte[bytes.length];
            System.arraycopy(bytes, 0, copy, 0, bytes.length);
            return copy;
        }
        return value2;
    }

    private void mergeFromField(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object otherValue = entry.getValue();
        if (otherValue instanceof LazyField) {
            otherValue = ((LazyField)otherValue).getValue();
        }
        if (descriptor.isRepeated()) {
            ArrayList value2 = this.getField(descriptor);
            if (value2 == null) {
                value2 = new ArrayList();
            }
            for (Object element : (List)otherValue) {
                ((List)value2).add(this.cloneIfMutable(element));
            }
            this.fields.put((FieldDescriptorType)descriptor, (Object)value2);
        } else if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE) {
            Object value3 = this.getField(descriptor);
            if (value3 == null) {
                this.fields.put((FieldDescriptorType)descriptor, this.cloneIfMutable(otherValue));
            } else {
                value3 = descriptor.internalMergeFrom(((MessageLite)value3).toBuilder(), (MessageLite)otherValue).build();
                this.fields.put((FieldDescriptorType)descriptor, value3);
            }
        } else {
            this.fields.put((FieldDescriptorType)descriptor, this.cloneIfMutable(otherValue));
        }
    }

    public static Object readPrimitiveField(CodedInputStream input, WireFormat.FieldType type, boolean checkUtf8) throws IOException {
        switch (type) {
            case DOUBLE: {
                return input.readDouble();
            }
            case FLOAT: {
                return Float.valueOf(input.readFloat());
            }
            case INT64: {
                return input.readInt64();
            }
            case UINT64: {
                return input.readUInt64();
            }
            case INT32: {
                return input.readInt32();
            }
            case FIXED64: {
                return input.readFixed64();
            }
            case FIXED32: {
                return input.readFixed32();
            }
            case BOOL: {
                return input.readBool();
            }
            case STRING: {
                if (checkUtf8) {
                    return input.readStringRequireUtf8();
                }
                return input.readString();
            }
            case BYTES: {
                return input.readBytes();
            }
            case UINT32: {
                return input.readUInt32();
            }
            case SFIXED32: {
                return input.readSFixed32();
            }
            case SFIXED64: {
                return input.readSFixed64();
            }
            case SINT32: {
                return input.readSInt32();
            }
            case SINT64: {
                return input.readSInt64();
            }
            case GROUP: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle nested groups.");
            }
            case MESSAGE: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle embedded messages.");
            }
            case ENUM: {
                throw new IllegalArgumentException("readPrimitiveField() cannot handle enums.");
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public void writeTo(CodedOutputStream output2) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output2);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            FieldSet.writeField((FieldDescriptorLite)entry.getKey(), entry.getValue(), output2);
        }
    }

    public void writeMessageSetTo(CodedOutputStream output2) throws IOException {
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            this.writeMessageSetTo(this.fields.getArrayEntryAt(i2), output2);
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            this.writeMessageSetTo(entry, output2);
        }
    }

    private void writeMessageSetTo(Map.Entry<FieldDescriptorType, Object> entry, CodedOutputStream output2) throws IOException {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            Object value2 = entry.getValue();
            if (value2 instanceof LazyField) {
                value2 = ((LazyField)value2).getValue();
            }
            output2.writeMessageSetExtension(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value2);
        } else {
            FieldSet.writeField(descriptor, entry.getValue(), output2);
        }
    }

    private static void writeElement(CodedOutputStream output2, WireFormat.FieldType type, int number, Object value2) throws IOException {
        if (type == WireFormat.FieldType.GROUP) {
            output2.writeGroup(number, (MessageLite)value2);
        } else {
            output2.writeTag(number, FieldSet.getWireFormatForFieldType(type, false));
            FieldSet.writeElementNoTag(output2, type, value2);
        }
    }

    private static void writeElementNoTag(CodedOutputStream output2, WireFormat.FieldType type, Object value2) throws IOException {
        switch (type) {
            case DOUBLE: {
                output2.writeDoubleNoTag((Double)value2);
                break;
            }
            case FLOAT: {
                output2.writeFloatNoTag(((Float)value2).floatValue());
                break;
            }
            case INT64: {
                output2.writeInt64NoTag((Long)value2);
                break;
            }
            case UINT64: {
                output2.writeUInt64NoTag((Long)value2);
                break;
            }
            case INT32: {
                output2.writeInt32NoTag((Integer)value2);
                break;
            }
            case FIXED64: {
                output2.writeFixed64NoTag((Long)value2);
                break;
            }
            case FIXED32: {
                output2.writeFixed32NoTag((Integer)value2);
                break;
            }
            case BOOL: {
                output2.writeBoolNoTag((Boolean)value2);
                break;
            }
            case STRING: {
                output2.writeStringNoTag((String)value2);
                break;
            }
            case GROUP: {
                output2.writeGroupNoTag((MessageLite)value2);
                break;
            }
            case MESSAGE: {
                output2.writeMessageNoTag((MessageLite)value2);
                break;
            }
            case BYTES: {
                if (value2 instanceof ByteString) {
                    output2.writeBytesNoTag((ByteString)value2);
                    break;
                }
                output2.writeByteArrayNoTag((byte[])value2);
                break;
            }
            case UINT32: {
                output2.writeUInt32NoTag((Integer)value2);
                break;
            }
            case SFIXED32: {
                output2.writeSFixed32NoTag((Integer)value2);
                break;
            }
            case SFIXED64: {
                output2.writeSFixed64NoTag((Long)value2);
                break;
            }
            case SINT32: {
                output2.writeSInt32NoTag((Integer)value2);
                break;
            }
            case SINT64: {
                output2.writeSInt64NoTag((Long)value2);
                break;
            }
            case ENUM: {
                if (value2 instanceof Internal.EnumLite) {
                    output2.writeEnumNoTag(((Internal.EnumLite)value2).getNumber());
                    break;
                }
                output2.writeEnumNoTag((Integer)value2);
            }
        }
    }

    public static void writeField(FieldDescriptorLite<?> descriptor, Object value2, CodedOutputStream output2) throws IOException {
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            List valueList = (List)value2;
            if (descriptor.isPacked()) {
                output2.writeTag(number, 2);
                int dataSize = 0;
                for (Object element : valueList) {
                    dataSize += FieldSet.computeElementSizeNoTag(type, element);
                }
                output2.writeRawVarint32(dataSize);
                for (Object element : valueList) {
                    FieldSet.writeElementNoTag(output2, type, element);
                }
            } else {
                for (Object element : valueList) {
                    FieldSet.writeElement(output2, type, number, element);
                }
            }
        } else if (value2 instanceof LazyField) {
            FieldSet.writeElement(output2, type, number, ((LazyField)value2).getValue());
        } else {
            FieldSet.writeElement(output2, type, number, value2);
        }
    }

    public int getSerializedSize() {
        int size = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            Map.Entry<FieldDescriptorType, Object> entry = this.fields.getArrayEntryAt(i2);
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            size += FieldSet.computeFieldSize((FieldDescriptorLite)entry.getKey(), entry.getValue());
        }
        return size;
    }

    public int getMessageSetSerializedSize() {
        int size = 0;
        for (int i2 = 0; i2 < this.fields.getNumArrayEntries(); ++i2) {
            size += this.getMessageSetSerializedSize(this.fields.getArrayEntryAt(i2));
        }
        for (Map.Entry<FieldDescriptorType, Object> entry : this.fields.getOverflowEntries()) {
            size += this.getMessageSetSerializedSize(entry);
        }
        return size;
    }

    private int getMessageSetSerializedSize(Map.Entry<FieldDescriptorType, Object> entry) {
        FieldDescriptorLite descriptor = (FieldDescriptorLite)entry.getKey();
        Object value2 = entry.getValue();
        if (descriptor.getLiteJavaType() == WireFormat.JavaType.MESSAGE && !descriptor.isRepeated() && !descriptor.isPacked()) {
            if (value2 instanceof LazyField) {
                return CodedOutputStream.computeLazyFieldMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (LazyField)value2);
            }
            return CodedOutputStream.computeMessageSetExtensionSize(((FieldDescriptorLite)entry.getKey()).getNumber(), (MessageLite)value2);
        }
        return FieldSet.computeFieldSize(descriptor, value2);
    }

    private static int computeElementSize(WireFormat.FieldType type, int number, Object value2) {
        int tagSize = CodedOutputStream.computeTagSize(number);
        if (type == WireFormat.FieldType.GROUP) {
            tagSize *= 2;
        }
        return tagSize + FieldSet.computeElementSizeNoTag(type, value2);
    }

    private static int computeElementSizeNoTag(WireFormat.FieldType type, Object value2) {
        switch (type) {
            case DOUBLE: {
                return CodedOutputStream.computeDoubleSizeNoTag((Double)value2);
            }
            case FLOAT: {
                return CodedOutputStream.computeFloatSizeNoTag(((Float)value2).floatValue());
            }
            case INT64: {
                return CodedOutputStream.computeInt64SizeNoTag((Long)value2);
            }
            case UINT64: {
                return CodedOutputStream.computeUInt64SizeNoTag((Long)value2);
            }
            case INT32: {
                return CodedOutputStream.computeInt32SizeNoTag((Integer)value2);
            }
            case FIXED64: {
                return CodedOutputStream.computeFixed64SizeNoTag((Long)value2);
            }
            case FIXED32: {
                return CodedOutputStream.computeFixed32SizeNoTag((Integer)value2);
            }
            case BOOL: {
                return CodedOutputStream.computeBoolSizeNoTag((Boolean)value2);
            }
            case STRING: {
                return CodedOutputStream.computeStringSizeNoTag((String)value2);
            }
            case GROUP: {
                return CodedOutputStream.computeGroupSizeNoTag((MessageLite)value2);
            }
            case BYTES: {
                if (value2 instanceof ByteString) {
                    return CodedOutputStream.computeBytesSizeNoTag((ByteString)value2);
                }
                return CodedOutputStream.computeByteArraySizeNoTag((byte[])value2);
            }
            case UINT32: {
                return CodedOutputStream.computeUInt32SizeNoTag((Integer)value2);
            }
            case SFIXED32: {
                return CodedOutputStream.computeSFixed32SizeNoTag((Integer)value2);
            }
            case SFIXED64: {
                return CodedOutputStream.computeSFixed64SizeNoTag((Long)value2);
            }
            case SINT32: {
                return CodedOutputStream.computeSInt32SizeNoTag((Integer)value2);
            }
            case SINT64: {
                return CodedOutputStream.computeSInt64SizeNoTag((Long)value2);
            }
            case MESSAGE: {
                if (value2 instanceof LazyField) {
                    return CodedOutputStream.computeLazyFieldSizeNoTag((LazyField)value2);
                }
                return CodedOutputStream.computeMessageSizeNoTag((MessageLite)value2);
            }
            case ENUM: {
                if (value2 instanceof Internal.EnumLite) {
                    return CodedOutputStream.computeEnumSizeNoTag(((Internal.EnumLite)value2).getNumber());
                }
                return CodedOutputStream.computeEnumSizeNoTag((Integer)value2);
            }
        }
        throw new RuntimeException("There is no way to get here, but the compiler thinks otherwise.");
    }

    public static int computeFieldSize(FieldDescriptorLite<?> descriptor, Object value2) {
        WireFormat.FieldType type = descriptor.getLiteType();
        int number = descriptor.getNumber();
        if (descriptor.isRepeated()) {
            if (descriptor.isPacked()) {
                int dataSize = 0;
                for (Object element : (List)value2) {
                    dataSize += FieldSet.computeElementSizeNoTag(type, element);
                }
                return dataSize + CodedOutputStream.computeTagSize(number) + CodedOutputStream.computeRawVarint32Size(dataSize);
            }
            int size = 0;
            for (Object element : (List)value2) {
                size += FieldSet.computeElementSize(type, number, element);
            }
            return size;
        }
        return FieldSet.computeElementSize(type, number, value2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FieldDescriptorLite<T extends FieldDescriptorLite<T>>
    extends Comparable<T> {
        public int getNumber();

        public WireFormat.FieldType getLiteType();

        public WireFormat.JavaType getLiteJavaType();

        public boolean isRepeated();

        public boolean isPacked();

        public Internal.EnumLiteMap<?> getEnumType();

        public MessageLite.Builder internalMergeFrom(MessageLite.Builder var1, MessageLite var2);
    }
}

