/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.codegen;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.codegen.CallGenerator;
import org.jetbrains.kotlin.codegen.JvmKotlinType;
import org.jetbrains.kotlin.codegen.StackValue;
import org.jetbrains.kotlin.codegen.ValueKind;
import org.jetbrains.kotlin.resolve.jvm.AsmTypes;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0003J\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00030\u0012R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/codegen/DefaultCallArgs;", "", "size", "", "(I)V", "bits", "Ljava/util/BitSet;", "getSize", "()I", "generateOnStackIfNeeded", "", "callGenerator", "Lorg/jetbrains/kotlin/codegen/CallGenerator;", "isConstructor", "mark", "", "index", "toInts", "", "backend"})
public final class DefaultCallArgs {
    private final int size;
    @NotNull
    private final BitSet bits;

    public DefaultCallArgs(int size) {
        this.size = size;
        this.bits = new BitSet(this.size);
    }

    public final int getSize() {
        return this.size;
    }

    public final void mark(int index2) {
        boolean bl;
        boolean bl2 = bl = index2 < this.size;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Mask index should be less then size, but " + index2 + " >= " + this.size;
            throw new AssertionError((Object)string2);
        }
        this.bits.set(index2);
    }

    @NotNull
    public final List<Integer> toInts() {
        if (this.bits.isEmpty() || this.size == 0) {
            return CollectionsKt.emptyList();
        }
        ArrayList<Integer> masks = new ArrayList<Integer>(1);
        int mask = 0;
        int n = this.size;
        for (int i2 = 0; i2 < n; ++i2) {
            if (i2 != 0 && i2 % 32 == 0) {
                masks.add(mask);
                mask = 0;
            }
            mask |= this.bits.get(i2) ? 1 << i2 % 32 : 0;
        }
        masks.add(mask);
        return masks;
    }

    public final boolean generateOnStackIfNeeded(@NotNull CallGenerator callGenerator, boolean isConstructor) {
        Intrinsics.checkNotNullParameter((Object)callGenerator, (String)"callGenerator");
        List<Integer> toInts = this.toInts();
        if (!toInts.isEmpty()) {
            Iterator<Integer> iterator2 = toInts.iterator();
            while (iterator2.hasNext()) {
                int mask = ((Number)iterator2.next()).intValue();
                Type type2 = Type.INT_TYPE;
                Intrinsics.checkNotNullExpressionValue((Object)type2, (String)"INT_TYPE");
                JvmKotlinType jvmKotlinType = new JvmKotlinType(type2, null, 2, null);
                StackValue stackValue = StackValue.constant(mask, Type.INT_TYPE);
                Intrinsics.checkNotNullExpressionValue((Object)stackValue, (String)"constant(mask, Type.INT_TYPE)");
                CallGenerator.putValueIfNeeded$default(callGenerator, jvmKotlinType, stackValue, ValueKind.DEFAULT_MASK, 0, 8, null);
            }
            Type parameterType = isConstructor ? AsmTypes.DEFAULT_CONSTRUCTOR_MARKER : AsmTypes.OBJECT_TYPE;
            Intrinsics.checkNotNullExpressionValue((Object)parameterType, (String)"parameterType");
            JvmKotlinType jvmKotlinType = new JvmKotlinType(parameterType, null, 2, null);
            StackValue stackValue = StackValue.constant(null, parameterType);
            Intrinsics.checkNotNullExpressionValue((Object)stackValue, (String)"constant(null, parameterType)");
            CallGenerator.putValueIfNeeded$default(callGenerator, jvmKotlinType, stackValue, ValueKind.METHOD_HANDLE_IN_DEFAULT, 0, 8, null);
        }
        return !((Collection)toInts).isEmpty();
    }
}

