/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.backend.jvm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.backend.jvm.CachedFieldsForObjectInstances;
import org.jetbrains.kotlin.backend.jvm.JvmFileFacadeClass;
import org.jetbrains.kotlin.backend.jvm.JvmGeneratorExtensions;
import org.jetbrains.kotlin.backend.jvm.JvmIrDeserializer;
import org.jetbrains.kotlin.backend.jvm.JvmSymbols;
import org.jetbrains.kotlin.config.CommonConfigurationKeysKt;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JvmSerializeIrMode;
import org.jetbrains.kotlin.fir.backend.Fir2IrComponents;
import org.jetbrains.kotlin.fir.backend.Fir2IrConversionScope;
import org.jetbrains.kotlin.fir.backend.Fir2IrExtensions;
import org.jetbrains.kotlin.fir.backend.InjectedValue;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.ir.IrBuiltIns;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOriginImpl;
import org.jetbrains.kotlin.ir.declarations.IrMemberWithContainerSource;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.impl.IrExternalPackageFragmentImpl;
import org.jetbrains.kotlin.ir.declarations.impl.IrFactoryImpl;
import org.jetbrains.kotlin.ir.symbols.IrExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.symbols.impl.DescriptorlessExternalPackageFragmentSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.ir.util.SymbolTable;
import org.jetbrains.kotlin.load.java.JvmAnnotationNames;
import org.jetbrains.kotlin.load.kotlin.FacadeClassSource;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002J\u0018\u0010'\u001a\u00020\u00152\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020*H\u0016J\u001a\u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u001a\u00101\u001a\u0004\u0018\u00010\u00102\u0006\u00102\u001a\u0002032\u0006\u0010)\u001a\u00020*H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u000207H\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001c\u001a\u00020\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001d0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions;", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrExtensions;", "Lorg/jetbrains/kotlin/backend/jvm/JvmGeneratorExtensions;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "irDeserializer", "Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;", "mangler", "Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;", "(Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/backend/jvm/JvmIrDeserializer;Lorg/jetbrains/kotlin/ir/util/KotlinMangler$IrMangler;)V", "cachedFields", "Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "getCachedFields", "()Lorg/jetbrains/kotlin/backend/jvm/CachedFieldsForObjectInstances;", "classNameOverride", "", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "getClassNameOverride", "()Ljava/util/Map;", "irNeedsDeserialization", "", "getIrNeedsDeserialization", "()Z", "kotlinIrInternalPackage", "Lorg/jetbrains/kotlin/ir/declarations/impl/IrExternalPackageFragmentImpl;", "kotlinJvmInternalPackage", "rawTypeAnnotationClass", "rawTypeAnnotationConstructor", "Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "getRawTypeAnnotationConstructor", "()Lorg/jetbrains/kotlin/ir/declarations/IrConstructor;", "specialAnnotationConstructors", "", "createSpecialAnnotationClass", "fqn", "Lorg/jetbrains/kotlin/name/FqName;", "parent", "Lorg/jetbrains/kotlin/ir/declarations/IrPackageFragment;", "deserializeToplevelClass", "irClass", "components", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrComponents;", "findInjectedValue", "Lorg/jetbrains/kotlin/fir/backend/InjectedValue;", "calleeReference", "Lorg/jetbrains/kotlin/fir/references/FirReference;", "conversionScope", "Lorg/jetbrains/kotlin/fir/backend/Fir2IrConversionScope;", "generateOrGetFacadeClass", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrMemberWithContainerSource;", "registerDeclarations", "", "symbolTable", "Lorg/jetbrains/kotlin/ir/util/SymbolTable;", "jvm-backend"})
@SourceDebugExtension(value={"SMAP\nJvmFir2IrExtensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JvmFir2IrExtensions.kt\norg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,97:1\n1855#2,2:98\n*S KotlinDebug\n*F\n+ 1 JvmFir2IrExtensions.kt\norg/jetbrains/kotlin/fir/backend/jvm/JvmFir2IrExtensions\n*L\n65#1:98,2\n*E\n"})
public final class JvmFir2IrExtensions
implements Fir2IrExtensions,
JvmGeneratorExtensions {
    @NotNull
    private final JvmIrDeserializer irDeserializer;
    @NotNull
    private final KotlinMangler.IrMangler mangler;
    @NotNull
    private final Map<IrClass, JvmClassName> classNameOverride;
    @NotNull
    private final CachedFieldsForObjectInstances cachedFields;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinIrInternalPackage;
    @NotNull
    private final IrExternalPackageFragmentImpl kotlinJvmInternalPackage;
    @NotNull
    private final List<IrConstructor> specialAnnotationConstructors;
    @NotNull
    private final IrClass rawTypeAnnotationClass;
    @NotNull
    private final IrConstructor rawTypeAnnotationConstructor;
    private final boolean irNeedsDeserialization;

    public JvmFir2IrExtensions(@NotNull CompilerConfiguration configuration2, @NotNull JvmIrDeserializer irDeserializer, @NotNull KotlinMangler.IrMangler mangler) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)irDeserializer, (String)"irDeserializer");
        Intrinsics.checkNotNullParameter((Object)mangler, (String)"mangler");
        this.irDeserializer = irDeserializer;
        this.mangler = mangler;
        this.classNameOverride = new LinkedHashMap();
        this.cachedFields = new CachedFieldsForObjectInstances(IrFactoryImpl.INSTANCE, CommonConfigurationKeysKt.getLanguageVersionSettings(configuration2));
        this.kotlinIrInternalPackage = new IrExternalPackageFragmentImpl(new DescriptorlessExternalPackageFragmentSymbol(), IrBuiltIns.Companion.getKOTLIN_INTERNAL_IR_FQN());
        IrExternalPackageFragmentSymbol irExternalPackageFragmentSymbol = new DescriptorlessExternalPackageFragmentSymbol();
        FqName fqName2 = JvmAnnotationNames.KOTLIN_JVM_INTERNAL;
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"KOTLIN_JVM_INTERNAL");
        this.kotlinJvmInternalPackage = new IrExternalPackageFragmentImpl(irExternalPackageFragmentSymbol, fqName2);
        this.specialAnnotationConstructors = new ArrayList();
        this.rawTypeAnnotationClass = this.createSpecialAnnotationClass(JvmSymbols.Companion.getRAW_TYPE_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.rawTypeAnnotationConstructor = (IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors(this.rawTypeAnnotationClass));
        FqName fqName3 = JvmAnnotationNames.ENHANCED_NULLABILITY_ANNOTATION;
        Intrinsics.checkNotNullExpressionValue((Object)fqName3, (String)"ENHANCED_NULLABILITY_ANNOTATION");
        this.createSpecialAnnotationClass(fqName3, this.kotlinJvmInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_NULLABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.createSpecialAnnotationClass(JvmSymbols.Companion.getFLEXIBLE_MUTABILITY_ANNOTATION_FQ_NAME(), this.kotlinIrInternalPackage);
        this.irNeedsDeserialization = configuration2.get(JVMConfigurationKeys.SERIALIZE_IR, JvmSerializeIrMode.NONE) != JvmSerializeIrMode.NONE;
    }

    @Override
    @NotNull
    public Map<IrClass, JvmClassName> getClassNameOverride() {
        return this.classNameOverride;
    }

    @Override
    @NotNull
    public CachedFieldsForObjectInstances getCachedFields() {
        return this.cachedFields;
    }

    @Override
    @NotNull
    public IrConstructor getRawTypeAnnotationConstructor() {
        return this.rawTypeAnnotationConstructor;
    }

    private final IrClass createSpecialAnnotationClass(FqName fqn, IrPackageFragment parent2) {
        IrClass irClass2;
        IrClass $this$createSpecialAnnotationClass_u24lambda_u240 = irClass2 = IrUtilsKt.createSpecialAnnotationClass(IrFactoryImpl.INSTANCE, fqn, parent2);
        boolean bl = false;
        this.specialAnnotationConstructors.add((IrConstructor)SequencesKt.single(IrUtilsKt.getConstructors($this$createSpecialAnnotationClass_u24lambda_u240)));
        return irClass2;
    }

    @Override
    public void registerDeclarations(@NotNull SymbolTable symbolTable) {
        Intrinsics.checkNotNullParameter((Object)symbolTable, (String)"symbolTable");
        PublicIdSignatureComputer signatureComputer = new PublicIdSignatureComputer(this.mangler);
        Iterable $this$forEach$iv = this.specialAnnotationConstructors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            IrConstructor constructor2 = (IrConstructor)element$iv;
            boolean bl = false;
            symbolTable.declareConstructorWithSignature(signatureComputer.composePublicIdSignature(constructor2, false), constructor2.getSymbol());
        }
    }

    @Override
    @Nullable
    public InjectedValue findInjectedValue(@NotNull FirReference calleeReference, @NotNull Fir2IrConversionScope conversionScope) {
        Intrinsics.checkNotNullParameter((Object)calleeReference, (String)"calleeReference");
        Intrinsics.checkNotNullParameter((Object)conversionScope, (String)"conversionScope");
        return null;
    }

    @Override
    public boolean getIrNeedsDeserialization() {
        return this.irNeedsDeserialization;
    }

    @Override
    @Nullable
    public IrClass generateOrGetFacadeClass(@NotNull IrMemberWithContainerSource declaration, @NotNull Fir2IrComponents components2) {
        JvmFileFacadeClass jvmFileFacadeClass;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        DeserializedContainerSource deserializedContainerSource = declaration.getContainerSource();
        if (deserializedContainerSource == null) {
            return null;
        }
        DeserializedContainerSource deserializedSource = deserializedContainerSource;
        if (!(deserializedSource instanceof FacadeClassSource)) {
            return null;
        }
        JvmClassName jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName();
        if (jvmClassName == null) {
            jvmClassName = ((FacadeClassSource)((Object)deserializedSource)).getClassName();
        }
        JvmClassName facadeName = jvmClassName;
        IrDeclarationOrigin irDeclarationOrigin = ((FacadeClassSource)((Object)deserializedSource)).getFacadeClassName() != null ? (IrDeclarationOriginImpl)IrDeclarationOrigin.JVM_MULTIFILE_CLASS.INSTANCE : (IrDeclarationOriginImpl)IrDeclarationOrigin.FILE_CLASS.INSTANCE;
        Name name2 = facadeName.getFqNameForTopLevelClassMaybeWithDollars().shortName();
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
        JvmFileFacadeClass it = jvmFileFacadeClass = new JvmFileFacadeClass(irDeclarationOrigin, name2, deserializedSource, (Function1<? super IrClass, Boolean>)((Function1)new Function1<IrClass, Boolean>(this, components2){
            final /* synthetic */ JvmFir2IrExtensions this$0;
            final /* synthetic */ Fir2IrComponents $components;
            {
                this.this$0 = $receiver;
                this.$components = $components;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull IrClass irClass2) {
                Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
                return this.this$0.deserializeToplevelClass(irClass2, this.$components);
            }
        }));
        boolean bl = false;
        IrUtilsKt.createParameterDeclarations(it);
        this.getClassNameOverride().put(it, facadeName);
        return jvmFileFacadeClass;
    }

    @Override
    public boolean deserializeToplevelClass(@NotNull IrClass irClass2, @NotNull Fir2IrComponents components2) {
        Intrinsics.checkNotNullParameter((Object)irClass2, (String)"irClass");
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        return this.irDeserializer.deserializeTopLevelClass(irClass2, components2.getIrBuiltIns(), components2.getSymbolTable(), components2.getIrProviders(), this);
    }
}

