/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.HiddenCandidate;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStage;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionStagesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.types.ConeDynamicType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\r\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/calls/ProcessDynamicExtensionAnnotation;", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionStage;", "()V", "check", "", "candidate", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "(Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resolve"})
public final class ProcessDynamicExtensionAnnotation
extends ResolutionStage {
    @NotNull
    public static final ProcessDynamicExtensionAnnotation INSTANCE = new ProcessDynamicExtensionAnnotation();

    private ProcessDynamicExtensionAnnotation() {
    }

    @Override
    @Nullable
    public Object check(@NotNull Candidate candidate2, @NotNull CallInfo callInfo, @NotNull CheckerSink sink, @NotNull ResolutionContext context, @NotNull Continuation<? super Unit> $completion) {
        if (candidate2.getSymbol().getOrigin() == FirDeclarationOrigin.DynamicScope.INSTANCE) {
            return Unit.INSTANCE;
        }
        FirExpression firExpression2 = candidate2.getChosenExtensionReceiver();
        if (firExpression2 == null) {
            return Unit.INSTANCE;
        }
        FirExpression extensionReceiver = firExpression2;
        boolean argumentIsDynamic = FirTypeUtilsKt.getConeType(extensionReceiver.getTypeRef()) instanceof ConeDynamicType;
        FirBasedSymbol<?> firBasedSymbol = candidate2.getSymbol();
        Object object = firBasedSymbol instanceof FirCallableSymbol ? (FirCallableSymbol)firBasedSymbol : null;
        boolean parameterIsDynamic = (object != null && (object = ((FirCallableSymbol)object).getResolvedReceiverTypeRef()) != null ? ((FirResolvedTypeRef)object).getType() : null) instanceof ConeDynamicType;
        if (parameterIsDynamic != argumentIsDynamic || parameterIsDynamic && !FirAnnotationUtilsKt.hasAnnotation(candidate2.getSymbol(), ResolutionStagesKt.access$getDYNAMIC_EXTENSION_ANNOTATION_CLASS_ID$p(), context.getSession())) {
            candidate2.addDiagnostic(HiddenCandidate.INSTANCE);
        }
        return Unit.INSTANCE;
    }
}

