/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory2;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.analysis.checkers.FirKeywordUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.CheckResult;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.OperatorFunctionChecks;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqNamesUtilKt;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirSimpleFunctionChecker;", "()V", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkReplaceableLegacyOperators", "checkers"})
@SourceDebugExtension(value={"SMAP\nFirOperatorModifierChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirOperatorModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker\n+ 2 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,61:1\n41#2:62\n*S KotlinDebug\n*F\n+ 1 FirOperatorModifierChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirOperatorModifierChecker\n*L\n27#1:62\n*E\n"})
public final class FirOperatorModifierChecker
extends FirDeclarationChecker<FirSimpleFunction> {
    @NotNull
    public static final FirOperatorModifierChecker INSTANCE = new FirOperatorModifierChecker();

    private FirOperatorModifierChecker() {
    }

    @Override
    public void check(@NotNull FirSimpleFunction declaration, @NotNull CheckerContext context, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirMemberDeclaration $this$isOperator$iv = declaration;
        boolean $i$f$isOperator = false;
        if (!$this$isOperator$iv.getStatus().isOperator()) {
            return;
        }
        FirElement firElement = declaration;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.OPERATOR_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)((Object)ktModifierKeywordToken), (String)"OPERATOR_KEYWORD");
        if (!FirKeywordUtilsKt.hasModifier(firElement, ktModifierKeywordToken)) {
            return;
        }
        CheckResult checkResult = OperatorFunctionChecks.INSTANCE.isOperator(declaration, context.getSession(), context.getScopeSession());
        if (!Intrinsics.areEqual((Object)checkResult, (Object)CheckResult.SuccessCheck.INSTANCE)) {
            if (Intrinsics.areEqual((Object)checkResult, (Object)CheckResult.IllegalFunctionName.INSTANCE)) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)"illegal function name", (DiagnosticContext)context, null, 16, null);
                return;
            }
            if (checkResult instanceof CheckResult.IllegalSignature) {
                KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)declaration.getSource(), FirErrors.INSTANCE.getINAPPLICABLE_OPERATOR_MODIFIER(), (Object)((CheckResult.IllegalSignature)checkResult).getError(), (DiagnosticContext)context, null, 16, null);
                return;
            }
        }
        this.checkReplaceableLegacyOperators(declaration, context, reporter2);
    }

    private final void checkReplaceableLegacyOperators(FirSimpleFunction declaration, CheckerContext context, DiagnosticReporter reporter2) {
        Name name2 = OperatorNameConventions.MOD_OPERATORS_REPLACEMENT.get(declaration.getName());
        if (name2 == null) {
            return;
        }
        Name replacement = name2;
        KtDiagnosticFactory2<FirBasedSymbol<?>, String> diagnostic = FqNamesUtilKt.isSubpackageOf(declaration.getSymbol().getCallableId().getPackageName(), StandardClassIds.INSTANCE.getBASE_KOTLIN_PACKAGE()) || !context.getLanguageVersionSettings().supportsFeature(LanguageFeature.ProhibitOperatorMod) ? FirErrors.INSTANCE.getDEPRECATED_BINARY_MOD() : FirErrors.INSTANCE.getFORBIDDEN_BINARY_MOD();
        AbstractKtSourceElement abstractKtSourceElement = declaration.getSource();
        FirNamedFunctionSymbol firNamedFunctionSymbol = declaration.getSymbol();
        String string2 = replacement.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"asString(...)");
        KtDiagnosticReportHelpersKt.reportOn$default(reporter2, abstractKtSourceElement, diagnostic, (Object)firNamedFunctionSymbol, (Object)string2, (DiagnosticContext)context, null, 32, null);
    }
}

