/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousObjectExpression;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirResolvedQualifier;
import org.jetbrains.kotlin.fir.expressions.FirThisReceiverExpression;
import org.jetbrains.kotlin.fir.resolve.SupertypeUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirVisitor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirRegularClassChecker;", "()V", "objectRefVisitor", "Lorg/jetbrains/kotlin/fir/visitors/FirVisitor;", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker$Data;", "check", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "Data", "checkers"})
public final class FirObjectConstructorChecker
extends FirDeclarationChecker<FirRegularClass> {
    @NotNull
    public static final FirObjectConstructorChecker INSTANCE = new FirObjectConstructorChecker();
    @NotNull
    private static final FirVisitor<Unit, Data> objectRefVisitor = new FirVisitor<Unit, Data>(){

        public void visitElement(FirElement element, Data data2) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            element.acceptChildren(this, data2);
        }

        public void visitThisReceiverExpression(FirThisReceiverExpression thisReceiverExpression, Data data2) {
            Intrinsics.checkNotNullParameter((Object)thisReceiverExpression, (String)"thisReceiverExpression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            if (Intrinsics.areEqual(thisReceiverExpression.getCalleeReference().getBoundSymbol(), (Object)data2.getObjectSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(data2.getReporter(), (AbstractKtSourceElement)thisReceiverExpression.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data2.getContext(), null, 8, null);
            }
        }

        public void visitResolvedQualifier(FirResolvedQualifier resolvedQualifier, Data data2) {
            Intrinsics.checkNotNullParameter((Object)resolvedQualifier, (String)"resolvedQualifier");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            if (Intrinsics.areEqual(resolvedQualifier.getSymbol(), (Object)data2.getObjectSymbol())) {
                KtDiagnosticReportHelpersKt.reportOn$default(data2.getReporter(), (AbstractKtSourceElement)resolvedQualifier.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data2.getContext(), null, 8, null);
            } else if (resolvedQualifier.getResolvedToCompanionObject()) {
                FirRegularClassSymbol companionSymbol;
                FirRegularClassSymbol firRegularClassSymbol = resolvedQualifier.getSymbol();
                FirRegularClassSymbol firRegularClassSymbol2 = firRegularClassSymbol != null && (firRegularClassSymbol = org.jetbrains.kotlin.fir.declarations.DeclarationUtilsKt.fullyExpandedClass(firRegularClassSymbol, data2.getContext().getSession())) != null ? firRegularClassSymbol.getCompanionObjectSymbol() : (companionSymbol = null);
                if (Intrinsics.areEqual((Object)companionSymbol, (Object)data2.getObjectSymbol())) {
                    KtDiagnosticReportHelpersKt.reportOn$default(data2.getReporter(), (AbstractKtSourceElement)resolvedQualifier.getSource(), FirErrors.INSTANCE.getSELF_CALL_IN_NESTED_OBJECT_CONSTRUCTOR_ERROR(), (DiagnosticContext)data2.getContext(), null, 8, null);
                }
            }
        }

        public void visitAnonymousObjectExpression(FirAnonymousObjectExpression anonymousObjectExpression, Data data2) {
            Intrinsics.checkNotNullParameter((Object)anonymousObjectExpression, (String)"anonymousObjectExpression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        }

        public void visitGetClassCall(FirGetClassCall getClassCall, Data data2) {
            Intrinsics.checkNotNullParameter((Object)getClassCall, (String)"getClassCall");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        }

        public void visitCallableReferenceAccess(FirCallableReferenceAccess callableReferenceAccess, Data data2) {
            Intrinsics.checkNotNullParameter((Object)callableReferenceAccess, (String)"callableReferenceAccess");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        }
    };

    private FirObjectConstructorChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirRegularClass declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        block3: {
            FirDelegatedConstructorCall firDelegatedConstructorCall;
            Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            if (!FirLanguageSettingsComponentKt.getLanguageVersionSettings(context2.getSession()).supportsFeature(LanguageFeature.ProhibitSelfCallsInNestedObjects)) {
                return;
            }
            if (declaration.getClassKind() != ClassKind.OBJECT) {
                return;
            }
            FirRegularClassSymbol objectSymbol = declaration.getSymbol();
            if (!Intrinsics.areEqual(FirHelpersKt.getContainingClassSymbol(objectSymbol, context2.getSession()), (Object)SupertypeUtilsKt.getSuperClassSymbolOrAny(objectSymbol, context2.getSession()))) {
                return;
            }
            FirConstructorSymbol firConstructorSymbol2 = DeclarationUtilsKt.primaryConstructorSymbol(objectSymbol, context2.getSession());
            if (firConstructorSymbol2 == null || (firDelegatedConstructorCall = firConstructorSymbol2.getResolvedDelegatedConstructorCall()) == null) break block3;
            firDelegatedConstructorCall.accept(objectRefVisitor, new Data(objectSymbol, context2, reporter2));
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirObjectConstructorChecker$Data;", "", "objectSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;)V", "getContext", "()Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "getObjectSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "getReporter", "()Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "checkers"})
    private static final class Data {
        @NotNull
        private final FirRegularClassSymbol objectSymbol;
        @NotNull
        private final CheckerContext context;
        @NotNull
        private final DiagnosticReporter reporter;

        public Data(@NotNull FirRegularClassSymbol objectSymbol, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
            Intrinsics.checkNotNullParameter((Object)objectSymbol, (String)"objectSymbol");
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
            this.objectSymbol = objectSymbol;
            this.context = context2;
            this.reporter = reporter2;
        }

        @NotNull
        public final FirRegularClassSymbol getObjectSymbol() {
            return this.objectSymbol;
        }

        @NotNull
        public final CheckerContext getContext() {
            return this.context;
        }

        @NotNull
        public final DiagnosticReporter getReporter() {
            return this.reporter;
        }
    }
}

