/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.jvm.checkers.expression;

import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.FirHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.jvm.FirJvmErrors;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCallOrigin;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirValueParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J&\u0010\u0007\u001a\u00020\u000e*\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInconsistentOperatorFromJavaCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "()V", "CONCURRENT_HASH_MAP_CALLABLE_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "check", "", "expression", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "source", "Lorg/jetbrains/kotlin/KtSourceElement;", "checkers.jvm"})
@SourceDebugExtension(value={"SMAP\nFirJvmInconsistentOperatorFromJavaCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirJvmInconsistentOperatorFromJavaCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInconsistentOperatorFromJavaCallChecker\n+ 2 ClassMembers.kt\norg/jetbrains/kotlin/fir/ClassMembersKt\n+ 3 FirDeclarationUtil.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirDeclarationUtilKt\n*L\n1#1,75:1\n114#2:76\n107#2,3:77\n98#2:80\n86#2:81\n92#2:83\n111#2:84\n39#3:82\n*S KotlinDebug\n*F\n+ 1 FirJvmInconsistentOperatorFromJavaCallChecker.kt\norg/jetbrains/kotlin/fir/analysis/jvm/checkers/expression/FirJvmInconsistentOperatorFromJavaCallChecker\n*L\n58#1:76\n58#1:77,3\n58#1:80\n58#1:81\n58#1:83\n58#1:84\n58#1:82\n*E\n"})
public final class FirJvmInconsistentOperatorFromJavaCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirJvmInconsistentOperatorFromJavaCallChecker INSTANCE = new FirJvmInconsistentOperatorFromJavaCallChecker();
    @NotNull
    private static final CallableId CONCURRENT_HASH_MAP_CALLABLE_ID = new CallableId(ClassId.Companion.fromString$default(ClassId.Companion, "java/util/concurrent/ConcurrentHashMap", false, 2, null), OperatorNameConventions.CONTAINS);

    private FirJvmInconsistentOperatorFromJavaCallChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull FirFunctionCall expression2, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        if (expression2.getOrigin() != FirFunctionCallOrigin.Operator) {
            return;
        }
        FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default(expression2.getCalleeReference(), false, 1, null);
        FirNamedFunctionSymbol firNamedFunctionSymbol = firCallableSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firCallableSymbol : null;
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol callableSymbol = firNamedFunctionSymbol;
        if (!Intrinsics.areEqual((Object)callableSymbol.getName(), (Object)OperatorNameConventions.CONTAINS)) {
            return;
        }
        FirValueParameterSymbol firValueParameterSymbol = (FirValueParameterSymbol)CollectionsKt.singleOrNull(callableSymbol.getValueParameterSymbols());
        if (firValueParameterSymbol == null) {
            return;
        }
        FirValueParameterSymbol valueParameterSymbol = firValueParameterSymbol;
        ConeSimpleKotlinType type2 = ConeTypeUtilsKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(valueParameterSymbol.getResolvedReturnTypeRef()));
        if (!ConeBuiltinTypeUtilsKt.isAny(type2) && !ConeBuiltinTypeUtilsKt.isNullableAny(type2)) {
            return;
        }
        this.check(callableSymbol, expression2.getCalleeReference().getSource(), context2, reporter2);
    }

    /*
     * Unable to fully structure code
     */
    private final boolean check(FirNamedFunctionSymbol $this$check, KtSourceElement source, CheckerContext context, DiagnosticReporter reporter) {
        $this$originalOrSelf$iv = $this$check;
        $i$f$originalOrSelf = false;
        $this$originalOrSelf$iv$iv = (FirCallableDeclaration)$this$originalOrSelf$iv.getFir();
        $i$f$originalOrSelf = false;
        result$iv$iv = $this$originalOrSelf$iv$iv;
        while (ClassMembersKt.isSubstitutionOrIntersectionOverride(result$iv$iv)) {
            $this$originalIfFakeOverride$iv$iv$iv = result$iv$iv;
            $i$f$originalIfFakeOverride = false;
            $this$originalForSubstitutionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
            $i$f$getOriginalForSubstitutionOverride = false;
            if (ClassMembersKt.isSubstitutionOverride($this$originalForSubstitutionOverride$iv$iv$iv$iv)) ** GOTO lbl-1000
            $this$isSynthetic$iv$iv$iv$iv$iv = $this$originalForSubstitutionOverride$iv$iv$iv$iv;
            $i$f$isSynthetic = false;
            if ($this$isSynthetic$iv$iv$iv$iv$iv.getOrigin() instanceof FirDeclarationOrigin.Synthetic) lbl-1000:
            // 2 sources

            {
                v0 = ClassMembersKt.getOriginalForSubstitutionOverrideAttr($this$originalForSubstitutionOverride$iv$iv$iv$iv);
            } else {
                v0 = v1 = null;
            }
            if (v0 == null) {
                $this$baseForIntersectionOverride$iv$iv$iv$iv = $this$originalIfFakeOverride$iv$iv$iv;
                $i$f$getBaseForIntersectionOverride = false;
                v1 = ClassMembersKt.isIntersectionOverride($this$baseForIntersectionOverride$iv$iv$iv$iv) ? ClassMembersKt.getOriginalForIntersectionOverrideAttr($this$baseForIntersectionOverride$iv$iv$iv$iv) : null;
            }
            if (v1 == null) break;
            result$iv$iv = v1;
        }
        v2 = result$iv$iv.getSymbol();
        if (v2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
        }
        if (Intrinsics.areEqual((Object)((FirNamedFunctionSymbol)((FirCallableSymbol)((FirNamedFunctionSymbol)v2))).getCallableId(), (Object)FirJvmInconsistentOperatorFromJavaCallChecker.CONCURRENT_HASH_MAP_CALLABLE_ID)) {
            KtDiagnosticReportHelpersKt.reportOn$default(reporter, (AbstractKtSourceElement)source, FirJvmErrors.INSTANCE.getCONCURRENT_HASH_MAP_CONTAINS_OPERATOR(), (DiagnosticContext)context, null, 8, null);
            return true;
        }
        v3 = ClassMembersKt.containingClassLookupTag($this$check);
        if (v3 == null || (v3 = LookupTagUtilsKt.toFirRegularClassSymbol((ConeClassLikeLookupTag)v3, context.getSession())) == null) {
            return false;
        }
        containingClass = v3;
        overriddenFunctions = FirHelpersKt.overriddenFunctions($this$check, (FirClassSymbol)containingClass, context);
        for (FirFunctionSymbol<?> overriddenFunction : overriddenFunctions) {
            if (!(overriddenFunction instanceof FirNamedFunctionSymbol) || !this.check((FirNamedFunctionSymbol)overriddenFunction, source, context, reporter)) continue;
            return true;
        }
        return false;
    }
}

