/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.components;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.ReceiverParameterDescriptor;
import org.jetbrains.kotlin.resolve.calls.components.ApplicableContextReceiverArgumentWithConstraint;
import org.jetbrains.kotlin.resolve.calls.components.ImplicitInvokeCheckStatus;
import org.jetbrains.kotlin.resolve.calls.components.ReceiverInfo;
import org.jetbrains.kotlin.resolve.calls.components.ResolutionPartsKt;
import org.jetbrains.kotlin.resolve.calls.components.candidate.CallableReferenceResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.components.candidate.ResolutionCandidate;
import org.jetbrains.kotlin.resolve.calls.model.ResolutionPart;
import org.jetbrains.kotlin.resolve.calls.model.SimpleKotlinCallArgument;
import org.jetbrains.kotlin.resolve.calls.model.StubBuilderInferenceReceiver;
import org.jetbrains.kotlin.resolve.calls.tower.ContextReceiverAmbiguity;
import org.jetbrains.kotlin.resolve.calls.tower.NoMatchingContextReceiver;
import org.jetbrains.kotlin.types.StubTypeForBuilderInference;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u0004*\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\u0004\u0018\u00010\u0007*\u00020\u0005H\u0002J\u0014\u0010\r\u001a\u00020\u0004*\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\f\u0010\u0010\u001a\u00020\u000f*\u00020\u0005H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/components/CheckReceivers;", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolutionPart;", "()V", "checkReceiver", "", "Lorg/jetbrains/kotlin/resolve/calls/components/candidate/ResolutionCandidate;", "receiverArgument", "Lorg/jetbrains/kotlin/resolve/calls/model/SimpleKotlinCallArgument;", "receiverParameter", "Lorg/jetbrains/kotlin/descriptors/ReceiverParameterDescriptor;", "shouldCheckImplicitInvoke", "", "chooseExtensionReceiverCandidate", "process", "workIndex", "", "workCount", "resolution"})
@SourceDebugExtension(value={"SMAP\nResolutionParts.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResolutionParts.kt\norg/jetbrains/kotlin/resolve/calls/components/CheckReceivers\n+ 2 ResolvedCallAtoms.kt\norg/jetbrains/kotlin/resolve/calls/model/ResolutionPart\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,964:1\n42#2:965\n42#2:966\n42#2:967\n42#2:968\n43#2:982\n42#2:983\n1611#3,9:969\n1863#3:978\n1864#3:980\n1620#3:981\n1#4:979\n*S KotlinDebug\n*F\n+ 1 ResolutionParts.kt\norg/jetbrains/kotlin/resolve/calls/components/CheckReceivers\n*L\n662#1:965\n681#1:966\n687#1:967\n704#1:968\n725#1:982\n725#1:983\n705#1:969,9\n705#1:978\n705#1:980\n705#1:981\n705#1:979\n*E\n"})
public final class CheckReceivers
extends ResolutionPart {
    @NotNull
    public static final CheckReceivers INSTANCE = new CheckReceivers();

    private CheckReceivers() {
    }

    @Override
    public void process(@NotNull ResolutionCandidate $this$process, int workIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$process, (String)"<this>");
        switch (workIndex) {
            case 0: {
                ResolutionPart resolutionPart = this;
                ResolutionCandidate $this$candidateDescriptor$iv = $this$process;
                boolean $i$f$getCandidateDescriptor2 = false;
                this.checkReceiver($this$process, $this$process.getResolvedCall().getDispatchReceiverArgument(), $this$candidateDescriptor$iv.getResolvedCall().getCandidateDescriptor().getDispatchReceiverParameter(), true);
                break;
            }
            case 1: {
                boolean $i$f$getCandidateDescriptor;
                ResolutionCandidate $this$candidateDescriptor$iv;
                boolean checkBuilderInferenceRestriction;
                SimpleKotlinCallArgument extensionReceiverArgument = $this$process.getResolvedCall().getExtensionReceiverArgument();
                if (extensionReceiverArgument == null) {
                    SimpleKotlinCallArgument simpleKotlinCallArgument = this.chooseExtensionReceiverCandidate($this$process);
                    if (simpleKotlinCallArgument == null) {
                        return;
                    }
                    extensionReceiverArgument = simpleKotlinCallArgument;
                    $this$process.getResolvedCall().setExtensionReceiverArgument(extensionReceiverArgument);
                }
                boolean bl = checkBuilderInferenceRestriction = !$this$process.getCallComponents().getLanguageVersionSettings().supportsFeature(LanguageFeature.NoBuilderInferenceWithoutAnnotationRestriction);
                if (checkBuilderInferenceRestriction && extensionReceiverArgument.getReceiver().getReceiverValue().getType() instanceof StubTypeForBuilderInference) {
                    ResolutionPart $i$f$getCandidateDescriptor2 = this;
                    $this$candidateDescriptor$iv = $this$process;
                    $i$f$getCandidateDescriptor = false;
                    ReceiverParameterDescriptor receiverParameterDescriptor = $this$candidateDescriptor$iv.getResolvedCall().getCandidateDescriptor().getExtensionReceiverParameter();
                    Intrinsics.checkNotNull((Object)receiverParameterDescriptor);
                    $this$process.addDiagnostic(new StubBuilderInferenceReceiver(extensionReceiverArgument, receiverParameterDescriptor));
                }
                ResolutionPart this_$iv = this;
                $this$candidateDescriptor$iv = $this$process;
                $i$f$getCandidateDescriptor = false;
                this.checkReceiver($this$process, $this$process.getResolvedCall().getExtensionReceiverArgument(), $this$candidateDescriptor$iv.getResolvedCall().getCandidateDescriptor().getExtensionReceiverParameter(), false);
            }
        }
    }

    @Override
    public int workCount(@NotNull ResolutionCandidate $this$workCount) {
        Intrinsics.checkNotNullParameter((Object)$this$workCount, (String)"<this>");
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    private final SimpleKotlinCallArgument chooseExtensionReceiverCandidate(ResolutionCandidate $this$chooseExtensionReceiverCandidate) {
        SimpleKotlinCallArgument simpleKotlinCallArgument;
        void $this$mapNotNullTo$iv$iv;
        List<SimpleKotlinCallArgument> receiverCandidates = $this$chooseExtensionReceiverCandidate.getResolvedCall().getExtensionReceiverArgumentCandidates();
        Collection collection = receiverCandidates;
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        if (receiverCandidates.size() == 1) {
            return (SimpleKotlinCallArgument)CollectionsKt.single(receiverCandidates);
        }
        ResolutionPart resolutionPart = this;
        Object $this$candidateDescriptor$iv = $this$chooseExtensionReceiverCandidate;
        boolean $i$f$getCandidateDescriptor = false;
        ReceiverParameterDescriptor receiverParameterDescriptor = ((ResolutionCandidate)$this$candidateDescriptor$iv).getResolvedCall().getCandidateDescriptor().getExtensionReceiverParameter();
        if (receiverParameterDescriptor == null) {
            return null;
        }
        ReceiverParameterDescriptor extensionReceiverParameter2 = receiverParameterDescriptor;
        Iterable $this$mapNotNull$iv = receiverCandidates;
        boolean $i$f$mapNotNull = false;
        $this$candidateDescriptor$iv = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ApplicableContextReceiverArgumentWithConstraint it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            SimpleKotlinCallArgument it = (SimpleKotlinCallArgument)element$iv$iv;
            boolean bl2 = false;
            if (ResolutionPartsKt.access$getReceiverArgumentWithConstraintIfCompatible($this$chooseExtensionReceiverCandidate, it, extensionReceiverParameter2) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List compatible = (List)destination$iv$iv;
        switch (compatible.size()) {
            case 0: {
                $this$chooseExtensionReceiverCandidate.addDiagnostic(new NoMatchingContextReceiver());
                simpleKotlinCallArgument = null;
                break;
            }
            case 1: {
                simpleKotlinCallArgument = ((ApplicableContextReceiverArgumentWithConstraint)CollectionsKt.single((List)compatible)).getArgument();
                break;
            }
            default: {
                $this$chooseExtensionReceiverCandidate.addDiagnostic(new ContextReceiverAmbiguity());
                simpleKotlinCallArgument = null;
            }
        }
        return simpleKotlinCallArgument;
    }

    private final void checkReceiver(ResolutionCandidate $this$checkReceiver, SimpleKotlinCallArgument receiverArgument, ReceiverParameterDescriptor receiverParameter, boolean shouldCheckImplicitInvoke) {
        if (!($this$checkReceiver instanceof CallableReferenceResolutionCandidate) && receiverArgument == null != (receiverParameter == null)) {
            ResolutionPart resolutionPart = this;
            ResolutionCandidate $this$kotlinCall$iv = $this$checkReceiver;
            boolean $i$f$getKotlinCall = false;
            Object this_$iv = this;
            ResolutionCandidate $this$candidateDescriptor$iv = $this$checkReceiver;
            boolean $i$f$getCandidateDescriptor = false;
            this_$iv = "Inconsistency receiver state for call " + $this$kotlinCall$iv.getResolvedCall().getAtom() + " and candidate descriptor: " + $this$candidateDescriptor$iv.getResolvedCall().getCandidateDescriptor();
            throw new IllegalStateException(this_$iv.toString());
        }
        if (receiverArgument == null || receiverParameter == null) {
            return;
        }
        ImplicitInvokeCheckStatus implicitInvokeState = shouldCheckImplicitInvoke ? ResolutionPartsKt.access$checkUnsafeImplicitInvokeAfterSafeCall($this$checkReceiver, receiverArgument) : ImplicitInvokeCheckStatus.NO_INVOKE;
        ReceiverInfo receiverInfo = new ReceiverInfo(true, implicitInvokeState != ImplicitInvokeCheckStatus.UNSAFE_INVOKE_REPORTED, implicitInvokeState == ImplicitInvokeCheckStatus.INVOKE_ON_NOT_NULL_VARIABLE, $this$checkReceiver.getResolvedCall().getAtom());
        ResolutionPartsKt.access$resolveKotlinArgument($this$checkReceiver, receiverArgument, receiverParameter, receiverInfo);
    }
}

