/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.diagnostics;

import com.google.common.collect.ImmutableSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.AbstractKotlinSuppressCache;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtStubbedPsiUtil;
import org.jetbrains.kotlin.resolve.constants.ArrayValue;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.StringValue;
import org.jetbrains.kotlin.resolve.diagnostics.DiagnosticSuppressor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 $2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002$%B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\"\u0010\u000f\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\fH\u0014J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0002H\u0014J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00072\u0006\u0010\u0016\u001a\u00020\u0002H&J\u0016\u0010\u0019\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u000bH\u0014J\u001e\u0010\u001f\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00150\"2\u0006\u0010#\u001a\u00020\u0018H\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006&"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache;", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "diagnosticSuppressors", "", "Lorg/jetbrains/kotlin/resolve/diagnostics/DiagnosticSuppressor;", "filter", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "", "getFilter", "()Lkotlin/jvm/functions/Function1;", "getClosestAnnotatedAncestorElement", "element", "rootElement", "excludeSelf", "getSuppressingStrings", "", "", "annotated", "getSuppressionAnnotations", "Lorg/jetbrains/kotlin/descriptors/annotations/AnnotationDescriptor;", "isSuppressed", "request", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "isSuppressedByExtension", "suppressor", "diagnostic", "processAnnotation", "", "builder", "Lcom/google/common/collect/ImmutableSet$Builder;", "annotationDescriptor", "Companion", "DiagnosticSuppressRequest", "frontend"})
@SourceDebugExtension(value={"SMAP\nKotlinSuppressCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinSuppressCache.kt\norg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,138:1\n1#2:139\n*E\n"})
public abstract class KotlinSuppressCache
extends AbstractKotlinSuppressCache<PsiElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DiagnosticSuppressor> diagnosticSuppressors;
    @NotNull
    private final Function1<Diagnostic, Boolean> filter;

    /*
     * WARNING - void declaration
     */
    public KotlinSuppressCache(@Nullable Project project) {
        Object object;
        block3: {
            block2: {
                void it;
                KotlinSuppressCache kotlinSuppressCache = this;
                object = project;
                if (object == null) break block2;
                Project project2 = object;
                KotlinSuppressCache kotlinSuppressCache2 = kotlinSuppressCache;
                boolean bl = false;
                List list2 = DiagnosticSuppressor.Companion.getInstances((Project)it);
                kotlinSuppressCache = kotlinSuppressCache2;
                object = list2;
                if (list2 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        kotlinSuppressCache.diagnosticSuppressors = object;
        this.filter = (Function1)new Function1<Diagnostic, Boolean>(this){
            final /* synthetic */ KotlinSuppressCache this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final Boolean invoke(Diagnostic diagnostic) {
                Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
                return !this.this$0.isSuppressed(new DiagnosticSuppressRequest(diagnostic));
            }
        };
    }

    @NotNull
    public final Function1<Diagnostic, Boolean> getFilter() {
        return this.filter;
    }

    protected boolean isSuppressedByExtension(@NotNull DiagnosticSuppressor suppressor, @NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)suppressor, (String)"suppressor");
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        return suppressor.isSuppressed(diagnostic);
    }

    @NotNull
    public abstract List<AnnotationDescriptor> getSuppressionAnnotations(@NotNull PsiElement var1);

    @Override
    @NotNull
    protected Set<String> getSuppressingStrings(@NotNull PsiElement annotated) {
        Intrinsics.checkNotNullParameter((Object)annotated, (String)"annotated");
        ImmutableSet.Builder builder2 = ImmutableSet.builder();
        for (AnnotationDescriptor annotationDescriptor : this.getSuppressionAnnotations(annotated)) {
            Intrinsics.checkNotNull((Object)builder2);
            this.processAnnotation((ImmutableSet.Builder<String>)builder2, annotationDescriptor);
        }
        ImmutableSet immutableSet = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"build(...)");
        return (Set)immutableSet;
    }

    private final void processAnnotation(ImmutableSet.Builder<String> builder2, AnnotationDescriptor annotationDescriptor) {
        if (!Intrinsics.areEqual((Object)annotationDescriptor.getFqName(), (Object)StandardNames.FqNames.suppress)) {
            return;
        }
        for (ConstantValue<?> arrayValue : annotationDescriptor.getAllValueArguments().values()) {
            if (!(arrayValue instanceof ArrayValue)) continue;
            for (ConstantValue value2 : (List)((ArrayValue)arrayValue).getValue()) {
                if (!(value2 instanceof StringValue)) continue;
                String string2 = ((String)((StringValue)value2).getValue()).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                builder2.add((Object)string2);
            }
        }
    }

    @Override
    protected boolean isSuppressed(@NotNull AbstractKotlinSuppressCache.SuppressRequest<PsiElement> request) {
        Intrinsics.checkNotNullParameter(request, (String)"request");
        PsiElement element = request.getElement();
        if (!element.isValid()) {
            return true;
        }
        PsiFile file2 = element.getContainingFile();
        if (file2 instanceof KtFile && KtPsiFactoryKt.getDoNotAnalyze((KtFile)file2) != null) {
            return true;
        }
        if (request instanceof DiagnosticSuppressRequest) {
            for (DiagnosticSuppressor suppressor : this.diagnosticSuppressors) {
                if (!this.isSuppressedByExtension(suppressor, ((DiagnosticSuppressRequest)request).getDiagnostic())) continue;
                return true;
            }
        }
        return super.isSuppressed(request);
    }

    @Override
    @Nullable
    protected PsiElement getClosestAnnotatedAncestorElement(@NotNull PsiElement element, @NotNull PsiElement rootElement, boolean excludeSelf) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)rootElement, (String)"rootElement");
        return (PsiElement)KtStubbedPsiUtil.getPsiOrStubParent(element, KtAnnotated.class, excludeSelf);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$Companion;", "", "()V", "getDiagnosticSuppressKey", "", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "getDiagnosticSuppressKey$frontend", "frontend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDiagnosticSuppressKey$frontend(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            String string2 = diagnostic.getFactory().getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            return string2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/diagnostics/KotlinSuppressCache$DiagnosticSuppressRequest;", "Lorg/jetbrains/kotlin/diagnostics/AbstractKotlinSuppressCache$SuppressRequest;", "Lcom/intellij/psi/PsiElement;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "(Lorg/jetbrains/kotlin/diagnostics/Diagnostic;)V", "getDiagnostic", "()Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "element", "getElement", "()Lcom/intellij/psi/PsiElement;", "rootElement", "getRootElement", "severity", "Lorg/jetbrains/kotlin/diagnostics/Severity;", "getSeverity", "()Lorg/jetbrains/kotlin/diagnostics/Severity;", "suppressKey", "", "getSuppressKey", "()Ljava/lang/String;", "frontend"})
    protected static final class DiagnosticSuppressRequest
    implements AbstractKotlinSuppressCache.SuppressRequest<PsiElement> {
        @NotNull
        private final Diagnostic diagnostic;

        public DiagnosticSuppressRequest(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            this.diagnostic = diagnostic;
        }

        @NotNull
        public final Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public PsiElement getElement() {
            return this.diagnostic.getPsiElement();
        }

        @Override
        @NotNull
        public PsiElement getRootElement() {
            PsiFile psiFile = this.getElement().getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
            return (PsiElement)psiFile;
        }

        @Override
        @NotNull
        public Severity getSeverity() {
            return this.diagnostic.getSeverity();
        }

        @Override
        @NotNull
        public String getSuppressKey() {
            return Companion.getDiagnosticSuppressKey$frontend(this.diagnostic);
        }
    }
}

