/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.serialization.deserialization;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentProviderKt;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.deserialization.ClassDescriptorFactory;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.BinaryVersion;
import org.jetbrains.kotlin.metadata.deserialization.NameResolver;
import org.jetbrains.kotlin.metadata.deserialization.TypeTable;
import org.jetbrains.kotlin.metadata.deserialization.VersionRequirementTable;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.serialization.deserialization.ClassData;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationComponents;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationContext;
import org.jetbrains.kotlin.serialization.deserialization.DeserializedPackageFragment;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedClassDescriptor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0002\u0010\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0007H\u0002J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\b2\u0006\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000fR\u001c\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer;", "", "components", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;", "(Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationComponents;)V", "classes", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "createClass", "key", "deserializeClass", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classData", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "ClassKey", "Companion", "deserialization"})
@SourceDebugExtension(value={"SMAP\nClassDeserializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassDeserializer.kt\norg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,91:1\n1#2:92\n295#3,2:93\n*S KotlinDebug\n*F\n+ 1 ClassDeserializer.kt\norg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer\n*L\n57#1:93,2\n*E\n"})
public final class ClassDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeserializationComponents components;
    @NotNull
    private final Function1<ClassKey, ClassDescriptor> classes;
    @NotNull
    private static final Set<ClassId> BLACK_LIST;

    public ClassDeserializer(@NotNull DeserializationComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.components = components2;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassKey, ClassDescriptor>(this){
            final /* synthetic */ ClassDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final ClassDescriptor invoke(ClassKey key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return ClassDeserializer.access$createClass(this.this$0, key);
            }
        });
    }

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassData classData) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return (ClassDescriptor)this.classes.invoke((Object)new ClassKey(classId, classData));
    }

    public static /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassData classData, int n, Object object) {
        if ((n & 2) != 0) {
            classData = null;
        }
        return classDeserializer.deserializeClass(classId, classData);
    }

    private final ClassDescriptor createClass(ClassKey key) {
        DeserializationContext deserializationContext;
        ClassId classId = key.getClassId();
        for (ClassDescriptorFactory factory2 : this.components.getFictitiousClassDescriptorFactories()) {
            ClassDescriptor classDescriptor2 = factory2.createClass(classId);
            if (classDescriptor2 == null) continue;
            ClassDescriptor it = classDescriptor2;
            boolean bl = false;
            return it;
        }
        if (BLACK_LIST.contains(classId)) {
            return null;
        }
        ClassData classData = key.getClassData();
        if (classData == null && (classData = this.components.getClassDataFinder().findClassData(classId)) == null) {
            return null;
        }
        ClassData classData2 = classData;
        NameResolver nameResolver2 = classData2.component1();
        ProtoBuf.Class classProto2 = classData2.component2();
        BinaryVersion metadataVersion2 = classData2.component3();
        SourceElement sourceElement = classData2.component4();
        ClassId outerClassId = classId.getOuterClassId();
        if (outerClassId != null) {
            ClassDescriptor classDescriptor3 = ClassDeserializer.deserializeClass$default(this, outerClassId, null, 2, null);
            DeserializedClassDescriptor deserializedClassDescriptor = classDescriptor3 instanceof DeserializedClassDescriptor ? (DeserializedClassDescriptor)classDescriptor3 : null;
            if (deserializedClassDescriptor == null) {
                return null;
            }
            DeserializedClassDescriptor outerClass = deserializedClassDescriptor;
            if (!outerClass.hasNestedClass$deserialization(classId.getShortClassName())) {
                return null;
            }
            deserializationContext = outerClass.getC();
        } else {
            Object v3;
            block9: {
                List<PackageFragmentDescriptor> fragments2 = PackageFragmentProviderKt.packageFragments(this.components.getPackageFragmentProvider(), classId.getPackageFqName());
                Iterable $this$firstOrNull$iv = fragments2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PackageFragmentDescriptor it = (PackageFragmentDescriptor)element$iv;
                    boolean bl = false;
                    if (!(!(it instanceof DeserializedPackageFragment) || ((DeserializedPackageFragment)it).hasTopLevelClass(classId.getShortClassName()))) continue;
                    v3 = element$iv;
                    break block9;
                }
                v3 = null;
            }
            PackageFragmentDescriptor packageFragmentDescriptor = v3;
            if (packageFragmentDescriptor == null) {
                return null;
            }
            PackageFragmentDescriptor fragment = packageFragmentDescriptor;
            ProtoBuf.TypeTable typeTable = classProto2.getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)typeTable, (String)"getTypeTable(...)");
            TypeTable typeTable2 = new TypeTable(typeTable);
            ProtoBuf.VersionRequirementTable versionRequirementTable = classProto2.getVersionRequirementTable();
            Intrinsics.checkNotNullExpressionValue((Object)versionRequirementTable, (String)"getVersionRequirementTable(...)");
            deserializationContext = this.components.createContext(fragment, nameResolver2, typeTable2, VersionRequirementTable.Companion.create(versionRequirementTable), metadataVersion2, null);
        }
        DeserializationContext outerContext = deserializationContext;
        return new DeserializedClassDescriptor(outerContext, classProto2, nameResolver2, metadataVersion2, sourceElement);
    }

    public static final /* synthetic */ ClassDescriptor access$createClass(ClassDeserializer $this, ClassKey key) {
        return $this.createClass(key);
    }

    static {
        FqName fqName2 = StandardNames.FqNames.cloneable.toSafe();
        Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"toSafe(...)");
        BLACK_LIST = SetsKt.setOf((Object)ClassId.Companion.topLevel(fqName2));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$ClassKey;", "", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "classData", "Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "(Lorg/jetbrains/kotlin/name/ClassId;Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;)V", "getClassData", "()Lorg/jetbrains/kotlin/serialization/deserialization/ClassData;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "equals", "", "other", "hashCode", "", "deserialization"})
    private static final class ClassKey {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final ClassData classData;

        public ClassKey(@NotNull ClassId classId, @Nullable ClassData classData) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            this.classId = classId;
            this.classData = classData;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final ClassData getClassData() {
            return this.classData;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassKey && Intrinsics.areEqual((Object)this.classId, (Object)((ClassKey)other).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/serialization/deserialization/ClassDeserializer$Companion;", "", "()V", "BLACK_LIST", "", "Lorg/jetbrains/kotlin/name/ClassId;", "getBLACK_LIST", "()Ljava/util/Set;", "deserialization"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ClassId> getBLACK_LIST() {
            return BLACK_LIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

