/*
 * Decompiled with CFR 0.152.
 */
package org.jline.builtins.ssh;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.sshd.common.channel.PtyMode;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.Signal;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.shell.ShellFactory;
import org.jline.builtins.ssh.Ssh;
import org.jline.terminal.Attributes;
import org.jline.terminal.Size;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

public class ShellFactoryImpl
implements ShellFactory {
    private final Consumer<Ssh.ShellParams> shell;

    public ShellFactoryImpl(Consumer<Ssh.ShellParams> shell) {
        this.shell = shell;
    }

    private static void flush(OutputStream ... streams) {
        for (OutputStream s : streams) {
            try {
                s.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    static void close(Closeable ... closeables) {
        for (Closeable c : closeables) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public Command createShell(ChannelSession session2) {
        return new ShellImpl();
    }

    public class ShellImpl
    implements Command {
        private InputStream in;
        private OutputStream out;
        private OutputStream err;
        private ExitCallback callback;
        private boolean closed;

        public void setInputStream(InputStream in) {
            this.in = in;
        }

        public void setOutputStream(OutputStream out) {
            this.out = out;
        }

        public void setErrorStream(OutputStream err) {
            this.err = err;
        }

        public void setExitCallback(ExitCallback callback) {
            this.callback = callback;
        }

        public void start(ChannelSession session2, Environment env) throws IOException {
            try {
                new Thread(() -> {
                    try {
                        this.run(session2, env);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }).start();
            }
            catch (Exception e) {
                throw new IOException("Unable to start shell", e);
            }
        }

        public void run(ChannelSession session2, Environment env) throws Exception {
            try {
                Terminal terminal = TerminalBuilder.builder().name("JLine SSH").type((String)env.getEnv().get("TERM")).system(false).streams(this.in, this.out).build();
                terminal.setSize(new Size(Integer.parseInt((String)env.getEnv().get("COLUMNS")), Integer.parseInt((String)env.getEnv().get("LINES"))));
                Attributes attr = terminal.getAttributes();
                for (Map.Entry e : env.getPtyModes().entrySet()) {
                    switch ((PtyMode)e.getKey()) {
                        case VINTR: {
                            attr.setControlChar(Attributes.ControlChar.VINTR, (Integer)e.getValue());
                            break;
                        }
                        case VQUIT: {
                            attr.setControlChar(Attributes.ControlChar.VQUIT, (Integer)e.getValue());
                            break;
                        }
                        case VERASE: {
                            attr.setControlChar(Attributes.ControlChar.VERASE, (Integer)e.getValue());
                            break;
                        }
                        case VKILL: {
                            attr.setControlChar(Attributes.ControlChar.VKILL, (Integer)e.getValue());
                            break;
                        }
                        case VEOF: {
                            attr.setControlChar(Attributes.ControlChar.VEOF, (Integer)e.getValue());
                            break;
                        }
                        case VEOL: {
                            attr.setControlChar(Attributes.ControlChar.VEOL, (Integer)e.getValue());
                            break;
                        }
                        case VEOL2: {
                            attr.setControlChar(Attributes.ControlChar.VEOL2, (Integer)e.getValue());
                            break;
                        }
                        case VSTART: {
                            attr.setControlChar(Attributes.ControlChar.VSTART, (Integer)e.getValue());
                            break;
                        }
                        case VSTOP: {
                            attr.setControlChar(Attributes.ControlChar.VSTOP, (Integer)e.getValue());
                            break;
                        }
                        case VSUSP: {
                            attr.setControlChar(Attributes.ControlChar.VSUSP, (Integer)e.getValue());
                            break;
                        }
                        case VDSUSP: {
                            attr.setControlChar(Attributes.ControlChar.VDSUSP, (Integer)e.getValue());
                            break;
                        }
                        case VREPRINT: {
                            attr.setControlChar(Attributes.ControlChar.VREPRINT, (Integer)e.getValue());
                            break;
                        }
                        case VWERASE: {
                            attr.setControlChar(Attributes.ControlChar.VWERASE, (Integer)e.getValue());
                            break;
                        }
                        case VLNEXT: {
                            attr.setControlChar(Attributes.ControlChar.VLNEXT, (Integer)e.getValue());
                            break;
                        }
                        case VSTATUS: {
                            attr.setControlChar(Attributes.ControlChar.VSTATUS, (Integer)e.getValue());
                            break;
                        }
                        case VDISCARD: {
                            attr.setControlChar(Attributes.ControlChar.VDISCARD, (Integer)e.getValue());
                            break;
                        }
                        case ECHO: {
                            attr.setLocalFlag(Attributes.LocalFlag.ECHO, (Integer)e.getValue() != 0);
                            break;
                        }
                        case ICANON: {
                            attr.setLocalFlag(Attributes.LocalFlag.ICANON, (Integer)e.getValue() != 0);
                            break;
                        }
                        case ISIG: {
                            attr.setLocalFlag(Attributes.LocalFlag.ISIG, (Integer)e.getValue() != 0);
                            break;
                        }
                        case ICRNL: {
                            attr.setInputFlag(Attributes.InputFlag.ICRNL, (Integer)e.getValue() != 0);
                            break;
                        }
                        case INLCR: {
                            attr.setInputFlag(Attributes.InputFlag.INLCR, (Integer)e.getValue() != 0);
                            break;
                        }
                        case IGNCR: {
                            attr.setInputFlag(Attributes.InputFlag.IGNCR, (Integer)e.getValue() != 0);
                            break;
                        }
                        case OCRNL: {
                            attr.setOutputFlag(Attributes.OutputFlag.OCRNL, (Integer)e.getValue() != 0);
                            break;
                        }
                        case ONLCR: {
                            attr.setOutputFlag(Attributes.OutputFlag.ONLCR, (Integer)e.getValue() != 0);
                            break;
                        }
                        case ONLRET: {
                            attr.setOutputFlag(Attributes.OutputFlag.ONLRET, (Integer)e.getValue() != 0);
                            break;
                        }
                        case OPOST: {
                            attr.setOutputFlag(Attributes.OutputFlag.OPOST, (Integer)e.getValue() != 0);
                        }
                    }
                }
                terminal.setAttributes(attr);
                env.addSignalListener((channel, signals) -> {
                    terminal.setSize(new Size(Integer.parseInt((String)env.getEnv().get("COLUMNS")), Integer.parseInt((String)env.getEnv().get("LINES"))));
                    terminal.raise(Terminal.Signal.WINCH);
                }, new Signal[]{Signal.WINCH});
                ShellFactoryImpl.this.shell.accept(new Ssh.ShellParams(env.getEnv(), session2.getSession(), terminal, () -> this.destroy(session2)));
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void destroy(ChannelSession session2) {
            if (!this.closed) {
                this.closed = true;
                ShellFactoryImpl.flush(new OutputStream[]{this.out, this.err});
                ShellFactoryImpl.close(this.in, this.out, this.err);
                this.callback.onExit(0);
            }
        }
    }
}

