/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.declaration;

import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirPackageDirective;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirPackageConflictsWithClassifierChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012*\u00020\u0013H\u0002\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirPackageConflictsWithClassifierChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirFileChecker;", "()V", "areDependentMultiplatformModules", "", "module1", "Lorg/jetbrains/kotlin/fir/FirModuleData;", "module2", "check", "", "declaration", "context", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "reporter", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "parentsIncludingSelf", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/name/FqName;", "checkers"})
public final class FirPackageConflictsWithClassifierChecker
extends FirDeclarationChecker<FirFile> {
    @NotNull
    public static final FirPackageConflictsWithClassifierChecker INSTANCE = new FirPackageConflictsWithClassifierChecker();

    private FirPackageConflictsWithClassifierChecker() {
        super(MppCheckerKind.Platform);
    }

    @Override
    public void check(@NotNull FirFile declaration, @NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter2, (String)"reporter");
        FirPackageDirective packageDirective = declaration.getPackageDirective();
        FqName filePackageFqName = packageDirective.getPackageFqName();
        for (FqName currentPackageFqName : this.parentsIncludingSelf(filePackageFqName)) {
            FirClassLikeSymbol<?> symbol2;
            if (currentPackageFqName.isRoot()) continue;
            FqName fqName2 = currentPackageFqName.parent();
            Intrinsics.checkNotNullExpressionValue((Object)fqName2, (String)"parent(...)");
            Name name2 = currentPackageFqName.shortName();
            Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"shortName(...)");
            ClassId classId = new ClassId(fqName2, name2);
            if (FirSymbolProviderKt.getSymbolProvider(context2.getSession()).getClassLikeSymbolByClassId(classId) == null || !(symbol2.getOrigin() instanceof FirDeclarationOrigin.Source) || !Intrinsics.areEqual((Object)symbol2.getModuleData(), (Object)declaration.getModuleData()) && !this.areDependentMultiplatformModules(symbol2.getModuleData(), declaration.getModuleData())) continue;
            KtDiagnosticReportHelpersKt.reportOn$default(reporter2, (AbstractKtSourceElement)packageDirective.getSource(), FirErrors.INSTANCE.getPACKAGE_CONFLICTS_WITH_CLASSIFIER(), (Object)classId, (DiagnosticContext)context2, null, 16, null);
        }
    }

    private final boolean areDependentMultiplatformModules(FirModuleData module1, FirModuleData module2) {
        return module2.getAllDependsOnDependencies().contains(module1) || module1.getAllDependsOnDependencies().contains(module2);
    }

    private final Sequence<FqName> parentsIncludingSelf(FqName $this$parentsIncludingSelf) {
        return SequencesKt.generateSequence((Object)$this$parentsIncludingSelf, (Function1)parentsIncludingSelf.1.INSTANCE);
    }
}

