/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.util;

import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.util.IdSignature;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\u000bH\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\fH\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\rH\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\u000eH\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\u000fH\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\u0010H\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\u0011H\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\u0012H\u0002J\u001c\u0010\u0005\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\u0006\u0010\u0007\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00060\tj\u0002`\n*\u00060\tj\u0002`\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/ir/util/IdSignatureRenderer;", "", "showDescriptionForPublicSignatures", "", "(Z)V", "render", "", "signature", "Lorg/jetbrains/kotlin/ir/util/IdSignature;", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$AccessorSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CommonSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$CompositeSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileLocalSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$FileSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$LocalSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$LoweredDeclarationSignature;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$ScopeLocalDeclaration;", "Lorg/jetbrains/kotlin/ir/util/IdSignature$SpecialFakeOverrideSignature;", "renderDescriptionForLocalSignature", "description", "Companion", "ir.tree"})
@SourceDebugExtension(value={"SMAP\nIdSignatureRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdSignatureRenderer.kt\norg/jetbrains/kotlin/ir/util/IdSignatureRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,110:1\n1#2:111\n*E\n"})
public final class IdSignatureRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean showDescriptionForPublicSignatures;
    @NotNull
    private static final IdSignatureRenderer DEFAULT = new IdSignatureRenderer(true);
    @NotNull
    private static final IdSignatureRenderer LEGACY = new IdSignatureRenderer(false);

    private IdSignatureRenderer(boolean showDescriptionForPublicSignatures) {
        this.showDescriptionForPublicSignatures = showDescriptionForPublicSignatures;
    }

    @NotNull
    public final String render(@NotNull IdSignature signature) {
        StringBuilder stringBuilder2;
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        StringBuilder $this$render_u24lambda_u240 = stringBuilder2 = new StringBuilder();
        boolean bl = false;
        this.render($this$render_u24lambda_u240, signature);
        String string2 = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature signature) {
        StringBuilder stringBuilder2;
        IdSignature idSignature = signature;
        if (idSignature instanceof IdSignature.CommonSignature) {
            stringBuilder2 = this.render($this$render, (IdSignature.CommonSignature)signature);
        } else if (idSignature instanceof IdSignature.AccessorSignature) {
            stringBuilder2 = this.render($this$render, (IdSignature.AccessorSignature)signature);
        } else if (idSignature instanceof IdSignature.CompositeSignature) {
            stringBuilder2 = this.render($this$render, (IdSignature.CompositeSignature)signature);
        } else if (idSignature instanceof IdSignature.FileSignature) {
            stringBuilder2 = this.render($this$render, (IdSignature.FileSignature)signature);
        } else if (idSignature instanceof IdSignature.LocalSignature) {
            stringBuilder2 = this.render($this$render, (IdSignature.LocalSignature)signature);
        } else if (idSignature instanceof IdSignature.FileLocalSignature) {
            stringBuilder2 = this.render($this$render, (IdSignature.FileLocalSignature)signature);
        } else if (idSignature instanceof IdSignature.ScopeLocalDeclaration) {
            stringBuilder2 = this.render($this$render, (IdSignature.ScopeLocalDeclaration)signature);
        } else if (idSignature instanceof IdSignature.SpecialFakeOverrideSignature) {
            stringBuilder2 = this.render($this$render, (IdSignature.SpecialFakeOverrideSignature)signature);
        } else if (idSignature instanceof IdSignature.LoweredDeclarationSignature) {
            stringBuilder2 = this.render($this$render, (IdSignature.LoweredDeclarationSignature)signature);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return stringBuilder2;
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.CommonSignature signature) {
        Object object;
        IdSignature.CommonSignature $this$render_u24lambda_u241 = signature;
        boolean bl = false;
        $this$render.append($this$render_u24lambda_u241.getPackageFqName()).append('/').append($this$render_u24lambda_u241.getDeclarationFqName()).append('|');
        if (this.showDescriptionForPublicSignatures) {
            object = signature.getDescription();
            if (object == null) {
                object = $this$render_u24lambda_u241.getId();
            }
        } else {
            object = $this$render_u24lambda_u241.getId();
        }
        $this$render.append(object);
        StringBuilder stringBuilder2 = $this$render.append('[');
        String string2 = Long.toString($this$render_u24lambda_u241.getMask(), CharsKt.checkRadix((int)2));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(']');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"with(...)");
        return stringBuilder3;
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.AccessorSignature signature) {
        return this.render($this$render, signature.getAccessorSignature());
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.CompositeSignature signature) {
        StringBuilder stringBuilder2 = $this$render.append("[ ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        StringBuilder stringBuilder3 = this.render(stringBuilder2, signature.getContainer()).append(" <- ");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder3, (String)"append(...)");
        StringBuilder stringBuilder4 = this.render(stringBuilder3, signature.getInner()).append(" ]");
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder4, (String)"append(...)");
        return stringBuilder4;
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.FileSignature signature) {
        StringBuilder stringBuilder2 = $this$render.append("File '").append(signature.getFileName()).append('\'');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(...)");
        return stringBuilder2;
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.LocalSignature signature) {
        IdSignature.LocalSignature $this$render_u24lambda_u243 = signature;
        boolean bl = false;
        $this$render.append("Local[").append($this$render_u24lambda_u243.getLocalFqn());
        Long l = $this$render_u24lambda_u243.getHashSig();
        if (l != null) {
            long it = ((Number)l).longValue();
            boolean bl2 = false;
            $this$render.append(",").append($this$render_u24lambda_u243.getHashSig());
        }
        this.renderDescriptionForLocalSignature($this$render, $this$render_u24lambda_u243.getDescription());
        StringBuilder stringBuilder2 = $this$render.append(']');
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"with(...)");
        return stringBuilder2;
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.FileLocalSignature signature) {
        IdSignature.FileLocalSignature $this$render_u24lambda_u244 = signature;
        boolean bl = false;
        this.render($this$render, $this$render_u24lambda_u244.getContainer()).append(':').append($this$render_u24lambda_u244.getId());
        return this.renderDescriptionForLocalSignature($this$render, $this$render_u24lambda_u244.getDescription());
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.ScopeLocalDeclaration signature) {
        IdSignature.ScopeLocalDeclaration $this$render_u24lambda_u245 = signature;
        boolean bl = false;
        $this$render.append('#').append($this$render_u24lambda_u245.getId());
        return this.renderDescriptionForLocalSignature($this$render, $this$render_u24lambda_u245.getDescription());
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.SpecialFakeOverrideSignature signature) {
        return this.render($this$render, signature.getMemberSignature());
    }

    private final StringBuilder render(StringBuilder $this$render, IdSignature.LoweredDeclarationSignature signature) {
        IdSignature.LoweredDeclarationSignature $this$render_u24lambda_u246 = signature;
        boolean bl = false;
        $this$render.append("ic#").append($this$render_u24lambda_u246.getStage()).append(':');
        this.render($this$render, $this$render_u24lambda_u246.getOriginal());
        StringBuilder stringBuilder2 = $this$render.append('-').append($this$render_u24lambda_u246.getIndex());
        Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"with(...)");
        return stringBuilder2;
    }

    private final StringBuilder renderDescriptionForLocalSignature(StringBuilder $this$renderDescriptionForLocalSignature, String description2) {
        block0: {
            String string2 = description2;
            if (string2 == null) break block0;
            String it = string2;
            boolean bl = false;
            $this$renderDescriptionForLocalSignature.append('|').append(description2);
        }
        return $this$renderDescriptionForLocalSignature;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/ir/util/IdSignatureRenderer$Companion;", "", "()V", "DEFAULT", "Lorg/jetbrains/kotlin/ir/util/IdSignatureRenderer;", "getDEFAULT", "()Lorg/jetbrains/kotlin/ir/util/IdSignatureRenderer;", "LEGACY", "getLEGACY", "ir.tree"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdSignatureRenderer getDEFAULT() {
            return DEFAULT;
        }

        @NotNull
        public final IdSignatureRenderer getLEGACY() {
            return LEGACY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

