/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.native.checkers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirPlatformSpecificCastChecker;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.analysis.native.checkers.FirNativeHelpersKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016J\u0018\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\tH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/native/checkers/FirNativeCastChecker;", "Lorg/jetbrains/kotlin/fir/FirPlatformSpecificCastChecker;", "<init>", "()V", "shouldSuppressImpossibleCast", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "fromType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "toType", "isCastToAForwardDeclaration", "forwardDeclarationType", "checkers.native"})
public final class FirNativeCastChecker
extends FirPlatformSpecificCastChecker {
    @NotNull
    public static final FirNativeCastChecker INSTANCE = new FirNativeCastChecker();

    private FirNativeCastChecker() {
    }

    @Override
    public boolean shouldSuppressImpossibleCast(@NotNull FirSession session2, @NotNull ConeKotlinType fromType, @NotNull ConeKotlinType toType) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)fromType, (String)"fromType");
        Intrinsics.checkNotNullParameter((Object)toType, (String)"toType");
        return this.isCastToAForwardDeclaration(session2, toType);
    }

    private final boolean isCastToAForwardDeclaration(FirSession session2, ConeKotlinType forwardDeclarationType) {
        FirRegularClassSymbol firRegularClassSymbol = ToSymbolUtilsKt.toRegularClassSymbol(forwardDeclarationType, session2);
        return (firRegularClassSymbol != null ? FirNativeHelpersKt.forwardDeclarationKindOrNull(firRegularClassSymbol) : null) != null;
    }
}

