/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.project.structure.builder;

import com.intellij.mock.MockProject;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.local.CoreLocalFileSystem;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaModule;
import org.jetbrains.kotlin.analysis.api.projectStructure.KaSourceModule;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilder;
import org.jetbrains.kotlin.analysis.project.structure.builder.KtModuleBuilderDsl;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaModuleUtilsKt;
import org.jetbrains.kotlin.analysis.project.structure.impl.KaSourceModuleImpl;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreProjectEnvironment;
import org.jetbrains.kotlin.config.ApiVersion;
import org.jetbrains.kotlin.config.LanguageVersion;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.config.LanguageVersionSettingsImpl;
import org.jetbrains.kotlin.platform.TargetPlatform;

@KtModuleBuilderDsl
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0014J\u0014\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u001cJ\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0016J\u0014\u0010\u001f\u001a\u00020\u00182\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00160\u001cJ\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00160$H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder;", "Lorg/jetbrains/kotlin/analysis/project/structure/builder/KtModuleBuilder;", "kotlinCoreProjectEnvironment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;", "<init>", "(Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreProjectEnvironment;)V", "moduleName", "", "getModuleName", "()Ljava/lang/String;", "setModuleName", "(Ljava/lang/String;)V", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "getLanguageVersionSettings", "()Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "setLanguageVersionSettings", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "sourceRoots", "", "Ljava/nio/file/Path;", "sourceVirtualFiles", "Lcom/intellij/openapi/vfs/VirtualFile;", "addSourceRoot", "", "path", "addSourceRoots", "paths", "", "addSourceVirtualFile", "virtualFile", "addSourceVirtualFiles", "virtualFiles", "build", "Lorg/jetbrains/kotlin/analysis/api/projectStructure/KaSourceModule;", "collectVirtualFilesByRoots", "", "analysis-api-standalone"})
@SourceDebugExtension(value={"SMAP\nKaSourceModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KaSourceModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,97:1\n1611#2,9:98\n1863#2:107\n1864#2:109\n1620#2:110\n1010#2,2:111\n1#3:108\n*S KotlinDebug\n*F\n+ 1 KaSourceModuleBuilder.kt\norg/jetbrains/kotlin/analysis/project/structure/builder/KtSourceModuleBuilder\n*L\n56#1:98,9\n56#1:107\n56#1:109\n56#1:110\n86#1:111,2\n56#1:108\n*E\n"})
public final class KtSourceModuleBuilder
extends KtModuleBuilder {
    @NotNull
    private final KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment;
    public String moduleName;
    @NotNull
    private LanguageVersionSettings languageVersionSettings;
    @NotNull
    private final List<Path> sourceRoots;
    @NotNull
    private final List<VirtualFile> sourceVirtualFiles;

    public KtSourceModuleBuilder(@NotNull KotlinCoreProjectEnvironment kotlinCoreProjectEnvironment) {
        Intrinsics.checkNotNullParameter((Object)((Object)kotlinCoreProjectEnvironment), (String)"kotlinCoreProjectEnvironment");
        this.kotlinCoreProjectEnvironment = kotlinCoreProjectEnvironment;
        this.languageVersionSettings = new LanguageVersionSettingsImpl(LanguageVersion.LATEST_STABLE, ApiVersion.LATEST, null, null, 12, null);
        this.sourceRoots = new ArrayList();
        this.sourceVirtualFiles = new ArrayList();
    }

    @NotNull
    public final String getModuleName() {
        String string2 = this.moduleName;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"moduleName");
        return null;
    }

    public final void setModuleName(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.moduleName = string2;
    }

    @NotNull
    public final LanguageVersionSettings getLanguageVersionSettings() {
        return this.languageVersionSettings;
    }

    public final void setLanguageVersionSettings(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"<set-?>");
        this.languageVersionSettings = languageVersionSettings;
    }

    public final void addSourceRoot(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.sourceRoots.add(path);
    }

    public final void addSourceRoots(@NotNull Collection<? extends Path> paths) {
        Intrinsics.checkNotNullParameter(paths, (String)"paths");
        this.sourceRoots.addAll(paths);
    }

    public final void addSourceVirtualFile(@NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        this.sourceVirtualFiles.add(virtualFile);
    }

    public final void addSourceVirtualFiles(@NotNull Collection<? extends VirtualFile> virtualFiles) {
        Intrinsics.checkNotNullParameter(virtualFiles, (String)"virtualFiles");
        this.sourceVirtualFiles.addAll(virtualFiles);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public KaSourceModule build() {
        void $this$mapNotNullTo$iv$iv;
        List<VirtualFile> virtualFiles = this.collectVirtualFilesByRoots();
        PsiManager psiManager = PsiManager.getInstance((Project)((Project)this.kotlinCoreProjectEnvironment.getProject()));
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        Iterable $this$mapNotNull$iv = virtualFiles;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PsiFile it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            VirtualFile it = (VirtualFile)element$iv$iv;
            boolean bl2 = false;
            if (psiManager2.findFile(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List psiFiles = (List)destination$iv$iv;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.filesScope((Project)((Project)this.kotlinCoreProjectEnvironment.getProject()), (Collection)virtualFiles);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"filesScope(...)");
        GlobalSearchScope contentScope = globalSearchScope;
        List<KaModule> list = this.getDirectRegularDependencies();
        List<KaModule> list2 = this.getDirectDependsOnDependencies();
        List<KaModule> list3 = this.getDirectFriendDependencies();
        TargetPlatform targetPlatform = this.getPlatform();
        MockProject mockProject = this.kotlinCoreProjectEnvironment.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)mockProject, (String)"getProject(...)");
        return new KaSourceModuleImpl(list, list2, list3, contentScope, targetPlatform, (Project)mockProject, this.getModuleName(), this.languageVersionSettings, psiFiles);
    }

    private final List<VirtualFile> collectVirtualFilesByRoots() {
        List list;
        CoreLocalFileSystem coreLocalFileSystem = this.kotlinCoreProjectEnvironment.getEnvironment().getLocalFileSystem();
        Intrinsics.checkNotNullExpressionValue((Object)coreLocalFileSystem, (String)"getLocalFileSystem(...)");
        CoreLocalFileSystem localFileSystem = coreLocalFileSystem;
        List $this$collectVirtualFilesByRoots_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Path root : this.sourceRoots) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            List files2 = Files.isDirectory(root, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? KaModuleUtilsKt.collectSourceFilePaths(root) : (KaModuleUtilsKt.hasSuitableExtensionToAnalyse(root) ? CollectionsKt.listOf((Object)root) : CollectionsKt.emptyList());
            for (Path file2 : files2) {
                VirtualFile virtualFile;
                if (localFileSystem.findFileByNioFile(file2.toAbsolutePath()) == null) continue;
                $this$collectVirtualFilesByRoots_u24lambda_u242.add(virtualFile);
            }
        }
        $this$collectVirtualFilesByRoots_u24lambda_u242.addAll((Collection)this.sourceVirtualFiles);
        List $this$sortBy$iv = $this$collectVirtualFilesByRoots_u24lambda_u242;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    VirtualFile it = (VirtualFile)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPath());
                    it = (VirtualFile)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getPath())));
                }
            });
        }
        return CollectionsKt.build((List)list);
    }
}

