/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.api.descriptors.symbols.pointers;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaImplementationDetail;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.descriptors.Fe10AnalysisContext;
import org.jetbrains.kotlin.analysis.api.descriptors.KaFe10Session;
import org.jetbrains.kotlin.analysis.api.descriptors.symbols.descriptorBased.KaFe10DescSamConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSamConstructorSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.KaSymbol;
import org.jetbrains.kotlin.analysis.api.symbols.pointers.KaSymbolPointer;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FindClassInModuleKt;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.load.java.sam.JvmSamConversionOracle;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.sam.SamConstructorDescriptor;
import org.jetbrains.kotlin.resolve.sam.SamConstructorUtilsKt;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolver;
import org.jetbrains.kotlin.resolve.sam.SamConversionResolverImplKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0017J\u0016\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/analysis/api/descriptors/symbols/pointers/KaFe10DescSamConstructorSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/pointers/KaSymbolPointer;", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSamConstructorSymbol;", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "<init>", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "restoreSymbol", "analysisSession", "Lorg/jetbrains/kotlin/analysis/api/KaSession;", "pointsToTheSameSymbolAs", "", "other", "Lorg/jetbrains/kotlin/analysis/api/symbols/KaSymbol;", "analysis-api-fe10"})
public final class KaFe10DescSamConstructorSymbolPointer
extends KaSymbolPointer<KaSamConstructorSymbol> {
    @NotNull
    private final ClassId classId;

    public KaFe10DescSamConstructorSymbolPointer(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        this.classId = classId;
    }

    @Override
    @KaImplementationDetail
    @Nullable
    public KaSamConstructorSymbol restoreSymbol(@NotNull KaSession analysisSession) {
        Intrinsics.checkNotNullParameter((Object)analysisSession, (String)"analysisSession");
        if (!(analysisSession instanceof KaFe10Session)) {
            throw new IllegalStateException("Check failed.");
        }
        Fe10AnalysisContext analysisContext = ((KaFe10Session)analysisSession).getAnalysisContext();
        ModuleDescriptor moduleDescriptor = analysisContext.getResolveSession().getModuleDescriptor();
        Intrinsics.checkNotNullExpressionValue((Object)moduleDescriptor, (String)"<get-moduleDescriptor>(...)");
        ClassDescriptor samInterface = FindClassInModuleKt.findClassAcrossModuleDependencies(moduleDescriptor, this.classId);
        if (samInterface == null || SamConversionResolverImplKt.getSingleAbstractMethodOrNull(samInterface) == null) {
            return null;
        }
        DeclarationDescriptor declarationDescriptor = samInterface.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"getContainingDeclaration(...)");
        SamConversionResolver samConversionResolver = analysisContext.getResolveSession().getSamConversionResolver();
        Intrinsics.checkNotNullExpressionValue((Object)samConversionResolver, (String)"<get-samConversionResolver>(...)");
        LanguageVersionSettings languageVersionSettings = analysisContext.getResolveSession().getLanguageVersionSettings();
        Intrinsics.checkNotNullExpressionValue((Object)languageVersionSettings, (String)"<get-languageVersionSettings>(...)");
        SamConstructorDescriptor constructorDescriptor = SamConstructorUtilsKt.createSamConstructorFunction(declarationDescriptor, samInterface, samConversionResolver, new JvmSamConversionOracle(languageVersionSettings));
        return new KaFe10DescSamConstructorSymbol(constructorDescriptor, analysisContext);
    }

    @Override
    public boolean pointsToTheSameSymbolAs(@NotNull KaSymbolPointer<? extends KaSymbol> other) {
        Intrinsics.checkNotNullParameter(other, (String)"other");
        return this == other || other instanceof KaFe10DescSamConstructorSymbolPointer && Intrinsics.areEqual((Object)((KaFe10DescSamConstructorSymbolPointer)other).classId, (Object)this.classId);
    }
}

