/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import org.jetbrains.annotations.NotNull;

public class PsiReferenceWrapper
implements PsiReference {
    private final PsiReference myOriginalPsiReference;

    public PsiReferenceWrapper(PsiReference originalPsiReference) {
        this.myOriginalPsiReference = originalPsiReference;
    }

    @Override
    public PsiElement getElement() {
        return this.myOriginalPsiReference.getElement();
    }

    @Override
    public TextRange getRangeInElement() {
        return this.myOriginalPsiReference.getRangeInElement();
    }

    @Override
    public PsiElement resolve() {
        return this.myOriginalPsiReference.resolve();
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string = this.myOriginalPsiReference.getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/PsiReferenceWrapper", "getCanonicalText"));
        }
        return string;
    }

    @Override
    public boolean isSoft() {
        return this.myOriginalPsiReference.isSoft();
    }

    public <T extends PsiReference> boolean isInstance(Class<T> clazz) {
        if (this.myOriginalPsiReference instanceof PsiReferenceWrapper) {
            return ((PsiReferenceWrapper)this.myOriginalPsiReference).isInstance(clazz);
        }
        return clazz.isInstance(this.myOriginalPsiReference);
    }

    public <T extends PsiReference> T cast(Class<T> clazz) {
        if (this.myOriginalPsiReference instanceof PsiReferenceWrapper) {
            return ((PsiReferenceWrapper)this.myOriginalPsiReference).cast(clazz);
        }
        return (T)((PsiReference)clazz.cast(this.myOriginalPsiReference));
    }
}

