/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiLambdaNameHelper {
    private static final Key<ParameterizedCachedValue<Map<PsiLambdaExpression, String>, PsiClass>> LAMBDA_NAME = Key.create("ANONYMOUS_CLASS_NAME");

    @Nullable
    public static String getVMName(@NotNull PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "com/intellij/ide/util/PsiLambdaNameHelper", "getVMName"));
        }
        PsiClass upper = PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiClass.class);
        if (upper == null) {
            return null;
        }
        ParameterizedCachedValue<Map<PsiLambdaExpression, String>, PsiClass> value2 = upper.getUserData(LAMBDA_NAME);
        if (value2 == null) {
            value2 = CachedValuesManager.getManager(upper.getProject()).createParameterizedCachedValue(new ParameterizedCachedValueProvider<Map<PsiLambdaExpression, String>, PsiClass>(){

                @Override
                public CachedValueProvider.Result<Map<PsiLambdaExpression, String>> compute(PsiClass upper) {
                    THashMap map2 = new THashMap();
                    upper.accept(new JavaRecursiveElementWalkingVisitor((Map)map2, upper){
                        int index;
                        final /* synthetic */ Map val$map;
                        final /* synthetic */ PsiClass val$upper;
                        {
                            this.val$map = map2;
                            this.val$upper = psiClass;
                        }

                        @Override
                        public void visitLambdaExpression(PsiLambdaExpression expression2) {
                            this.val$map.put(expression2, "$" + this.index++);
                            super.visitLambdaExpression(expression2);
                        }

                        @Override
                        public void visitClass(PsiClass aClass) {
                            if (aClass == this.val$upper) {
                                super.visitClass(aClass);
                            }
                        }
                    });
                    return CachedValueProvider.Result.create(map2, upper);
                }
            }, false);
            upper.putUserData(LAMBDA_NAME, value2);
        }
        return "lambda" + PsiLambdaNameHelper.getLambdaPrefix(lambdaExpression) + value2.getValue(upper).get(lambdaExpression);
    }

    public static String getLambdaPrefix(@NotNull PsiLambdaExpression lambdaExpression) {
        if (lambdaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lambdaExpression", "com/intellij/ide/util/PsiLambdaNameHelper", "getLambdaPrefix"));
        }
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)lambdaExpression, PsiMethod.class, PsiClass.class, PsiField.class);
        String methodPrefix = member instanceof PsiMethod ? (member.getContainingClass() instanceof PsiAnonymousClass ? "" : "$" + member.getName()) : (member instanceof PsiField && member.getContainingClass() instanceof PsiAnonymousClass ? "" : "$new");
        return methodPrefix;
    }
}

