/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class FrequentEventDetector {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.diagnostic.FrequentEventDetector");
    private long myStartedCounting;
    private final AtomicInteger myEventsPosted;
    private final AtomicInteger myLastTraceId;
    private final Map<String, Integer> myRecentTraces;
    private final int myEventCountThreshold;
    private final int myTimeSpanMs;
    private final Level myLevel;
    private static boolean enabled = true;

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs) {
        this(eventCountThreshold, timeSpanMs, Level.INFO);
    }

    public FrequentEventDetector(int eventCountThreshold, int timeSpanMs, @NotNull Level level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/openapi/diagnostic/FrequentEventDetector", "<init>"));
        }
        this.myStartedCounting = System.currentTimeMillis();
        this.myEventsPosted = new AtomicInteger();
        this.myLastTraceId = new AtomicInteger();
        this.myRecentTraces = new LinkedHashMap<String, Integer>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<String, Integer> eldest) {
                return this.size() > 50;
            }
        };
        this.myEventCountThreshold = eventCountThreshold;
        this.myTimeSpanMs = timeSpanMs;
        this.myLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void eventHappened(@NotNull Object event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/diagnostic/FrequentEventDetector", "eventHappened"));
        }
        if (!enabled) {
            return;
        }
        if (this.myEventsPosted.incrementAndGet() > this.myEventCountThreshold) {
            boolean shouldLog = false;
            AtomicInteger atomicInteger = this.myEventsPosted;
            synchronized (atomicInteger) {
                if (this.myEventsPosted.get() > this.myEventCountThreshold) {
                    long timeNow = System.currentTimeMillis();
                    shouldLog = timeNow - this.myStartedCounting < (long)this.myTimeSpanMs;
                    this.myEventsPosted.set(0);
                    this.myStartedCounting = timeNow;
                }
            }
            if (shouldLog) {
                int traceId;
                boolean logTrace;
                String trace = ExceptionUtil.getThrowableText(new Throwable());
                AtomicInteger atomicInteger2 = this.myEventsPosted;
                synchronized (atomicInteger2) {
                    Integer existingTraceId = this.myRecentTraces.get(trace);
                    boolean bl = logTrace = existingTraceId == null;
                    if (logTrace) {
                        traceId = this.myLastTraceId.incrementAndGet();
                        this.myRecentTraces.put(trace, traceId);
                    } else {
                        traceId = existingTraceId;
                    }
                }
                String message2 = "Too many events posted, #" + traceId + ". Event: " + event + (logTrace ? "\n" + trace : "");
                if (this.myLevel == Level.INFO) {
                    LOG.info(message2);
                } else if (this.myLevel == Level.WARN) {
                    LOG.warn(message2);
                } else {
                    LOG.error(message2);
                }
            }
        }
    }

    public static void disableUntil(@NotNull Disposable reenable) {
        if (reenable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reenable", "com/intellij/openapi/diagnostic/FrequentEventDetector", "disableUntil"));
        }
        enabled = false;
        Disposer.register(reenable, new Disposable(){

            @Override
            public void dispose() {
                enabled = true;
            }
        });
    }

    public static enum Level {
        INFO,
        WARN,
        ERROR;

    }
}

