/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.processing;

import com.intellij.openapi.diff.ex.DiffFragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.util.TextDiffTypeEnum;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class LineFragmentsCollector {
    private final ArrayList<LineFragment> myLineFragments = new ArrayList();
    private int myLine1 = 0;
    private int myLine2 = 0;
    private int myOffset1 = 0;
    private int myOffset2 = 0;

    LineFragmentsCollector() {
    }

    @NotNull
    private LineFragment addFragment(@Nullable TextDiffTypeEnum type2, @Nullable DiffString text1, @Nullable DiffString text2) {
        int lines1 = LineFragmentsCollector.countLines(text1);
        int lines2 = LineFragmentsCollector.countLines(text2);
        int endOffset1 = this.myOffset1 + LineFragmentsCollector.getLength(text1);
        int endOffset2 = this.myOffset2 + LineFragmentsCollector.getLength(text2);
        LineFragment lineFragment = new LineFragment(this.myLine1, lines1, this.myLine2, lines2, type2, new TextRange(this.myOffset1, endOffset1), new TextRange(this.myOffset2, endOffset2));
        this.myLine1 += lines1;
        this.myLine2 += lines2;
        this.myOffset1 = endOffset1;
        this.myOffset2 = endOffset2;
        this.myLineFragments.add(lineFragment);
        LineFragment lineFragment2 = lineFragment;
        if (lineFragment2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/LineFragmentsCollector", "addFragment"));
        }
        return lineFragment2;
    }

    @NotNull
    public LineFragment addDiffFragment(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/processing/LineFragmentsCollector", "addDiffFragment"));
        }
        LineFragment lineFragment = this.addFragment(LineFragmentsCollector.getType(fragment), fragment.getText1(), fragment.getText2());
        if (lineFragment == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/processing/LineFragmentsCollector", "addDiffFragment"));
        }
        return lineFragment;
    }

    static int getLength(@Nullable DiffString text) {
        return text == null ? 0 : text.length();
    }

    private static int countLines(@Nullable DiffString text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        int count = StringUtil.countNewLines(text);
        if (text.charAt(text.length() - 1) != '\n') {
            ++count;
        }
        return count;
    }

    public ArrayList<LineFragment> getFragments() {
        return this.myLineFragments;
    }

    @Nullable
    static TextDiffTypeEnum getType(@NotNull DiffFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/processing/LineFragmentsCollector", "getType"));
        }
        TextDiffTypeEnum type2 = fragment.getText1() == null ? TextDiffTypeEnum.INSERT : (fragment.getText2() == null ? TextDiffTypeEnum.DELETED : (fragment.isModified() ? TextDiffTypeEnum.CHANGED : null));
        return type2;
    }
}

