/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AsyncResult;
import com.intellij.util.concurrency.AtomicFieldUpdater;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AsyncValueLoaderManager<HOST, VALUE> {
    private final AtomicFieldUpdater<HOST, AsyncResult<VALUE>> fieldUpdater;

    public AsyncValueLoaderManager(@NotNull AtomicFieldUpdater<HOST, AsyncResult<VALUE>> fieldUpdater) {
        if (fieldUpdater == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldUpdater", "com/intellij/openapi/util/AsyncValueLoaderManager", "<init>"));
        }
        this.fieldUpdater = fieldUpdater;
    }

    public AsyncValueLoaderManager(@NotNull Class<HOST> ownerClass) {
        if (ownerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ownerClass", "com/intellij/openapi/util/AsyncValueLoaderManager", "<init>"));
        }
        this.fieldUpdater = AtomicFieldUpdater.forFieldOfType(ownerClass, AsyncResult.class);
    }

    public boolean isUpToDate(@NotNull HOST host, @NotNull VALUE value2) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/openapi/util/AsyncValueLoaderManager", "isUpToDate"));
        }
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/AsyncValueLoaderManager", "isUpToDate"));
        }
        return true;
    }

    public abstract void load(@NotNull HOST var1, @NotNull AsyncResult<VALUE> var2);

    public final void reset(HOST host) {
        this.fieldUpdater.set(host, null);
    }

    public final void set(HOST host, @Nullable VALUE value2) {
        if (value2 == null) {
            this.reset(host);
        } else {
            this.getOrCreateAsyncResult(host, false, false).setDone(value2);
        }
    }

    public final boolean has(HOST host) {
        AsyncResult<VALUE> result = this.fieldUpdater.get(host);
        return result != null && result.isDone() && result.getResult() != null;
    }

    @NotNull
    public final AsyncResult<VALUE> get(HOST host) {
        AsyncResult<VALUE> asyncResult = this.get(host, true);
        if (asyncResult == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/AsyncValueLoaderManager", "get"));
        }
        return asyncResult;
    }

    public final AsyncResult<VALUE> get(HOST host, boolean checkFreshness) {
        return this.getOrCreateAsyncResult(host, checkFreshness, true);
    }

    private AsyncResult<VALUE> getOrCreateAsyncResult(HOST host, boolean checkFreshness, boolean load) {
        AsyncResult<Object> asyncResult = this.fieldUpdater.get(host);
        if (asyncResult == null) {
            asyncResult = new AsyncResult();
            if (!this.fieldUpdater.compareAndSet(host, null, asyncResult)) {
                return this.fieldUpdater.get(host);
            }
        } else {
            if (!asyncResult.isProcessed()) {
                return asyncResult;
            }
            if (asyncResult.isDone()) {
                if (!checkFreshness || this.isUpToDate(host, asyncResult.getResult())) {
                    return asyncResult;
                }
                if (!this.fieldUpdater.compareAndSet(host, asyncResult, asyncResult = new AsyncResult())) {
                    AsyncResult<VALUE> valueFromAnotherThread = this.fieldUpdater.get(host);
                    while (valueFromAnotherThread == null) {
                        if (this.fieldUpdater.compareAndSet(host, null, asyncResult)) {
                            if (load) {
                                this.load(host, asyncResult);
                            }
                            return asyncResult;
                        }
                        valueFromAnotherThread = this.fieldUpdater.get(host);
                    }
                    return valueFromAnotherThread;
                }
            }
        }
        if (load) {
            this.load(host, asyncResult);
        }
        return asyncResult;
    }
}

