/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.NullableComputable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Computable<T> {
    public T compute();

    @Deprecated
    public static abstract class NullableCachedComputable<T>
    implements NullableComputable<T> {
        private static final Object NULL_VALUE = new Object();
        private Object myValue;

        @Nullable
        protected abstract T internalCompute();

        @Override
        @Nullable
        public final T compute() {
            if (this.myValue == null) {
                T value2 = this.internalCompute();
                this.myValue = value2 != null ? value2 : NULL_VALUE;
            }
            return (T)(this.myValue != NULL_VALUE ? this.myValue : null);
        }
    }

    @Deprecated
    public static abstract class NotNullCachedComputable<T>
    implements NotNullComputable<T> {
        private T myValue;

        @NotNull
        protected abstract T internalCompute();

        @Override
        @NotNull
        public final T compute() {
            if (this.myValue == null) {
                this.myValue = this.internalCompute();
            }
            T t = this.myValue;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/Computable$NotNullCachedComputable", "compute"));
            }
            return t;
        }
    }

    public static class PredefinedValueComputable<T>
    implements Computable<T> {
        private final T myValue;

        public PredefinedValueComputable(@Nullable T value2) {
            this.myValue = value2;
        }

        @Override
        public T compute() {
            return this.myValue;
        }
    }
}

