/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import org.jetbrains.annotations.NotNull;

public abstract class VolatileNotNullLazyValue<T>
extends NotNullLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("VolatileNotNullLazyValue");
    private volatile T myValue;

    @Override
    @NotNull
    public final T getValue() {
        T value2 = this.myValue;
        if (value2 == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            value2 = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = value2;
            }
        }
        T t = value2;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/VolatileNotNullLazyValue", "getValue"));
        }
        return t;
    }

    @Override
    public boolean isComputed() {
        return this.myValue != null;
    }

    @NotNull
    public static <T> VolatileNotNullLazyValue<T> createValue(final @NotNull NotNullFactory<T> value2) {
        if (value2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/openapi/util/VolatileNotNullLazyValue", "createValue"));
        }
        VolatileNotNullLazyValue volatileNotNullLazyValue = new VolatileNotNullLazyValue<T>(){

            @Override
            @NotNull
            protected T compute() {
                Object t = value2.create();
                if (t == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/VolatileNotNullLazyValue$1", "compute"));
                }
                return t;
            }
        };
        if (volatileNotNullLazyValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/VolatileNotNullLazyValue", "createValue"));
        }
        return volatileNotNullLazyValue;
    }
}

