/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class Registry {
    private static Reference<ResourceBundle> ourBundle;
    @NonNls
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final ConcurrentMap<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private static final Registry ourInstance;

    @NotNull
    public static RegistryValue get(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/Registry", "get"));
        }
        Registry registry = Registry.getInstance();
        RegistryValue value2 = (RegistryValue)registry.myValues.get(key);
        if (value2 == null) {
            value2 = ConcurrencyUtil.cacheOrGet(registry.myValues, key, new RegistryValue(registry, key));
        }
        RegistryValue registryValue = value2;
        if (registryValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/Registry", "get"));
        }
        return registryValue;
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/Registry", "is"));
        }
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, boolean defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/Registry", "is"));
        }
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/Registry", "intValue"));
        }
        return Registry.get(key).asInteger();
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, int defaultValue) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/Registry", "intValue"));
        }
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static double doubleValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/Registry", "doubleValue"));
        }
        return Registry.get(key).asDouble();
    }

    @NotNull
    public static String stringValue(@PropertyKey(resourceBundle="misc.registry") @NotNull String key) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/Registry", "stringValue"));
        }
        String string = Registry.get(key).asString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/Registry", "stringValue"));
        }
        return string;
    }

    public static Color getColor(@PropertyKey(resourceBundle="misc.registry") @NotNull String key, Color defaultValue) throws MissingResourceException {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/openapi/util/registry/Registry", "getColor"));
        }
        return Registry.get(key).asColor(defaultValue);
    }

    @NotNull
    static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(REGISTRY_BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        ResourceBundle resourceBundle = bundle;
        if (resourceBundle == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/Registry", "getBundle"));
        }
        return resourceBundle;
    }

    @NotNull
    public static Registry getInstance() {
        Registry registry = ourInstance;
        if (registry == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/Registry", "getInstance"));
        }
        return registry;
    }

    @NotNull
    public Element getState() {
        Element state = new Element("registry");
        for (String eachKey : this.myUserProperties.keySet()) {
            Element entry = new Element("entry");
            entry.setAttribute("key", eachKey);
            entry.setAttribute("value", this.myUserProperties.get(eachKey));
            state.addContent(entry);
        }
        Element element = state;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/Registry", "getState"));
        }
        return element;
    }

    public void loadState(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/util/registry/Registry", "loadState"));
        }
        this.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value2 = eachEntry.getAttributeValue("value");
            if (key == null || value2 == null || !(registryValue = Registry.get(key)).isChangedFromDefault(value2)) continue;
            this.myUserProperties.put(key, value2);
            registryValue.resetCache();
        }
    }

    @NotNull
    Map<String, String> getUserProperties() {
        Map<String, String> map2 = this.myUserProperties;
        if (map2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/Registry", "getUserProperties"));
        }
        return map2;
    }

    @NotNull
    public static List<RegistryValue> getAll() {
        ResourceBundle bundle = Registry.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
        while (keys.hasMoreElements()) {
            String each = keys.nextElement();
            if (each.endsWith(".description") || each.endsWith(".restartRequired")) continue;
            result.add(Registry.get(each));
        }
        ArrayList<RegistryValue> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/registry/Registry", "getAll"));
        }
        return arrayList;
    }

    void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>();
        old.putAll(this.myUserProperties);
        for (String each : old.keySet()) {
            try {
                Registry.get(each).resetToDefault();
            }
            catch (MissingResourceException e) {
                this.myValues.remove(each);
            }
        }
    }

    boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(@NotNull Map<String, String> map2) {
        if (map2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "map", "com/intellij/openapi/util/registry/Registry", "isRestartNeeded"));
        }
        for (String s : map2.keySet()) {
            RegistryValue eachValue = Registry.get(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    static {
        ourInstance = new Registry();
    }
}

