/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.pom.java;

import com.intellij.core.JavaCoreBundle;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LanguageLevel {
    JDK_1_3("Java 1.3", JavaCoreBundle.message("jdk.1.3.language.level.description", new Object[0]), "1.3", new String[0]),
    JDK_1_4("Java 1.4", JavaCoreBundle.message("jdk.1.4.language.level.description", new Object[0]), "1.4", new String[0]),
    JDK_1_5("Java 5.0", JavaCoreBundle.message("jdk.1.5.language.level.description", new Object[0]), "1.5", "5"),
    JDK_1_6("Java 6", JavaCoreBundle.message("jdk.1.6.language.level.description", new Object[0]), "1.6", "6"),
    JDK_1_7("Java 7", JavaCoreBundle.message("jdk.1.7.language.level.description", new Object[0]), "1.7", "7"),
    JDK_1_8("Java 8", JavaCoreBundle.message("jdk.1.8.language.level.description", new Object[0]), "1.8", "8"),
    JDK_1_9("Java 9", JavaCoreBundle.message("jdk.1.9.language.level.description", new Object[0]), "1.9", "9"),
    JDK_X("Java X", JavaCoreBundle.message("jdk.X.language.level.description", new Object[0]), "", new String[0]);

    public static final LanguageLevel HIGHEST;
    public static final Key<LanguageLevel> KEY;
    private final String myName;
    private final String myPresentableText;
    private final String myCompilerComplianceDefaultOption;
    private final String[] myCompilerComplianceOptionVariants;

    private LanguageLevel(@NotNull String name, @NotNull String presentableText, String compilerComplianceDefaultOption, String ... compilerComplianceAlternativeOptions) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        if (presentableText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentableText", "com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        if (compilerComplianceDefaultOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerComplianceDefaultOption", "com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        if (compilerComplianceAlternativeOptions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "compilerComplianceAlternativeOptions", "com/intellij/pom/java/LanguageLevel", "<init>"));
        }
        this.myName = name;
        this.myPresentableText = presentableText;
        this.myCompilerComplianceDefaultOption = compilerComplianceDefaultOption;
        this.myCompilerComplianceOptionVariants = ArrayUtil.prepend(compilerComplianceDefaultOption, compilerComplianceAlternativeOptions);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/java/LanguageLevel", "getName"));
        }
        return string;
    }

    @NotNull
    @Nls
    public String getPresentableText() {
        String string = this.myPresentableText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/pom/java/LanguageLevel", "getPresentableText"));
        }
        return string;
    }

    public boolean isAtLeast(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/pom/java/LanguageLevel", "isAtLeast"));
        }
        return this.compareTo(level) >= 0;
    }

    public boolean isLessThan(@NotNull LanguageLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "level", "com/intellij/pom/java/LanguageLevel", "isLessThan"));
        }
        return this.compareTo(level) < 0;
    }

    public String getCompilerComplianceDefaultOption() {
        return this.myCompilerComplianceDefaultOption;
    }

    @Nullable
    public static LanguageLevel parse(@Nullable String compilerComplianceOption) {
        if (StringUtil.isEmpty(compilerComplianceOption)) {
            return null;
        }
        for (LanguageLevel level : LanguageLevel.values()) {
            if (!ArrayUtil.contains(compilerComplianceOption, level.myCompilerComplianceOptionVariants)) continue;
            return level;
        }
        return null;
    }

    static {
        HIGHEST = JDK_1_8;
        KEY = Key.create("LANGUAGE_LEVEL");
    }
}

