/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.controlFlow;

import com.intellij.psi.controlFlow.InstructionKey;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

class InstructionKeySet {
    @NotNull
    private final Node myRoot;

    InstructionKeySet(int initialCapacity) {
        this.myRoot = new Node(initialCapacity);
    }

    void add(@NotNull InstructionKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/controlFlow/InstructionKeySet", "add"));
        }
        this.myRoot.add(key.getOffset(), key.getCallStack(), 0);
    }

    boolean contains(@NotNull InstructionKey key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/psi/controlFlow/InstructionKeySet", "contains"));
        }
        return this.myRoot.contains(key.getOffset(), key.getCallStack(), 0);
    }

    public String toString() {
        return this.myRoot.toString();
    }

    private static class Node
    extends TIntObjectHashMap<Node> {
        private Node(int initialCapacity) {
            super(Math.max(initialCapacity, 2));
        }

        private void add(int offset, @NotNull int[] stack, int level) {
            if (stack == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "com/intellij/psi/controlFlow/InstructionKeySet$Node", "add"));
            }
            if (level < stack.length) {
                Node node = (Node)((Object)this.get(offset));
                if (node == null) {
                    node = new Node(4);
                    this.put(offset, (Object)node);
                }
                node.add(stack[level], stack, level + 1);
            } else if (!this.containsKey(offset)) {
                this.put(offset, null);
            }
        }

        private boolean contains(int offset, @NotNull int[] stack, int level) {
            Node node;
            if (stack == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stack", "com/intellij/psi/controlFlow/InstructionKeySet$Node", "contains"));
            }
            if (level < stack.length && (node = (Node)((Object)this.get(offset))) != null) {
                return node.contains(stack[level], stack, level + 1);
            }
            return this.containsKey(offset);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("{");
            int[] offsets = this.keys();
            Arrays.sort(offsets);
            for (int offset : offsets) {
                if (sb.length() > 1) {
                    sb.append(", ");
                }
                sb.append(offset);
                Node node = (Node)((Object)this.get(offset));
                if (node == null) continue;
                sb.append((Object)node);
            }
            return sb.append("}").toString();
        }
    }
}

