/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.hierarchy;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexTree {
    public static final boolean STUB_HIERARCHY_ENABLED = Registry.is("java.hierarchy.service");
    public static final int PACKAGE = 1;
    public static final int CLASS = 2;
    public static final int ANNOTATION = 32;
    public static final int ENUM = 64;
    public static final int COMPILED = 128;
    public static final int MEMBER = 256;
    public static final int SUPERS_UNRESOLVED = 512;
    public static final byte BYTECODE = 0;
    public static final byte JAVA = 1;
    public static final byte GROOVY = 2;

    public static class MemberDecl
    extends Decl {
        public MemberDecl(Decl[] decls) {
            super(decls);
        }
    }

    public static class ClassDecl
    extends Decl {
        public static final ClassDecl[] EMPTY_ARRAY = new ClassDecl[0];
        public final int myStubId;
        public final int myMods;
        public final String myName;
        public final String[] mySupers;

        public ClassDecl(int stubId, int mods, @Nullable String name, String[] supers, Decl[] decls) {
            super(decls);
            assert (stubId > 0);
            this.myStubId = stubId;
            this.myMods = mods;
            this.myName = name;
            this.mySupers = supers;
        }
    }

    public static abstract class Decl {
        public static final Decl[] EMPTY_ARRAY = new Decl[0];
        public final Decl[] myDecls;

        protected Decl(Decl[] decls) {
            this.myDecls = decls;
        }
    }

    public static class Import {
        public static final Import[] EMPTY_ARRAY = new Import[0];
        @NotNull
        public final String myQualifier;
        @Nullable
        public final String myImportedName;
        public final boolean myStaticImport;
        public final boolean myOnDemand;
        @Nullable
        public final String myAlias;

        public Import(String fullname, boolean staticImport, boolean onDemand, @Nullable String alias) {
            this.myQualifier = onDemand ? fullname : StringUtil.getPackageName(fullname);
            this.myImportedName = onDemand ? null : StringUtil.getShortName(fullname);
            this.myStaticImport = staticImport;
            this.myOnDemand = onDemand;
            this.myAlias = alias;
        }
    }

    public static class Unit {
        @NotNull
        public final String myPackageName;
        public final byte myUnitType;
        public final Import[] imports;
        public final ClassDecl[] myDecls;

        public Unit(@Nullable String packageName, byte unitType, Import[] imports2, ClassDecl[] decls) {
            this.myPackageName = StringUtil.notNullize(packageName);
            this.myUnitType = unitType;
            this.imports = imports2;
            this.myDecls = decls;
        }
    }
}

