/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.navigation.NavigationItem;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.OriginInfoAwareElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.ElementPresentationUtil;
import com.intellij.psi.impl.light.LightElement;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.ui.RowIcon;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.PlatformIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightVariableBuilder<T extends LightVariableBuilder>
extends LightElement
implements PsiVariable,
NavigationItem,
OriginInfoAwareElement {
    private final String myName;
    private final PsiType myType;
    private volatile LightModifierList myModifierList;
    private volatile Icon myBaseIcon;
    private String myOriginInfo;

    public LightVariableBuilder(@NotNull String name, @NotNull String type2, @NotNull PsiElement navigationElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        this(name, JavaPsiFacade.getElementFactory(navigationElement.getProject()).createTypeFromText(type2, navigationElement), navigationElement);
    }

    public LightVariableBuilder(@NotNull String name, @NotNull PsiType type2, @NotNull PsiElement navigationElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (navigationElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "navigationElement", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        this(navigationElement.getManager(), name, type2, JavaLanguage.INSTANCE);
        this.setNavigationElement(navigationElement);
    }

    public LightVariableBuilder(PsiManager manager, @NotNull String name, @NotNull PsiType type2, @NotNull Language language) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        if (language == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "language", "com/intellij/psi/impl/light/LightVariableBuilder", "<init>"));
        }
        super(manager, language);
        this.myBaseIcon = PlatformIcons.VARIABLE_ICON;
        this.myName = name;
        this.myType = type2;
        this.myModifierList = new LightModifierList(manager);
    }

    @Override
    public String toString() {
        return "LightVariableBuilder:" + this.getName();
    }

    @Override
    @NotNull
    public PsiType getType() {
        PsiType psiType = this.myType;
        if (psiType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightVariableBuilder", "getType"));
        }
        return psiType;
    }

    @Override
    @NotNull
    public PsiModifierList getModifierList() {
        LightModifierList lightModifierList = this.myModifierList;
        if (lightModifierList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightVariableBuilder", "getModifierList"));
        }
        return lightModifierList;
    }

    public T setModifiers(String ... modifiers) {
        this.myModifierList = new LightModifierList(this.getManager(), this.getLanguage(), modifiers);
        return (T)this;
    }

    public T setModifierList(LightModifierList modifierList) {
        this.myModifierList = modifierList;
        return (T)this;
    }

    @Override
    public boolean hasModifierProperty(@NonNls @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightVariableBuilder", "hasModifierProperty"));
        }
        return this.myModifierList.hasModifierProperty(name);
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightVariableBuilder", "getName"));
        }
        return string;
    }

    @Override
    public PsiTypeElement getTypeElement() {
        return null;
    }

    @Override
    public PsiExpression getInitializer() {
        return null;
    }

    @Override
    public boolean hasInitializer() {
        return false;
    }

    @Override
    public void normalizeDeclaration() throws IncorrectOperationException {
    }

    @Override
    public Object computeConstantValue() {
        return null;
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/light/LightVariableBuilder", "setName"));
        }
        throw new UnsupportedOperationException("setName is not implemented yet in com.intellij.psi.impl.light.LightVariableBuilder");
    }

    @Override
    protected boolean isVisibilitySupported() {
        return true;
    }

    @Override
    public Icon getElementIcon(int flags) {
        RowIcon baseIcon = ElementPresentationUtil.createLayeredIcon(this.myBaseIcon, this, false);
        return ElementPresentationUtil.addVisibilityIcon(this, flags, baseIcon);
    }

    public T setBaseIcon(Icon baseIcon) {
        this.myBaseIcon = baseIcon;
        return (T)this;
    }

    @Override
    @Nullable
    public String getOriginInfo() {
        return this.myOriginInfo;
    }

    public void setOriginInfo(@Nullable String originInfo) {
        this.myOriginInfo = originInfo;
    }
}

