/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiAnonymousClassImpl
extends PsiClassImpl
implements PsiAnonymousClass {
    private SoftReference<PsiClassType> myCachedBaseType;

    public PsiAnonymousClassImpl(PsiClassStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANONYMOUS_CLASS);
    }

    public PsiAnonymousClassImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiAnonymousClassImpl clone = (PsiAnonymousClassImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    @Override
    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.getNode().findChildByRoleAsPsiElement(73);
    }

    @Override
    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiElement baseRef = this.getFirstChild();
        assert (baseRef instanceof PsiJavaCodeReferenceElement) : this.getText();
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)baseRef;
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassReference"));
        }
        return psiJavaCodeReferenceElement;
    }

    @Override
    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub == null) {
            this.myCachedBaseType = null;
            PsiClassType psiClassType = this.getTypeByTree();
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        PsiClassType type2 = SoftReference.dereference(this.myCachedBaseType);
        if (type2 != null) {
            PsiClassType psiClassType = type2;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        if (!this.isInQualifiedNew() && !this.isDiamond(stub)) {
            String refText = stub.getBaseClassReferenceText();
            assert (refText != null) : stub;
            PsiElementFactory factory = JavaPsiFacade.getInstance(this.getProject()).getElementFactory();
            PsiElement context = this.calcBasesResolveContext(PsiNameHelper.getShortClassName(refText), this.getExtendsList());
            try {
                PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(refText, context);
                ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                type2 = factory.createType(ref);
            }
            catch (IncorrectOperationException e) {
                type2 = PsiType.getJavaLangObject(this.getManager(), this.getResolveScope());
            }
            this.myCachedBaseType = new SoftReference<PsiClassType>(type2);
            PsiClassType psiClassType = type2;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        PsiClassType psiClassType = this.getTypeByTree();
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
        }
        return psiClassType;
    }

    private boolean isDiamond(PsiClassStub stub) {
        String referenceText;
        if (PsiUtil.isLanguageLevel9OrHigher(this) && (referenceText = stub.getBaseClassReferenceText()) != null && referenceText.endsWith(">")) {
            return StringUtil.trimEnd(referenceText, ">").trim().endsWith("<");
        }
        return false;
    }

    private PsiClassType getTypeByTree() {
        return JavaPsiFacade.getInstance(this.getProject()).getElementFactory().createType(this.getBaseClassReference());
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "hasModifierProperty"));
        }
        return name.equals("final");
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnonymousClass(this);
        } else {
            visitor.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (lastParent instanceof PsiExpressionList) {
            return true;
        }
        if (lastParent instanceof PsiJavaCodeReferenceElement && lastParent.getParent() == this && lastParent == this.getBaseClassReference()) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    @Override
    public boolean isInQualifiedNew() {
        PsiClassStub stub = (PsiClassStub)this.getGreenStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent = this.getParent();
        return parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null;
    }
}

